/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import io.piano.analytics.BuiltModel;
import io.piano.analytics.Configuration;
import io.piano.analytics.CustomerContextModel;
import io.piano.analytics.Event;
import io.piano.analytics.PrivacyModel;
import io.piano.analytics.User;
import io.piano.analytics.UserModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Model {
    private Configuration configuration = new Configuration();
    private List<Event> events = new ArrayList<Event>();
    private Map<String, Object> contextProperties = new HashMap<String, Object>();
    private Map<String, BuiltModel> storage = new HashMap<String, BuiltModel>();
    private int storageDaysRemaining;
    private User user = null;
    private CustomerContextModel customerContextModel;
    private UserModel userModel;
    private PrivacyModel privacyModel;
    private BuiltModel builtModel;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public Map<String, Object> getContextProperties() {
        return this.contextProperties;
    }

    public Map<String, BuiltModel> getStorage() {
        return this.storage;
    }

    public PrivacyModel getPrivacyModel() {
        return this.privacyModel;
    }

    public BuiltModel getBuiltModel() {
        return this.builtModel;
    }

    public String getVisitorId() {
        return this.configuration.get(Configuration.ConfigurationKey.VISITOR_ID);
    }

    public User getStoredUser() {
        return this.user;
    }

    Model() {
    }

    Model Config(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    Model setVisitorId(String visitorID) {
        this.configuration.set(Configuration.ConfigurationKey.VISITOR_ID, visitorID);
        return this;
    }

    Model setEvents(List<Event> events) {
        this.events = events;
        return this;
    }

    Model addContextProperty(String key, Object value) {
        this.contextProperties.put(key, value);
        return this;
    }

    Model addContextProperties(Map<String, Object> properties) {
        this.contextProperties.putAll(properties);
        return this;
    }

    Model setContextProperties(Map<String, Object> contextProperties) {
        this.contextProperties = contextProperties;
        return this;
    }

    CustomerContextModel getCustomerContextModel() {
        return this.customerContextModel;
    }

    Model setCustomerContextModel(CustomerContextModel customerContextModel) {
        this.customerContextModel = customerContextModel;
        return this;
    }

    int getStorageDaysRemaining() {
        return this.storageDaysRemaining;
    }

    Model setStorageDaysRemaining(int storageDaysRemaining) {
        this.storageDaysRemaining = storageDaysRemaining;
        return this;
    }

    UserModel getUserModel() {
        return this.userModel;
    }

    Model setUserModel(UserModel userModel) {
        this.userModel = userModel;
        return this;
    }

    Model setUser(User user) {
        this.user = user;
        return this;
    }

    Model setPrivacyModel(PrivacyModel privacyModel) {
        this.privacyModel = privacyModel;
        return this;
    }

    Model setStorage(Map<String, BuiltModel> storage) {
        this.storage = storage;
        return this;
    }

    Model setBuiltModel(BuiltModel builtModel) {
        this.builtModel = builtModel;
        return this;
    }
}

