/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import android.content.Context;
import androidx.annotation.NonNull;
import io.piano.analytics.BuiltModel;
import io.piano.analytics.Configuration;
import io.piano.analytics.CustomerContextModel;
import io.piano.analytics.Event;
import io.piano.analytics.ListUtils;
import io.piano.analytics.MapUtils;
import io.piano.analytics.Model;
import io.piano.analytics.PianoAnalyticsUtils;
import io.piano.analytics.PrivacyModel;
import io.piano.analytics.User;
import io.piano.analytics.UserModel;
import io.piano.analytics.WorkingQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public final class PianoAnalytics {
    static final Logger InternalLogger = Logger.getLogger("PIANO-ANALYTICS");
    static final int DEFAULT_STORAGE_LIFETIME_PRIVACY = 395;
    static final int DEFAULT_STORAGE_LIFETIME_VISITOR = 395;
    static final int DEFAULT_STORAGE_LIFETIME_USER = 395;
    private final Map<String, Boolean> visitorConsentByMode = this.getVisitorConsentByMode();
    private final Map<String, String> customVisitorIDByMode = this.getCustomVisitorIDByMode();
    private static final String DEFAULT_CONFIG_FILE = "piano-analytics-config.json";
    private static PianoAnalytics instance = null;
    private final WorkingQueue queue;

    private PianoAnalytics(Context ctx, String configFileLocation) {
        this.queue = new WorkingQueue(ctx.getApplicationContext(), configFileLocation);
    }

    public static PianoAnalytics getInstance(@NonNull Context ctx) {
        return PianoAnalytics.getInstance(ctx, DEFAULT_CONFIG_FILE);
    }

    public static PianoAnalytics getInstance(@NonNull Context ctx, @NonNull String configFileLocation) {
        if (instance == null) {
            instance = new PianoAnalytics(ctx, configFileLocation);
        }
        return instance;
    }

    private Map<String, Boolean> getVisitorConsentByMode() {
        HashMap<String, Boolean> m = new HashMap<String, Boolean>();
        m.put(PrivacyVisitorMode.OPTIN.stringValue(), true);
        m.put(PrivacyVisitorMode.OPTOUT.stringValue(), false);
        m.put(PrivacyVisitorMode.NO_CONSENT.stringValue(), false);
        m.put(PrivacyVisitorMode.NO_STORAGE.stringValue(), false);
        m.put(PrivacyVisitorMode.EXEMPT.stringValue(), false);
        m.put(PrivacyVisitorMode.ALL.stringValue(), false);
        return m;
    }

    private Map<String, String> getCustomVisitorIDByMode() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(PrivacyVisitorMode.OPTIN.stringValue(), null);
        m.put(PrivacyVisitorMode.OPTOUT.stringValue(), "opt-out");
        m.put(PrivacyVisitorMode.NO_CONSENT.stringValue(), "no-consent");
        m.put(PrivacyVisitorMode.NO_STORAGE.stringValue(), "no-storage");
        m.put(PrivacyVisitorMode.EXEMPT.stringValue(), "exempt");
        m.put(PrivacyVisitorMode.ALL.stringValue(), null);
        return m;
    }

    private void createMode(String mode, boolean consent) {
        this.visitorConsentByMode.put(mode, consent);
        this.customVisitorIDByMode.put(mode, mode);
    }

    private Boolean getVisitorConsentByMode(String mode) {
        return MapUtils.getFirstValue(this.visitorConsentByMode, mode, PrivacyVisitorMode.ALL.stringValue());
    }

    private String getCustomVisitorIDByMode(String mode) {
        return MapUtils.getFirstValue(this.customVisitorIDByMode, mode, PrivacyVisitorMode.ALL.stringValue());
    }

    private boolean modeExists(String mode) {
        return this.visitorConsentByMode.containsKey(mode);
    }

    public void sendEvent(@NonNull Event event) {
        this.sendEvents(Collections.singletonList(event), null, null);
    }

    public void sendEvent(@NonNull Event event, Configuration config) {
        this.sendEvents(Collections.singletonList(event), config, null);
    }

    public void sendEvent(@NonNull Event event, Configuration config, OnWorkListener l) {
        this.sendEvents(Collections.singletonList(event), config, l);
    }

    public void sendEvents(@NonNull List<Event> events) {
        this.sendEvents(events, null, null);
    }

    public void sendEvents(@NonNull List<Event> events, Configuration config) {
        this.sendEvents(events, config, null);
    }

    public void sendEvents(@NonNull List<Event> events, Configuration config, OnWorkListener l) {
        if (ListUtils.isEmpty(events).booleanValue()) {
            return;
        }
        Model m = new Model().setEvents(new ArrayList<Event>(events));
        if (config != null) {
            if (config.containsKey(Configuration.ConfigurationKey.VISITOR_ID)) {
                config.set(Configuration.ConfigurationKey.VISITOR_ID_TYPE, Configuration.VisitorIDType.CUSTOM.stringValue());
            }
            m.Config(config.getRootConfiguration());
        }
        this.queue.push(WorkingQueue.ProcessingType.TRACK_EVENTS, m, l);
    }

    public void getConfiguration(Configuration.ConfigurationKey key, OnGetConfigurationListener l) {
        this.queue.getConfigurationAsync(key, l);
    }

    public void setConfiguration(Configuration.ConfigurationKey key, String value) {
        Configuration config = new Configuration();
        config.set(key, value);
        this.setConfiguration(config);
    }

    public void setConfiguration(@NonNull Configuration config) {
        if (config == null) {
            return;
        }
        Model m = new Model().Config(new Configuration(config));
        this.queue.push(WorkingQueue.ProcessingType.SET_CONFIG, m, null);
    }

    public void setProperty(String key, Object value) {
        this.setProperty(key, value, false, null);
    }

    public void setProperty(String key, Object value, Boolean persistent) {
        this.setProperty(key, value, persistent, null);
    }

    public void setProperty(String key, Object value, Boolean persistent, String[] events) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(key, value);
        this.setProperties(data, persistent, events);
    }

    public void setProperties(@NonNull Map<String, Object> data) {
        this.setProperties(data, false, null);
    }

    public void setProperties(@NonNull Map<String, Object> data, Boolean persistent) {
        this.setProperties(data, persistent, null);
    }

    public void setProperties(@NonNull Map<String, Object> data, Boolean persistent, String[] events) {
        if (data == null || data.isEmpty()) {
            return;
        }
        Model m = new Model().setCustomerContextModel(new CustomerContextModel(CustomerContextModel.UpdateTypeKey.ADD, MapUtils.toFlatten(data), persistent, events));
        this.queue.push(WorkingQueue.ProcessingType.UPDATE_CONTEXT, m, null);
    }

    public void deleteProperty(@NonNull String key) {
        if (PianoAnalyticsUtils.isEmptyString(key)) {
            return;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(key, true);
        Model m = new Model().setCustomerContextModel(new CustomerContextModel(CustomerContextModel.UpdateTypeKey.DELETE, properties));
        this.queue.push(WorkingQueue.ProcessingType.UPDATE_CONTEXT, m, null);
    }

    public void getUser(OnGetUserListener l) {
        if (l == null) {
            return;
        }
        this.queue.getUserAsync(l);
    }

    public void setUser(@NonNull String userId) {
        this.setUser(userId, null, true);
    }

    public void setUser(@NonNull String userId, String userCategory) {
        this.setUser(userId, userCategory, true);
    }

    public void setUser(@NonNull String userId, String userCategory, boolean enableStorage) {
        if (PianoAnalyticsUtils.isEmptyString(userId)) {
            return;
        }
        Model m = new Model().setUserModel(new UserModel(UserModel.UpdateTypeKey.SET, enableStorage).setUser(new User(userId).setCategory(userCategory)));
        this.queue.push(WorkingQueue.ProcessingType.UPDATE_CONTEXT, m, null);
    }

    public void deleteUser() {
        Model m = new Model().setUserModel(new UserModel(UserModel.UpdateTypeKey.DELETE, false));
        this.queue.push(WorkingQueue.ProcessingType.UPDATE_CONTEXT, m, null);
    }

    public void privacyCreateMode(@NonNull String mode, boolean consent) {
        if (PianoAnalyticsUtils.isEmptyString(mode) || mode.equals("*") || this.modeExists(mode)) {
            return;
        }
        this.createMode(mode, consent);
        PrivacyModel privacyModel = new PrivacyModel(mode, PrivacyModel.UpdateDataKey.NEW_VISITOR_MODE).setVisitorConsent(consent).setCustomVisitorId(mode);
        Model m = new Model().setPrivacyModel(privacyModel);
        this.queue.push(WorkingQueue.ProcessingType.UPDATE_PRIVACY_CONTEXT, m, null);
    }

    public void privacySetMode(@NonNull String mode) {
        if (PianoAnalyticsUtils.isEmptyString(mode) || mode.equals("*") || !this.modeExists(mode)) {
            return;
        }
        Boolean consent = this.getVisitorConsentByMode(mode);
        String customVisitorID = this.getCustomVisitorIDByMode(mode);
        if (PianoAnalyticsUtils.isEmptyString(customVisitorID)) {
            customVisitorID = mode;
        }
        PrivacyModel privacyModel = new PrivacyModel(mode, PrivacyModel.UpdateDataKey.VISITOR_MODE).setVisitorConsent(consent).setCustomVisitorId(customVisitorID);
        Model m = new Model().setPrivacyModel(privacyModel);
        this.queue.push(WorkingQueue.ProcessingType.UPDATE_PRIVACY_CONTEXT, m, null);
    }

    public void privacyGetMode(OnGetPrivacyModeListener l) {
        this.queue.getPrivacyModeAsync(l);
    }

    public void privacyIncludeEvent(String eventName) {
        this.privacyIncludeEvents(new String[]{eventName}, new String[]{PrivacyVisitorMode.ALL.stringValue()});
    }

    public void privacyIncludeEvent(String eventName, String[] privacyModes) {
        this.privacyIncludeEvents(new String[]{eventName}, privacyModes);
    }

    public void privacyIncludeEvents(@NonNull String[] eventsName) {
        this.privacyIncludeEvents(eventsName, new String[]{PrivacyVisitorMode.ALL.stringValue()});
    }

    public void privacyIncludeEvents(@NonNull String[] eventsName, String[] privacyModes) {
        if (eventsName == null || eventsName.length == 0) {
            return;
        }
        if (privacyModes == null || privacyModes.length == 0) {
            privacyModes = new String[]{"*"};
        }
        for (String privacyMode : privacyModes) {
            PrivacyModel privacyModel = new PrivacyModel(privacyMode, PrivacyModel.UpdateDataKey.EVENTS_NAME).setAuthorizedEventsName(new HashSet<String>(Arrays.asList(eventsName)));
            Model m = new Model().setPrivacyModel(privacyModel);
            this.queue.push(WorkingQueue.ProcessingType.UPDATE_PRIVACY_CONTEXT, m, null);
        }
    }

    public void privacyExcludeEvent(String eventName) {
        this.privacyExcludeEvents(new String[]{eventName}, new String[]{PrivacyVisitorMode.ALL.stringValue()});
    }

    public void privacyExcludeEvent(String eventName, String[] privacyModes) {
        this.privacyExcludeEvents(new String[]{eventName}, privacyModes);
    }

    public void privacyExcludeEvents(@NonNull String[] eventsName) {
        this.privacyExcludeEvents(eventsName, new String[]{PrivacyVisitorMode.ALL.stringValue()});
    }

    public void privacyExcludeEvents(@NonNull String[] eventsName, String[] privacyModes) {
        if (eventsName == null || eventsName.length == 0) {
            return;
        }
        if (privacyModes == null || privacyModes.length == 0) {
            privacyModes = new String[]{"*"};
        }
        for (String privacyMode : privacyModes) {
            PrivacyModel privacyModel = new PrivacyModel(privacyMode, PrivacyModel.UpdateDataKey.EVENTS_NAME).setForbiddenEventsName(new HashSet<String>(Arrays.asList(eventsName)));
            Model m = new Model().setPrivacyModel(privacyModel);
            this.queue.push(WorkingQueue.ProcessingType.UPDATE_PRIVACY_CONTEXT, m, null);
        }
    }

    public void privacyIncludeProperty(@NonNull String property) {
        this.privacyIncludeProperties(new String[]{property}, null, null);
    }

    public void privacyIncludeProperty(@NonNull String property, String[] privacyModes) {
        this.privacyIncludeProperties(new String[]{property}, privacyModes, null);
    }

    public void privacyIncludeProperty(@NonNull String property, String[] privacyModes, String[] eventNames) {
        this.privacyIncludeProperties(new String[]{property}, privacyModes, eventNames);
    }

    public void privacyIncludeProperties(@NonNull String[] properties) {
        this.privacyIncludeProperties(properties, null, null);
    }

    public void privacyIncludeProperties(@NonNull String[] properties, String[] privacyModes) {
        this.privacyIncludeProperties(properties, privacyModes, null);
    }

    public void privacyIncludeProperties(@NonNull String[] properties, String[] privacyVisitorModes, String[] eventNames) {
        if (properties == null || properties.length == 0) {
            return;
        }
        if (privacyVisitorModes == null || privacyVisitorModes.length == 0) {
            privacyVisitorModes = new String[]{"*"};
        }
        if (eventNames == null || eventNames.length == 0) {
            eventNames = new String[]{"*"};
        }
        for (String privacyVisitorMode : privacyVisitorModes) {
            HashMap<String, Set<String>> propertiesByEvents = new HashMap<String, Set<String>>();
            for (String eventName : eventNames) {
                propertiesByEvents.put(eventName, new HashSet<String>(Arrays.asList(properties)));
            }
            PrivacyModel privacyModel = new PrivacyModel(privacyVisitorMode, PrivacyModel.UpdateDataKey.PROPERTIES).setAuthorizedPropertyKeys(propertiesByEvents);
            Model m = new Model().setPrivacyModel(privacyModel);
            this.queue.push(WorkingQueue.ProcessingType.UPDATE_PRIVACY_CONTEXT, m, null);
        }
    }

    public void privacyExcludeProperty(@NonNull String property) {
        this.privacyExcludeProperties(new String[]{property}, null, null);
    }

    public void privacyExcludeProperty(@NonNull String property, String[] privacyModes) {
        this.privacyExcludeProperties(new String[]{property}, privacyModes, null);
    }

    public void privacyExcludeProperty(@NonNull String property, String[] privacyModes, String[] eventNames) {
        this.privacyExcludeProperties(new String[]{property}, privacyModes, eventNames);
    }

    public void privacyExcludeProperties(@NonNull String[] properties) {
        this.privacyExcludeProperties(properties, null, null);
    }

    public void privacyExcludeProperties(@NonNull String[] properties, String[] privacyModes) {
        this.privacyExcludeProperties(properties, privacyModes, null);
    }

    public void privacyExcludeProperties(@NonNull String[] properties, String[] privacyModes, String[] eventNames) {
        if (properties == null || properties.length == 0) {
            return;
        }
        if (privacyModes == null || privacyModes.length == 0) {
            privacyModes = new String[]{"*"};
        }
        if (eventNames == null || eventNames.length == 0) {
            eventNames = new String[]{"*"};
        }
        for (String privacyVisitorMode : privacyModes) {
            HashMap<String, Set<String>> propertiesByEvents = new HashMap<String, Set<String>>();
            for (String eventName : eventNames) {
                propertiesByEvents.put(eventName, new HashSet<String>(Arrays.asList(properties)));
            }
            PrivacyModel privacyModel = new PrivacyModel(privacyVisitorMode, PrivacyModel.UpdateDataKey.PROPERTIES).setForbiddenPropertyKeys(propertiesByEvents);
            Model m = new Model().setPrivacyModel(privacyModel);
            this.queue.push(WorkingQueue.ProcessingType.UPDATE_PRIVACY_CONTEXT, m, null);
        }
    }

    public void privacyIncludeStorageKey(@NonNull PrivacyStorageFeature storageKey) {
        this.privacyIncludeStorageKeys(new PrivacyStorageFeature[]{storageKey}, null);
    }

    public void privacyIncludeStorageKey(@NonNull PrivacyStorageFeature storageKey, String[] privacyModes) {
        this.privacyIncludeStorageKeys(new PrivacyStorageFeature[]{storageKey}, privacyModes);
    }

    public void privacyIncludeStorageKeys(@NonNull PrivacyStorageFeature[] storageKeys) {
        this.privacyIncludeStorageKeys(storageKeys, null);
    }

    public void privacyIncludeStorageKeys(@NonNull PrivacyStorageFeature[] storageKeys, String[] privacyModes) {
        if (storageKeys == null || storageKeys.length == 0) {
            return;
        }
        if (privacyModes == null || privacyModes.length == 0) {
            privacyModes = new String[]{"*"};
        }
        for (String privacyVisitorMode : privacyModes) {
            PrivacyModel privacyModel = new PrivacyModel(privacyVisitorMode, PrivacyModel.UpdateDataKey.STORAGE).setAuthorizedStorageFeatures(new HashSet<PrivacyStorageFeature>(Arrays.asList(storageKeys)));
            Model m = new Model().setPrivacyModel(privacyModel);
            this.queue.push(WorkingQueue.ProcessingType.UPDATE_PRIVACY_CONTEXT, m, null);
        }
    }

    public void privacyExcludeStorageKey(@NonNull PrivacyStorageFeature storageKey) {
        this.privacyExcludeStorageKeys(new PrivacyStorageFeature[]{storageKey}, null);
    }

    public void privacyExcludeStorageKey(@NonNull PrivacyStorageFeature storageKey, String[] privacyModes) {
        this.privacyExcludeStorageKeys(new PrivacyStorageFeature[]{storageKey}, privacyModes);
    }

    public void privacyExcludeStorageKeys(@NonNull PrivacyStorageFeature[] storageKeys) {
        this.privacyExcludeStorageKeys(storageKeys, null);
    }

    public void privacyExcludeStorageKeys(@NonNull PrivacyStorageFeature[] storageKeys, String[] privacyModes) {
        if (storageKeys == null || storageKeys.length == 0) {
            return;
        }
        if (privacyModes == null || privacyModes.length == 0) {
            privacyModes = new String[]{"*"};
        }
        for (String privacyVisitorMode : privacyModes) {
            PrivacyModel privacyModel = new PrivacyModel(privacyVisitorMode, PrivacyModel.UpdateDataKey.STORAGE).setForbiddenStorageFeatures(new HashSet<PrivacyStorageFeature>(Arrays.asList(storageKeys)));
            Model m = new Model().setPrivacyModel(privacyModel);
            this.queue.push(WorkingQueue.ProcessingType.UPDATE_PRIVACY_CONTEXT, m, null);
        }
    }

    public void sendOfflineData() {
        this.sendOfflineData(null, null);
    }

    public void sendOfflineData(Configuration config) {
        this.sendOfflineData(config, null);
    }

    public void sendOfflineData(Configuration config, OnWorkListener l) {
        Model m = new Model();
        if (config != null) {
            if (config.containsKey(Configuration.ConfigurationKey.VISITOR_ID)) {
                config.set(Configuration.ConfigurationKey.VISITOR_ID_TYPE, Configuration.VisitorIDType.CUSTOM.stringValue());
            }
            m.Config(config.getRootConfiguration());
        }
        this.queue.push(WorkingQueue.ProcessingType.SEND_OFFLINE_STORAGE, m, l);
    }

    public void deleteOfflineStorage() {
        this.deleteOfflineStorage(0);
    }

    public void deleteOfflineStorage(int remaining) {
        Model m = new Model().setStorageDaysRemaining(remaining);
        this.queue.push(WorkingQueue.ProcessingType.DELETE_OFFLINE_STORAGE, m, null);
    }

    public void getVisitorId(OnGetPrivacyIdListener l) {
        this.queue.getConfigurationAsync(Configuration.ConfigurationKey.VISITOR_ID, l::onGetPrivacyId);
    }

    public void setVisitorId(String visitorId) {
        this.setConfiguration(Configuration.ConfigurationKey.VISITOR_ID, visitorId);
    }

    public void getModel(@NonNull OnGetModelListener l) {
        if (l == null) {
            return;
        }
        this.queue.getModelAsync(l);
    }

    public static interface OnGetUserListener {
        public void onGetUser(User var1);
    }

    public static interface OnGetPrivacyIdListener {
        public void onGetPrivacyId(String var1);
    }

    public static interface OnGetPrivacyModeListener {
        public void onGetPrivacyMode(String var1);
    }

    public static interface OnGetConfigurationListener {
        public void onGetConfiguration(String var1);
    }

    public static interface OnGetModelListener {
        public void onGetModel(Model var1);
    }

    public static interface OnWorkListener {
        default public boolean onBeforeBuild(Model model) {
            return true;
        }

        default public boolean onBeforeSend(BuiltModel built, Map<String, BuiltModel> stored) {
            return true;
        }
    }

    public static enum PrivacyStorageFeature {
        VISITOR("pa_vid"),
        CRASH("pa_crash"),
        LIFECYCLE("pa_lifecycle"),
        PRIVACY("pa_privacy"),
        USER("pa_uid");

        private final String str;

        private PrivacyStorageFeature(String val) {
            this.str = val;
        }

        public static PrivacyStorageFeature fromString(String s) {
            for (PrivacyStorageFeature v : PrivacyStorageFeature.values()) {
                if (!v.stringValue().equalsIgnoreCase(s)) continue;
                return v;
            }
            InternalLogger.severe("PrivacyStorageFeature.fromString: fallback on null because requested value is unknown");
            return null;
        }

        public String stringValue() {
            return this.str;
        }
    }

    public static enum PrivacyVisitorMode {
        OPTIN("optin"),
        OPTOUT("optout"),
        EXEMPT("exempt"),
        NO_CONSENT("no-consent"),
        NO_STORAGE("no-storage"),
        CUSTOM("custom"),
        ALL("*");

        private final String str;

        private PrivacyVisitorMode(String val) {
            this.str = val;
        }

        public static PrivacyVisitorMode fromString(String s) {
            for (PrivacyVisitorMode v : PrivacyVisitorMode.values()) {
                if (!v.stringValue().equalsIgnoreCase(s)) continue;
                return v;
            }
            InternalLogger.severe("PrivacyVisitorMode.fromString: fallback on PrivacyVisitorMode.CUSTOM mode because requested value is unknown");
            return CUSTOM;
        }

        public String stringValue() {
            return this.str;
        }
    }
}

