/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import android.util.Pair;
import io.piano.analytics.MapUtils;
import io.piano.analytics.PianoAnalytics;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

final class PianoAnalyticsUtils {
    private PianoAnalyticsUtils() {
    }

    @SuppressLint(value={"MissingPermission", "SwitchIntDef"})
    static ConnectionType getConnection(Context ctx) {
        ConnectivityManager connectivityManager = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return ConnectionType.OFFLINE;
        }
        if (networkInfo.getType() == 1) {
            return ConnectionType.WIFI;
        }
        TelephonyManager telephonyManager = (TelephonyManager)ctx.getSystemService("phone");
        if (telephonyManager == null) {
            return ConnectionType.UNKNOWN;
        }
        try {
            switch (telephonyManager.getNetworkType()) {
                case 1: {
                    return ConnectionType.GPRS;
                }
                case 2: {
                    return ConnectionType.EDGE;
                }
                case 4: 
                case 7: 
                case 11: {
                    return ConnectionType.TWOG;
                }
                case 3: 
                case 5: 
                case 6: 
                case 12: {
                    return ConnectionType.THREEG;
                }
                case 8: 
                case 9: 
                case 10: {
                    return ConnectionType.THREEGPLUS;
                }
                case 13: 
                case 15: {
                    return ConnectionType.FOURG;
                }
                case 20: {
                    return ConnectionType.FIVEG;
                }
            }
            return ConnectionType.UNKNOWN;
        }
        catch (SecurityException e) {
            PianoAnalytics.InternalLogger.severe("Utils.getConnection : " + e.toString());
            return ConnectionType.UNKNOWN;
        }
    }

    static Pair<String, String> getApplicationProperties(Context ctx) {
        try {
            PackageManager pkgManager = ctx.getPackageManager();
            if (pkgManager == null) {
                throw new IllegalStateException("Invalid Package Manager");
            }
            String pkgName = ctx.getPackageName();
            if (pkgName == null) {
                throw new IllegalStateException("Invalid Package Name");
            }
            PackageInfo pkgInfo = pkgManager.getPackageInfo(pkgName, 0);
            if (pkgInfo == null) {
                throw new IllegalStateException("Invalid Package Info");
            }
            return new Pair((Object)pkgName, (Object)pkgInfo.versionName);
        }
        catch (PackageManager.NameNotFoundException e) {
            PianoAnalytics.InternalLogger.severe("Utils.getApplicationProperties : " + e.toString());
            return null;
        }
    }

    static boolean isClassUnavailable(String className) {
        if (PianoAnalyticsUtils.isEmptyString(className)) {
            return true;
        }
        try {
            Class.forName(className);
            return false;
        }
        catch (ClassNotFoundException ce) {
            return true;
        }
    }

    static boolean isEmptyString(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isEmptyInteger(Integer integer) {
        return integer == null || integer == 0;
    }

    public static boolean isEmptyUnsignedInteger(Integer unsignedInteger) {
        return unsignedInteger == null || unsignedInteger <= 0;
    }

    public static boolean isEmptyLong(Long nb) {
        return nb == null || nb == 0L;
    }

    public static boolean isEmptyUnsignedLong(Long unsignedLong) {
        return unsignedLong == null || unsignedLong <= 0L;
    }

    static boolean isEmptyArray(String[] arr) {
        return arr == null || arr.length == 0;
    }

    static long currentTimeMillis() {
        long timeMillis;
        int year;
        int retry = 3;
        do {
            --retry;
            timeMillis = System.currentTimeMillis();
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(timeMillis);
            year = cal.get(1);
            if (year >= 2000) continue;
            PianoAnalyticsUtils.sleep(100);
        } while (year < 2000 && retry > 0);
        return timeMillis;
    }

    static int convertMillisTo(TimeUnit unit, long t) {
        return (int)unit.convert(t, TimeUnit.MILLISECONDS);
    }

    static void sleep(int time) {
        try {
            TimeUnit.MILLISECONDS.sleep(time);
        }
        catch (InterruptedException e) {
            PianoAnalytics.InternalLogger.severe("PianoAnalyticsUtils.sleep : " + e.toString());
            Thread.currentThread().interrupt();
        }
    }

    static String getStringFromInputStream(InputStream is) {
        byte[] buffer;
        if (is == null) {
            return null;
        }
        try {
            buffer = new byte[is.available()];
            if (is.read(buffer) == -1) {
                throw new IOException("bad data read from input stream");
            }
        }
        catch (IOException e) {
            PianoAnalytics.InternalLogger.severe("PianoAnalyticsUtils.getStringFromInputStream : " + e.toString());
            buffer = new byte[]{};
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                PianoAnalytics.InternalLogger.severe("PianoAnalyticsUtils.getStringFromInputStream : " + e.toString());
            }
        }
        return new String(buffer);
    }

    static Map<PianoAnalytics.PrivacyVisitorMode, Map<String, Object>> getPrivacyConfig(String s) {
        if (PianoAnalyticsUtils.isEmptyString(s)) {
            return new HashMap<PianoAnalytics.PrivacyVisitorMode, Map<String, Object>>();
        }
        HashMap<PianoAnalytics.PrivacyVisitorMode, Map<String, Object>> map = new HashMap<PianoAnalytics.PrivacyVisitorMode, Map<String, Object>>();
        try {
            JSONObject jsonObject = new JSONObject(s);
            Iterator keysItr = jsonObject.keys();
            while (keysItr.hasNext()) {
                PianoAnalytics.PrivacyVisitorMode key = PianoAnalytics.PrivacyVisitorMode.fromString((String)keysItr.next());
                Object value = jsonObject.get(key.stringValue());
                if (!(value instanceof JSONObject)) {
                    throw new JSONException("type unexpected");
                }
                map.put(key, MapUtils.fromJSONObject((JSONObject)value));
            }
        }
        catch (JSONException e) {
            return new HashMap<PianoAnalytics.PrivacyVisitorMode, Map<String, Object>>();
        }
        return map;
    }

    public static <T> boolean contains(T[] arr, T value) {
        for (T t : arr) {
            if (t != value) continue;
            return true;
        }
        return false;
    }

    public static boolean simpleWildcardCompare(String[] arr, String str) {
        for (String s : arr) {
            int wildcardIndex = s.indexOf("*");
            if (wildcardIndex != 0 && (wildcardIndex != -1 || !str.equals(s)) && (wildcardIndex == -1 || !str.startsWith(s.substring(0, wildcardIndex)))) continue;
            return true;
        }
        return false;
    }

    static enum ConnectionType {
        GPRS("GPRS"),
        EDGE("EDGE"),
        TWOG("2G"),
        THREEG("3G"),
        THREEGPLUS("3G+"),
        FOURG("4G"),
        FIVEG("5G"),
        WIFI("WIFI"),
        OFFLINE("OFFLINE"),
        UNKNOWN("UNKNOWN");

        private final String str;

        private ConnectionType(String val) {
            this.str = val;
        }

        String stringValue() {
            return this.str;
        }
    }
}

