/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import io.piano.analytics.PianoAnalytics;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class PrivacyModel {
    private final UpdateDataKey updateDataKey;
    private final String visitorMode;
    private Map<String, Set<String>> authorizedPropertyKeys = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> forbiddenPropertyKeys = new HashMap<String, Set<String>>();
    private Set<String> authorizedEventsName = new HashSet<String>();
    private Set<String> forbiddenEventsName = new HashSet<String>();
    private Set<PianoAnalytics.PrivacyStorageFeature> authorizedStorageFeatures = new HashSet<PianoAnalytics.PrivacyStorageFeature>();
    private Set<PianoAnalytics.PrivacyStorageFeature> forbiddenStorageFeatures = new HashSet<PianoAnalytics.PrivacyStorageFeature>();
    private int duration;
    private boolean visitorConsent;
    private String customVisitorId;

    public String getVisitorMode() {
        return this.visitorMode;
    }

    public Set<String> getAuthorizedEventsName() {
        return this.authorizedEventsName;
    }

    public Set<String> getForbiddenEventsName() {
        return this.forbiddenEventsName;
    }

    public Map<String, Set<String>> getAuthorizedPropertyKeys() {
        return this.authorizedPropertyKeys;
    }

    public Map<String, Set<String>> getForbiddenPropertyKeys() {
        return this.forbiddenPropertyKeys;
    }

    public Set<PianoAnalytics.PrivacyStorageFeature> getAuthorizedStorageFeatures() {
        return this.authorizedStorageFeatures;
    }

    public Set<PianoAnalytics.PrivacyStorageFeature> getForbiddenStorageFeatures() {
        return this.forbiddenStorageFeatures;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isVisitorConsent() {
        return this.visitorConsent;
    }

    public String getCustomVisitorId() {
        return this.customVisitorId;
    }

    PrivacyModel(String visitorMode) {
        this(visitorMode, null);
    }

    PrivacyModel(String visitorMode, UpdateDataKey updateDataKey) {
        this.visitorMode = visitorMode;
        this.updateDataKey = updateDataKey;
    }

    UpdateDataKey getUpdateRequestKey() {
        return this.updateDataKey;
    }

    PrivacyModel setAuthorizedEventsName(Set<String> eventsName) {
        this.authorizedEventsName = new HashSet<String>(eventsName);
        return this;
    }

    PrivacyModel setForbiddenEventsName(Set<String> eventsName) {
        this.forbiddenEventsName = new HashSet<String>(eventsName);
        return this;
    }

    PrivacyModel setAuthorizedPropertyKeys(Map<String, Set<String>> authorizedPropertyKeys) {
        this.authorizedPropertyKeys = authorizedPropertyKeys;
        return this;
    }

    PrivacyModel setForbiddenPropertyKeys(Map<String, Set<String>> forbiddenPropertyKeys) {
        this.forbiddenPropertyKeys = forbiddenPropertyKeys;
        return this;
    }

    PrivacyModel setAuthorizedStorageFeatures(Set<PianoAnalytics.PrivacyStorageFeature> authorizedStorageFeatures) {
        this.authorizedStorageFeatures = new HashSet<PianoAnalytics.PrivacyStorageFeature>(authorizedStorageFeatures);
        return this;
    }

    PrivacyModel setForbiddenStorageFeatures(Set<PianoAnalytics.PrivacyStorageFeature> forbiddenStorageFeatures) {
        this.forbiddenStorageFeatures = new HashSet<PianoAnalytics.PrivacyStorageFeature>(forbiddenStorageFeatures);
        return this;
    }

    PrivacyModel setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    PrivacyModel setVisitorConsent(boolean visitorConsent) {
        this.visitorConsent = visitorConsent;
        return this;
    }

    PrivacyModel setCustomVisitorId(String customVisitorId) {
        this.customVisitorId = customVisitorId;
        return this;
    }

    static enum UpdateDataKey {
        VISITOR_MODE,
        NEW_VISITOR_MODE,
        EVENTS_NAME,
        PROPERTIES,
        STORAGE;

    }
}

