/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import androidx.annotation.NonNull;
import io.piano.analytics.CastUtils;
import io.piano.analytics.Configuration;
import io.piano.analytics.Event;
import io.piano.analytics.MapUtils;
import io.piano.analytics.Model;
import io.piano.analytics.PianoAnalytics;
import io.piano.analytics.PianoAnalyticsUtils;
import io.piano.analytics.PrivacyModel;
import io.piano.analytics.SetUtils;
import io.piano.analytics.WorkingQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

final class PrivacyStep
implements WorkingQueue.IStep {
    static PrivacyStep instance = null;
    private static Map<PianoAnalytics.PrivacyVisitorMode, Map<String, Object>> privacyDefaultConfig;
    private static final String privacyFileEvents = "events";
    private static final String privacyFileProperties = "properties";
    private static final String privacyFileStorage = "storage";
    private static final String privacyFileAuthorize = "allowed";
    private static final String privacyFileForbid = "forbidden";
    private final Map<String, Set<String>> authorizedEventsByMode;
    private final Map<String, Set<String>> forbiddenEventsByMode;
    private final Map<String, Map<String, Set<String>>> authorizedPropertiesByMode;
    private final Map<String, Map<String, Set<String>>> forbiddenPropertiesByMode;
    private final Map<String, Set<PianoAnalytics.PrivacyStorageFeature>> authorizedStorageFeatureByMode;
    private final Map<String, Set<PianoAnalytics.PrivacyStorageFeature>> forbiddenStorageFeatureByMode;
    private final Map<PianoAnalytics.PrivacyStorageFeature, Set<String>> storageKeysByFeature;
    private String defaultPrivacyMode;
    private int storageLifetimePrivacy;
    private final SharedPreferences sharedPreferences;
    private boolean inNoConsentMode = false;
    private boolean inNoStorageMode = false;
    static final String VISITOR_PRIVACY_CONSENT_PROPERTY = "visitor_privacy_consent";
    static final String VISITOR_PRIVACY_MODE_PROPERTY = "visitor_privacy_mode";
    static final String WILDCARD = "*";
    private static final String PAGE_PROPERTIES_FORMAT = "page_%s";

    static PrivacyStep getInstance(Context ctx, Configuration configuration) {
        if (instance == null) {
            instance = new PrivacyStep(ctx, configuration);
        }
        return instance;
    }

    private Map<String, Set<String>> createEventsNameByModeMapFromAction(String action) {
        HashMap<String, Set<String>> m = new HashMap<String, Set<String>>();
        for (PianoAnalytics.PrivacyVisitorMode mode : PianoAnalytics.PrivacyVisitorMode.values()) {
            Map events = this.getDeepInPrivacyConfig(mode, privacyFileEvents, action, new HashMap());
            m.put(mode.stringValue(), events.keySet());
        }
        return m;
    }

    private Map<String, Map<String, Set<String>>> createPropertiesByModeMapFromAction(String action) {
        HashMap<String, Map<String, Set<String>>> m = new HashMap<String, Map<String, Set<String>>>();
        for (PianoAnalytics.PrivacyVisitorMode mode : PianoAnalytics.PrivacyVisitorMode.values()) {
            HashMap properties = new HashMap();
            Map propertiesByEventName = this.getDeepInPrivacyConfig(mode, privacyFileProperties, action, new HashMap());
            for (Map.Entry entry : propertiesByEventName.entrySet()) {
                properties.put((String)entry.getKey(), ((Map)entry.getValue()).keySet());
            }
            m.put(mode.stringValue(), properties);
        }
        return m;
    }

    private Map<String, Set<PianoAnalytics.PrivacyStorageFeature>> createStorageFeatureByModeMapFromAction(String action) {
        HashMap<String, Set<PianoAnalytics.PrivacyStorageFeature>> m = new HashMap<String, Set<PianoAnalytics.PrivacyStorageFeature>>();
        for (PianoAnalytics.PrivacyVisitorMode mode : PianoAnalytics.PrivacyVisitorMode.values()) {
            Map storage = this.getDeepInPrivacyConfig(mode, privacyFileStorage, action, new HashMap());
            HashSet<PianoAnalytics.PrivacyStorageFeature> storageFeatures = new HashSet<PianoAnalytics.PrivacyStorageFeature>();
            for (String feature : storage.keySet()) {
                if (feature.equals(WILDCARD)) {
                    Collections.addAll(storageFeatures, PianoAnalytics.PrivacyStorageFeature.values());
                    break;
                }
                PianoAnalytics.PrivacyStorageFeature feat = PianoAnalytics.PrivacyStorageFeature.fromString(feature);
                if (feat == null) continue;
                storageFeatures.add(feat);
            }
            m.put(mode.stringValue(), storageFeatures);
        }
        return m;
    }

    private Map<PianoAnalytics.PrivacyStorageFeature, Set<String>> createStorageKeysByFeatureMap() {
        HashMap<PianoAnalytics.PrivacyStorageFeature, Set<String>> m = new HashMap<PianoAnalytics.PrivacyStorageFeature, Set<String>>();
        m.put(PianoAnalytics.PrivacyStorageFeature.VISITOR, new HashSet<String>(Arrays.asList("ATIdclientUUID", "PAIdclientUUID", "PAIdclientUUIDGenerationTimestamp")));
        m.put(PianoAnalytics.PrivacyStorageFeature.PRIVACY, new HashSet<String>(Arrays.asList("PAPrivacyMode", "PAPrivacyModeExpirationTimestamp", "PAPrivacyUserId", "PAPrivacyVisitorConsent")));
        m.put(PianoAnalytics.PrivacyStorageFeature.CRASH, new HashSet<String>(Arrays.asList("PACrashed", "PACrashInfo")));
        m.put(PianoAnalytics.PrivacyStorageFeature.LIFECYCLE, new HashSet<String>(Arrays.asList("PAFirstInitLifecycleDone", "PAInitLifecycleDone", "PAFirstLaunch", "PAFirstLaunchAfterUpdate", "PALaunchCount", "PALaunchCountSinceUpdate", "PADaysSinceFirstLaunch", "PADaysSinceLastUse", "PADaysSinceFirstLaunchAfterUpdate", "PAFirstLaunchDate", "PAFirstLaunchDateAfterUpdate", "PALastLaunchDate", "PAVersionCode")));
        m.put(PianoAnalytics.PrivacyStorageFeature.USER, new HashSet<String>(Arrays.asList("PAUser", "PAUserGenerationTimestamp")));
        return m;
    }

    private <T> T getDeepInPrivacyConfig(PianoAnalytics.PrivacyVisitorMode mode, String key1, String key2, T defaultValue) {
        Map<String, Object> privacyConfigForAll = privacyDefaultConfig.get((Object)mode);
        if (privacyConfigForAll == null || !privacyConfigForAll.containsKey(key1)) {
            return defaultValue;
        }
        Map eventsRule = (Map)privacyConfigForAll.get(key1);
        if (eventsRule == null || !eventsRule.containsKey(key2)) {
            return defaultValue;
        }
        return (T)eventsRule.get(key2);
    }

    PrivacyStep(Context ctx, Configuration configuration) {
        this.sharedPreferences = ctx.getSharedPreferences("PAPreferencesKey", 0);
        try {
            String ccc = configuration.get(Configuration.ConfigurationKey.STORAGE_LIFETIME_PRIVACY);
            this.storageLifetimePrivacy = Integer.parseInt(ccc);
        }
        catch (NumberFormatException e) {
            PianoAnalytics.InternalLogger.severe("PrivacyStep constructor error on parsing " + Configuration.ConfigurationKey.STORAGE_LIFETIME_PRIVACY.stringValue());
        }
        if (PianoAnalyticsUtils.isEmptyUnsignedInteger(this.storageLifetimePrivacy)) {
            this.storageLifetimePrivacy = 395;
        }
        String privacyConfigStr = "{\"optin\":{\"properties\":{\"include\":{\"visitor_privacy_consent\":true,\"visitor_privacy_mode\":\"optin\"},\"allowed\":{\"*\":{\"*\":true}},\"forbidden\":{\"*\":{}}},\"storage\":{\"allowed\":{\"*\":true},\"forbidden\":{}},\"events\":{\"allowed\":{\"*\":true},\"forbidden\":{}}},\"optout\":{\"visitorId\":\"OPT-OUT\",\"properties\":{\"include\":{\"visitor_privacy_consent\":false,\"visitor_privacy_mode\":\"optout\"},\"allowed\":{\"*\":{}},\"forbidden\":{\"*\":{}}},\"storage\":{\"allowed\":{\"pa_vid\":true,\"pa_privacy\":true},\"forbidden\":{}},\"events\":{\"allowed\":{\"*\":true},\"forbidden\":{}}},\"no-consent\":{\"visitorId\":\"Consent-NO\",\"properties\":{\"include\":{\"visitor_privacy_consent\":false,\"visitor_privacy_mode\":\"no-consent\"},\"allowed\":{\"*\":{}},\"forbidden\":{\"*\":{}}},\"storage\":{\"allowed\":{},\"forbidden\":{\"*\":true}},\"events\":{\"allowed\":{\"*\":true},\"forbidden\":{}}},\"no-storage\":{\"visitorId\":\"no-storage\",\"properties\":{\"include\":{\"visitor_privacy_consent\":false,\"visitor_privacy_mode\":\"no-storage\"},\"allowed\":{\"*\":{\"*\":true}},\"forbidden\":{\"*\":{}}},\"storage\":{\"allowed\":{},\"forbidden\":{\"*\":true}},\"events\":{\"allowed\":{\"*\":true},\"forbidden\":{}}},\"exempt\":{\"properties\":{\"include\":{\"visitor_privacy_consent\":false,\"visitor_privacy_mode\":\"exempt\"},\"allowed\":{\"*\":{\"device_model\":true,\"device_manufacturer\":true,\"app_crash\":true,\"app_crash_class\":true,\"app_crash_screen\":true,\"app_version\":true,\"browser\":true,\"browser_cookie_acceptance\":true,\"browser_group\":true,\"browser_version\":true,\"click\":true,\"click_chapter1\":true,\"click_chapter2\":true,\"click_chapter3\":true,\"click_full_name\":true,\"connection_monitor\":true,\"connection_organisation\":true,\"connection_type\":true,\"date\":true,\"date_day\":true,\"date_daynumber\":true,\"date_month\":true,\"date_monthnumber\":true,\"date_week\":true,\"date_year\":true,\"date_yearofweek\":true,\"device_brand\":true,\"device_display_height\":true,\"device_display_width\":true,\"device_name\":true,\"device_name_tech\":true,\"device_screen_diagonal\":true,\"device_screen_height\":true,\"device_screen_width\":true,\"device_timestamp_utc\":true,\"device_type\":true,\"event_collection_platform\":true,\"event_collection_version\":true,\"event_hour\":true,\"event_id\":true,\"event_minute\":true,\"event_name\":true,\"event_position\":true,\"event_second\":true,\"event_time\":true,\"event_time_utc\":true,\"event_url\":true,\"event_url_domain\":true,\"event_url_full\":true,\"exclusion_cause\":true,\"exclusion_type\":true,\"geo_city\":true,\"geo_continent\":true,\"geo_country\":true,\"geo_metro\":true,\"geo_region\":true,\"hit_time_utc\":true,\"os\":true,\"os_group\":true,\"os_version\":true,\"os_version_name\":true,\"page\":true,\"page_chapter1\":true,\"page_chapter2\":true,\"page_chapter3\":true,\"page_duration\":true,\"page_full_name\":true,\"page_position\":true,\"privacy_status\":true,\"site\":true,\"site_env\":true,\"site_id\":true,\"site_platform\":true,\"src\":true,\"src_detail\":true,\"src_direct_access\":true,\"src_organic\":true,\"src_organic_detail\":true,\"src_portal_domain\":true,\"src_portal_site\":true,\"src_portal_site_id\":true,\"src_portal_url\":true,\"src_referrer_site_domain\":true,\"src_referrer_site_url\":true,\"src_referrer_url\":true,\"src_se\":true,\"src_se_category\":true,\"src_se_country\":true,\"src_type\":true,\"src_url\":true,\"src_url_domain\":true,\"src_webmail\":true,\"visit_bounce\":true,\"visit_duration\":true,\"visit_entrypage\":true,\"visit_entrypage_chapter1\":true,\"visit_entrypage_chapter2\":true,\"visit_entrypage_chapter3\":true,\"visit_entrypage_full_name\":true,\"visit_exitpage\":true,\"visit_exitpage_chapter1\":true,\"visit_exitpage_chapter2\":true,\"visit_exitpage_chapter3\":true,\"visit_exitpage_full_name\":true,\"visit_hour\":true,\"visit_id\":true,\"visit_minute\":true,\"visit_page_view\":true,\"visit_second\":true,\"visit_time\":true,\"visit_privacy_consent\":true,\"visit_privacy_mode\":true}},\"forbidden\":{\"*\":{}}},\"storage\":{\"allowed\":{\"pa_vid\":true,\"pa_privacy\":true},\"forbidden\":{}},\"events\":{\"allowed\":{\"click.action\":true,\"click.download\":true,\"click.exit\":true,\"click.navigation\":true,\"page.display\":true},\"forbidden\":{}}},\"*\":{\"properties\":{\"allowed\":{\"*\":{\"connection_type\":true,\"device_timestamp_utc\":true,\"visitor_privacy_consent\":true,\"visitor_privacy_mode\":true}},\"forbidden\":{\"*\":{}}},\"storage\":{\"allowed\":{},\"forbidden\":{}},\"events\":{\"allowed\":{},\"forbidden\":{}}}}";
        privacyDefaultConfig = PianoAnalyticsUtils.getPrivacyConfig(privacyConfigStr);
        this.authorizedEventsByMode = this.createEventsNameByModeMapFromAction(privacyFileAuthorize);
        this.forbiddenEventsByMode = this.createEventsNameByModeMapFromAction(privacyFileForbid);
        this.authorizedPropertiesByMode = this.createPropertiesByModeMapFromAction(privacyFileAuthorize);
        this.forbiddenPropertiesByMode = this.createPropertiesByModeMapFromAction(privacyFileForbid);
        this.authorizedStorageFeatureByMode = this.createStorageFeatureByModeMapFromAction(privacyFileAuthorize);
        this.forbiddenStorageFeatureByMode = this.createStorageFeatureByModeMapFromAction(privacyFileForbid);
        this.storageKeysByFeature = this.createStorageKeysByFeatureMap();
        this.defaultPrivacyMode = configuration.get(Configuration.ConfigurationKey.PRIVACY_DEFAULT_MODE);
        if (PianoAnalyticsUtils.isEmptyString(this.defaultPrivacyMode) || !this.authorizedEventsByMode.containsKey(this.defaultPrivacyMode)) {
            this.defaultPrivacyMode = PianoAnalytics.PrivacyVisitorMode.OPTIN.stringValue();
        }
    }

    final void setInNoConsent(boolean b) {
        this.inNoConsentMode = b;
    }

    @SafeVarargs
    final void storeData(SharedPreferences.Editor editor, PianoAnalytics.PrivacyStorageFeature storageFeature, Pair<String, Object> ... pairs) {
        String visitorMode = this.getVisitorMode();
        for (Pair<String, Object> p : pairs) {
            String key = (String)p.first;
            Object v = p.second;
            if (v != null && !this.getVisitorModeAuthorizedStorageFeature(visitorMode).contains((Object)storageFeature) && !this.getVisitorModeAuthorizedStorageFeature(PianoAnalytics.PrivacyVisitorMode.ALL.stringValue()).contains((Object)storageFeature)) {
                v = null;
            }
            if (v != null && (this.getVisitorModeForbiddenStorageFeature(visitorMode).contains((Object)storageFeature) || this.getVisitorModeForbiddenStorageFeature(PianoAnalytics.PrivacyVisitorMode.ALL.stringValue()).contains((Object)storageFeature))) {
                v = null;
            }
            if (v == null) {
                editor.remove(key);
                continue;
            }
            if (v instanceof Boolean) {
                editor.putBoolean(key, ((Boolean)v).booleanValue());
                continue;
            }
            if (v instanceof String) {
                editor.putString(key, (String)v);
                continue;
            }
            if (v instanceof Long) {
                editor.putLong(key, ((Long)v).longValue());
                continue;
            }
            if (!(v instanceof Integer)) continue;
            editor.putInt(key, ((Integer)v).intValue());
        }
        editor.apply();
    }

    final <T> T getData(SharedPreferences prefs, PianoAnalytics.PrivacyStorageFeature storageFeature, String key, T defValue, T type) {
        Object value;
        if (storageFeature == null) {
            return null;
        }
        if (type instanceof Boolean) {
            value = prefs.getBoolean(key, ((Boolean)defValue).booleanValue());
        } else if (type instanceof String) {
            value = prefs.getString(key, (String)defValue);
        } else if (type instanceof Long) {
            value = prefs.getLong(key, ((Long)defValue).longValue());
        } else if (type instanceof Integer) {
            value = prefs.getInt(key, ((Integer)defValue).intValue());
        } else {
            return null;
        }
        if (value != null && !this.getVisitorModeAuthorizedStorageFeature(this.getVisitorMode()).contains((Object)storageFeature) && !this.getVisitorModeAuthorizedStorageFeature(PianoAnalytics.PrivacyVisitorMode.ALL.stringValue()).contains((Object)storageFeature)) {
            this.storeData(prefs.edit(), storageFeature, new Pair((Object)key, null));
            return null;
        }
        if (value != null && (this.getVisitorModeForbiddenStorageFeature(this.getVisitorMode()).contains((Object)storageFeature) || this.getVisitorModeForbiddenStorageFeature(PianoAnalytics.PrivacyVisitorMode.ALL.stringValue()).contains((Object)storageFeature))) {
            this.storeData(prefs.edit(), storageFeature, new Pair((Object)key, null));
            return null;
        }
        return (T)value;
    }

    Set<PianoAnalytics.PrivacyStorageFeature> getVisitorModeAuthorizedStorageFeature(String visitorMode) {
        return MapUtils.getValueOrPutDefault(this.authorizedStorageFeatureByMode, visitorMode, (Set)MapUtils.getValueOrPutDefault(this.authorizedStorageFeatureByMode, PianoAnalytics.PrivacyVisitorMode.EXEMPT.stringValue(), new HashSet()));
    }

    Set<PianoAnalytics.PrivacyStorageFeature> getVisitorModeForbiddenStorageFeature(String visitorMode) {
        return MapUtils.getValueOrPutDefault(this.forbiddenStorageFeatureByMode, visitorMode, (Set)MapUtils.getValueOrPutDefault(this.forbiddenStorageFeatureByMode, PianoAnalytics.PrivacyVisitorMode.EXEMPT.stringValue(), new HashSet()));
    }

    Set<String> getVisitorModeAuthorizedEventsName(String visitorMode) {
        return MapUtils.getValueOrPutDefault(this.authorizedEventsByMode, visitorMode, new HashSet<String>(Collections.singletonList(WILDCARD)));
    }

    Set<String> getVisitorModeForbiddenEventsName(String visitorMode) {
        return MapUtils.getValueOrPutDefault(this.forbiddenEventsByMode, visitorMode, new HashSet());
    }

    Map<String, Set<String>> getVisitorModeAuthorizedProperties(String visitorMode) {
        return MapUtils.getValueOrPutDefault(this.authorizedPropertiesByMode, visitorMode, new HashMap());
    }

    Map<String, Set<String>> getVisitorModeForbiddenProperties(String visitorMode) {
        return MapUtils.getValueOrPutDefault(this.forbiddenPropertiesByMode, visitorMode, new HashMap());
    }

    String getVisitorMode() {
        String visitorMode;
        if (this.inNoConsentMode) {
            return PianoAnalytics.PrivacyVisitorMode.NO_CONSENT.stringValue();
        }
        if (this.inNoStorageMode) {
            return PianoAnalytics.PrivacyVisitorMode.NO_STORAGE.stringValue();
        }
        long privacyModeExpirationTs = this.sharedPreferences.getLong("PAPrivacyModeExpirationTimestamp", -1L);
        if (privacyModeExpirationTs != -1L && PianoAnalyticsUtils.currentTimeMillis() >= privacyModeExpirationTs) {
            this.sharedPreferences.edit().putString("PAPrivacyMode", this.defaultPrivacyMode).putLong("PAPrivacyModeExpirationTimestamp", PianoAnalyticsUtils.currentTimeMillis() + (long)this.storageLifetimePrivacy * 86400000L).putBoolean("PAPrivacyVisitorConsent", true).remove("PAPrivacyUserId").apply();
        }
        if (!this.authorizedEventsByMode.containsKey(visitorMode = this.sharedPreferences.getString("PAPrivacyMode", this.defaultPrivacyMode))) {
            return this.defaultPrivacyMode;
        }
        return visitorMode;
    }

    boolean isAuthorizedEventName(String eventName, Set<String> authorizedEvents, Set<String> forbiddenEvents) {
        int wildcardIndex;
        if (authorizedEvents.size() == 0) {
            return false;
        }
        boolean isAuthorized = false;
        for (String name : authorizedEvents) {
            wildcardIndex = name.indexOf(WILDCARD);
            if (wildcardIndex != 0 && (wildcardIndex != -1 || !eventName.equals(name)) && (wildcardIndex == -1 || !name.startsWith(name.substring(0, wildcardIndex)))) continue;
            isAuthorized = true;
            break;
        }
        if (!isAuthorized) {
            return false;
        }
        for (String name : forbiddenEvents) {
            wildcardIndex = name.indexOf(WILDCARD);
            if (wildcardIndex != 0 && (wildcardIndex != -1 || !eventName.equals(name)) && (wildcardIndex == -1 || !name.startsWith(name.substring(0, wildcardIndex)))) continue;
            return false;
        }
        return true;
    }

    @NonNull
    Set<String> getPropertiesFromEventName(@NonNull Map<String, Set<String>> propertiesKeysByEventNames, String ... eventNames) {
        HashSet<String> authorizedPropertiesKeys = new HashSet<String>();
        block4: for (Map.Entry<String, Set<String>> eventNameEntry : propertiesKeysByEventNames.entrySet()) {
            int wildcardIndex = eventNameEntry.getKey().indexOf(WILDCARD);
            switch (wildcardIndex) {
                case 0: {
                    authorizedPropertiesKeys.addAll((Collection<String>)eventNameEntry.getValue());
                    break;
                }
                case -1: {
                    for (String eventName : eventNames) {
                        if (!eventName.equals(eventNameEntry.getKey())) continue;
                        authorizedPropertiesKeys.addAll((Collection<String>)eventNameEntry.getValue());
                    }
                    continue block4;
                }
                default: {
                    for (String eventName : eventNames) {
                        if (!eventName.startsWith(eventNameEntry.getKey().substring(0, wildcardIndex))) continue;
                        authorizedPropertiesKeys.addAll((Collection<String>)eventNameEntry.getValue());
                    }
                    continue block4;
                }
            }
        }
        return authorizedPropertiesKeys;
    }

    Map<String, Object> applyAuthorizedPropertiesPrivacyRules(Map<String, Object> data, Set<String> authorizedPropertiesKeys) {
        HashMap<String, Object> resultData = new HashMap<String, Object>();
        block4: for (String propertyKey : authorizedPropertiesKeys) {
            Object o;
            int wildcardIndex = propertyKey.indexOf(WILDCARD);
            switch (wildcardIndex) {
                case 0: {
                    return new HashMap<String, Object>(data);
                }
                case -1: {
                    o = data.get(propertyKey);
                    if (o == null) continue block4;
                    resultData.put(propertyKey, o);
                    continue block4;
                }
            }
            String prefixKey = propertyKey.substring(0, wildcardIndex);
            for (Map.Entry<String, Object> property : data.entrySet()) {
                String dataPropertyKey = property.getKey();
                if (!dataPropertyKey.startsWith(prefixKey) || (o = property.getValue()) == null) continue;
                resultData.put(dataPropertyKey, o);
            }
        }
        return resultData;
    }

    Map<String, Object> applyForbiddenPropertiesPrivacyRules(Map<String, Object> data, Set<String> forbiddenPropertiesKeys) {
        HashMap<String, Object> resultData = new HashMap<String, Object>(data);
        block4: for (String key : forbiddenPropertiesKeys) {
            int wildcardIndex = key.indexOf(WILDCARD);
            switch (wildcardIndex) {
                case 0: {
                    return new HashMap<String, Object>();
                }
                case -1: {
                    resultData.remove(key);
                    continue block4;
                }
            }
            String prefixKey = key.substring(0, wildcardIndex);
            ArrayList<String> keysToDelete = new ArrayList<String>();
            for (String propertyKey : resultData.keySet()) {
                if (!propertyKey.startsWith(prefixKey)) continue;
                keysToDelete.add(propertyKey);
            }
            for (String ktd : keysToDelete) {
                resultData.remove(ktd);
            }
        }
        return resultData;
    }

    private void clearStorageFromVisitorMode(String visitorMode, SharedPreferences.Editor editor) {
        for (Map.Entry<PianoAnalytics.PrivacyStorageFeature, Set<String>> entry : this.storageKeysByFeature.entrySet()) {
            PianoAnalytics.PrivacyStorageFeature storageFeature = entry.getKey();
            if (this.getVisitorModeAuthorizedStorageFeature(visitorMode).contains((Object)storageFeature) || this.getVisitorModeAuthorizedStorageFeature(PianoAnalytics.PrivacyVisitorMode.ALL.stringValue()).contains((Object)storageFeature) || !this.getVisitorModeForbiddenStorageFeature(visitorMode).contains((Object)storageFeature) || !this.getVisitorModeForbiddenStorageFeature(PianoAnalytics.PrivacyVisitorMode.ALL.stringValue()).contains((Object)storageFeature)) continue;
            Set<String> keys = entry.getValue();
            for (String key : keys) {
                editor.remove(key);
            }
        }
        editor.apply();
    }

    private boolean getPrivacyVisitorConsent() {
        return this.sharedPreferences.getBoolean("PAPrivacyVisitorConsent", false);
    }

    private String getPrivacyVisitorId() {
        if (this.inNoStorageMode) {
            return PianoAnalytics.PrivacyVisitorMode.NO_STORAGE.stringValue();
        }
        if (this.inNoConsentMode) {
            return PianoAnalytics.PrivacyVisitorMode.NO_CONSENT.stringValue();
        }
        if (PianoAnalytics.PrivacyVisitorMode.OPTOUT.stringValue().equals(this.getVisitorMode())) {
            return PianoAnalytics.PrivacyVisitorMode.OPTOUT.stringValue();
        }
        return this.sharedPreferences.getString("PAPrivacyUserId", null);
    }

    private int getPrivacyVisitorModeRemainingDuration() {
        long expiration = this.sharedPreferences.getLong("PAPrivacyModeExpirationTimestamp", -1L);
        if (expiration == -1L) {
            return 0;
        }
        long timeRemaining = expiration - PianoAnalyticsUtils.currentTimeMillis();
        return PianoAnalyticsUtils.convertMillisTo(TimeUnit.DAYS, timeRemaining);
    }

    private void updatePropertyMap(Map<String, Set<String>> currentPropertyKeys, Map<String, Set<String>> propertyKeysToAdd) {
        if (currentPropertyKeys == null) {
            currentPropertyKeys = new HashMap<String, Set<String>>();
        }
        if (propertyKeysToAdd == null) {
            return;
        }
        for (Map.Entry<String, Set<String>> eventName : propertyKeysToAdd.entrySet()) {
            HashSet<String> lowercaseProperties = new HashSet<String>();
            for (String propertyKey : eventName.getValue()) {
                lowercaseProperties.add(propertyKey.toLowerCase());
            }
            if (currentPropertyKeys.get(eventName.getKey().toLowerCase()) == null) {
                currentPropertyKeys.put(eventName.getKey().toLowerCase(), lowercaseProperties);
                continue;
            }
            Set<String> currentProperties = currentPropertyKeys.get(eventName.getKey().toLowerCase());
            if (currentProperties == null) {
                currentPropertyKeys.put(eventName.getKey().toLowerCase(), lowercaseProperties);
                continue;
            }
            HashSet<String> newProperties = new HashSet<String>();
            newProperties.addAll(currentProperties);
            newProperties.addAll(lowercaseProperties);
            currentPropertyKeys.put(eventName.getKey().toLowerCase(), newProperties);
        }
    }

    @Override
    public void processPrivacyMode(Model m) {
        m.setPrivacyModel(new PrivacyModel(this.getVisitorMode()));
    }

    @Override
    public void processUpdatePrivacyContext(Model m) {
        PrivacyModel privacy = m.getPrivacyModel();
        String privacyVisitorMode = privacy.getVisitorMode();
        switch (privacy.getUpdateRequestKey()) {
            case NEW_VISITOR_MODE: {
                this.authorizedEventsByMode.put(privacyVisitorMode, this.authorizedEventsByMode.get("exempt"));
                this.forbiddenEventsByMode.put(privacyVisitorMode, this.forbiddenEventsByMode.get("exempt"));
                this.authorizedPropertiesByMode.put(privacyVisitorMode, this.authorizedPropertiesByMode.get("exempt"));
                this.forbiddenPropertiesByMode.put(privacyVisitorMode, this.forbiddenPropertiesByMode.get("exempt"));
                this.authorizedStorageFeatureByMode.put(privacyVisitorMode, this.authorizedStorageFeatureByMode.get("exempt"));
                this.forbiddenStorageFeatureByMode.put(privacyVisitorMode, this.forbiddenStorageFeatureByMode.get("exempt"));
                break;
            }
            case VISITOR_MODE: {
                String currentVisitorMode;
                this.inNoConsentMode = privacyVisitorMode.equalsIgnoreCase(PianoAnalytics.PrivacyVisitorMode.NO_CONSENT.stringValue());
                this.inNoStorageMode = privacyVisitorMode.equalsIgnoreCase(PianoAnalytics.PrivacyVisitorMode.NO_STORAGE.stringValue());
                SharedPreferences.Editor editor = this.sharedPreferences.edit();
                int newDuration = privacy.getDuration();
                if (newDuration <= 0) {
                    newDuration = this.storageLifetimePrivacy;
                }
                if ((currentVisitorMode = this.getVisitorMode()).equals(PianoAnalytics.PrivacyVisitorMode.OPTOUT.stringValue()) || currentVisitorMode.equals(PianoAnalytics.PrivacyVisitorMode.NO_STORAGE.stringValue()) || currentVisitorMode.equals(PianoAnalytics.PrivacyVisitorMode.NO_CONSENT.stringValue())) {
                    this.storeData(editor, PianoAnalytics.PrivacyStorageFeature.VISITOR, new Pair((Object)"PAIdclientUUID", null));
                }
                this.clearStorageFromVisitorMode(privacyVisitorMode, editor);
                this.storeData(editor, PianoAnalytics.PrivacyStorageFeature.PRIVACY, new Pair((Object)"PAPrivacyMode", (Object)privacyVisitorMode), new Pair((Object)"PAPrivacyModeExpirationTimestamp", (Object)(PianoAnalyticsUtils.currentTimeMillis() + (long)newDuration * 86400000L)), new Pair((Object)"PAPrivacyVisitorConsent", (Object)privacy.isVisitorConsent()), new Pair((Object)"PAPrivacyUserId", (Object)privacy.getCustomVisitorId()));
                break;
            }
            case EVENTS_NAME: {
                HashSet<String> lowercaseEventsName = new HashSet<String>();
                for (String string : privacy.getAuthorizedEventsName()) {
                    lowercaseEventsName.add(string.toLowerCase());
                }
                Set<String> authorizedEventsName = SetUtils.copy(this.getVisitorModeAuthorizedEventsName(privacyVisitorMode));
                authorizedEventsName.addAll(lowercaseEventsName);
                this.authorizedEventsByMode.put(privacyVisitorMode, authorizedEventsName);
                lowercaseEventsName = new HashSet();
                for (String n : privacy.getForbiddenEventsName()) {
                    lowercaseEventsName.add(n.toLowerCase());
                }
                Set<String> set = SetUtils.copy(this.getVisitorModeForbiddenEventsName(privacyVisitorMode));
                set.addAll(lowercaseEventsName);
                this.forbiddenEventsByMode.put(privacyVisitorMode, set);
                break;
            }
            case PROPERTIES: {
                this.updatePropertyMap(this.getVisitorModeAuthorizedProperties(privacyVisitorMode), privacy.getAuthorizedPropertyKeys());
                this.updatePropertyMap(this.getVisitorModeForbiddenProperties(privacyVisitorMode), privacy.getForbiddenPropertyKeys());
                break;
            }
            case STORAGE: {
                this.getVisitorModeAuthorizedStorageFeature(privacyVisitorMode).addAll(privacy.getAuthorizedStorageFeatures());
                this.getVisitorModeForbiddenStorageFeature(privacyVisitorMode).addAll(privacy.getForbiddenStorageFeatures());
                break;
            }
            default: {
                PianoAnalytics.InternalLogger.warning("PrivacyStep.processUpdatePrivacyContext : unknown update request key case");
            }
        }
    }

    @Override
    public void processGetModel(Context ctx, Model m) {
        String visitorMode = this.getVisitorMode();
        m.setPrivacyModel(new PrivacyModel(visitorMode).setAuthorizedEventsName(SetUtils.copy(this.getVisitorModeAuthorizedEventsName(visitorMode))).setForbiddenEventsName(SetUtils.copy(this.getVisitorModeForbiddenEventsName(visitorMode))).setAuthorizedPropertyKeys(MapUtils.copy(this.getVisitorModeAuthorizedProperties(visitorMode))).setForbiddenPropertyKeys(MapUtils.copy(this.getVisitorModeForbiddenProperties(visitorMode))).setAuthorizedStorageFeatures(this.getVisitorModeAuthorizedStorageFeature(visitorMode)).setForbiddenStorageFeatures(this.getVisitorModeForbiddenStorageFeature(visitorMode)).setDuration(this.getPrivacyVisitorModeRemainingDuration()).setCustomVisitorId(this.getPrivacyVisitorId()).setVisitorConsent(this.getPrivacyVisitorConsent()));
    }

    @Override
    public boolean processTrackEvents(Context ctx, Model m, PianoAnalytics.OnWorkListener l) {
        Configuration configuration = m.getConfiguration();
        Map<String, Object> contextProperties = m.getContextProperties();
        List<Event> events = m.getEvents();
        String privacyVisitorMode = this.getVisitorMode();
        if (privacyVisitorMode.equals(PianoAnalytics.PrivacyVisitorMode.OPTOUT.stringValue()) && !CastUtils.toBool(configuration.get(Configuration.ConfigurationKey.SEND_EVENT_WHEN_OPT_OUT))) {
            PianoAnalytics.InternalLogger.warning("PrivacyStep.processTrackEvents : user opted out and send when opt-out disabled");
            return false;
        }
        Set<String> authorizedEvents = SetUtils.copy(this.getVisitorModeAuthorizedEventsName(privacyVisitorMode));
        Set<String> forbiddenEvents = SetUtils.copy(this.getVisitorModeForbiddenEventsName(privacyVisitorMode));
        authorizedEvents = SetUtils.getSingletonIfContains(authorizedEvents, WILDCARD);
        forbiddenEvents = SetUtils.getSingletonIfContains(forbiddenEvents, WILDCARD);
        Map<String, Set<String>> authorizedPropertiesKeys = MapUtils.mergeSets(this.getVisitorModeAuthorizedProperties(privacyVisitorMode), this.getVisitorModeAuthorizedProperties(WILDCARD));
        Map<String, Set<String>> forbiddenPropertiesKeys = MapUtils.mergeSets(this.getVisitorModeForbiddenProperties(privacyVisitorMode), this.getVisitorModeForbiddenProperties(WILDCARD));
        MapUtils.minimizeSet(authorizedPropertiesKeys, WILDCARD);
        MapUtils.minimizeSet(forbiddenPropertiesKeys, WILDCARD);
        ArrayList<Event> resultEvents = new ArrayList<Event>();
        for (Event e : events) {
            if (!this.isAuthorizedEventName(e.getName(), authorizedEvents, forbiddenEvents)) continue;
            Map<String, Object> data = e.getData();
            data = this.applyAuthorizedPropertiesPrivacyRules(data, this.getPropertiesFromEventName(authorizedPropertiesKeys, e.getName(), WILDCARD));
            data = this.applyForbiddenPropertiesPrivacyRules(data, this.getPropertiesFromEventName(forbiddenPropertiesKeys, e.getName(), WILDCARD));
            Map<String, Object> contextPropertiesForEvent = MapUtils.copy(contextProperties);
            contextPropertiesForEvent = this.applyAuthorizedPropertiesPrivacyRules(contextPropertiesForEvent, this.getPropertiesFromEventName(authorizedPropertiesKeys, e.getName()));
            contextPropertiesForEvent = this.applyForbiddenPropertiesPrivacyRules(contextPropertiesForEvent, this.getPropertiesFromEventName(forbiddenPropertiesKeys, e.getName()));
            for (Map.Entry<String, Object> cp : contextPropertiesForEvent.entrySet()) {
                if (data.containsKey(cp.getKey())) continue;
                data.put(cp.getKey(), cp.getValue());
            }
            data.put(VISITOR_PRIVACY_MODE_PROPERTY, privacyVisitorMode);
            switch (PianoAnalytics.PrivacyVisitorMode.fromString(privacyVisitorMode)) {
                case OPTIN: {
                    data.put(VISITOR_PRIVACY_CONSENT_PROPERTY, true);
                    break;
                }
                case OPTOUT: {
                    data.put(VISITOR_PRIVACY_CONSENT_PROPERTY, false);
                    configuration.set(Configuration.ConfigurationKey.VISITOR_ID, "opt-out");
                    break;
                }
                case NO_CONSENT: {
                    data.put(VISITOR_PRIVACY_CONSENT_PROPERTY, false);
                    configuration.set(Configuration.ConfigurationKey.VISITOR_ID, "Consent-NO");
                    break;
                }
                case NO_STORAGE: {
                    data.put(VISITOR_PRIVACY_CONSENT_PROPERTY, false);
                    configuration.set(Configuration.ConfigurationKey.VISITOR_ID, "no-storage");
                    break;
                }
                case EXEMPT: {
                    data.put(VISITOR_PRIVACY_CONSENT_PROPERTY, false);
                    break;
                }
                default: {
                    data.put(VISITOR_PRIVACY_CONSENT_PROPERTY, this.getPrivacyVisitorConsent());
                    String privacyCustomVisitorId = this.getPrivacyVisitorId();
                    if (PianoAnalyticsUtils.isEmptyString(privacyCustomVisitorId)) break;
                    configuration.set(Configuration.ConfigurationKey.VISITOR_ID, privacyCustomVisitorId);
                }
            }
            resultEvents.add(new Event(e.getName(), data));
        }
        if (resultEvents.isEmpty()) {
            PianoAnalytics.InternalLogger.fine("No more events have to be sent, end of process");
            return false;
        }
        m.setContextProperties(contextProperties).setEvents(resultEvents);
        return true;
    }
}

