/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import android.content.Context;
import io.piano.analytics.BuiltModel;
import io.piano.analytics.Configuration;
import io.piano.analytics.Model;
import io.piano.analytics.PianoAnalytics;
import io.piano.analytics.PianoAnalyticsUtils;
import io.piano.analytics.WorkingQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;

final class SendStep
implements WorkingQueue.IStep {
    private static SendStep instance = null;
    private static final int TIMEOUT_MS = 10000;
    private static final int MAX_RETRY = 3;
    private static final int SLEEP_TIME_MS = 400;

    static SendStep getInstance() {
        if (instance == null) {
            instance = new SendStep();
        }
        return instance;
    }

    private SendStep() {
    }

    private void sendStoredData(Map<String, BuiltModel> stored, String userAgent) {
        for (Map.Entry<String, BuiltModel> entry : stored.entrySet()) {
            this.send(entry.getValue(), userAgent);
            String key = entry.getKey();
            if (new File(key).delete()) continue;
            PianoAnalytics.InternalLogger.severe(String.format("SendStep.sendStoredData : cannot delete file '%s'", key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void send(BuiltModel builtModel, String userAgent) {
        URLConnection connection = null;
        boolean success = false;
        int count = 0;
        do {
            block28: {
                InputStream ignored;
                ++count;
                URL url = new URL(builtModel.getUri());
                connection = (HttpURLConnection)url.openConnection();
                connection.setReadTimeout(10000);
                connection.setConnectTimeout(10000);
                connection.setRequestProperty("User-Agent", userAgent);
                connection.setDoOutput(true);
                ((HttpURLConnection)connection).setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                try (OutputStream os = connection.getOutputStream();
                     OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");){
                    osw.write(builtModel.getBody());
                    osw.flush();
                }
                connection.connect();
                int statusCode = ((HttpURLConnection)connection).getResponseCode();
                boolean bl = success = statusCode >= 200 && statusCode <= 399;
                if (connection == null) break block28;
                try {
                    InputStream inputStream = ignored = success ? connection.getInputStream() : ((HttpURLConnection)connection).getErrorStream();
                    if (ignored != null) {
                        ignored.close();
                    }
                }
                catch (IOException e) {
                    PianoAnalytics.InternalLogger.severe("SendStep.send : " + e.toString());
                }
                ((HttpURLConnection)connection).disconnect();
                break block28;
                catch (IOException e) {
                    try {
                        PianoAnalytics.InternalLogger.severe("SendStep.send : " + e.toString());
                        if (connection == null) break block28;
                    }
                    catch (Throwable throwable) {
                        if (connection != null) {
                            try {
                                InputStream ignored2;
                                InputStream inputStream = ignored2 = success ? connection.getInputStream() : ((HttpURLConnection)connection).getErrorStream();
                                if (ignored2 != null) {
                                    ignored2.close();
                                }
                            }
                            catch (IOException e2) {
                                PianoAnalytics.InternalLogger.severe("SendStep.send : " + e2.toString());
                            }
                            ((HttpURLConnection)connection).disconnect();
                        }
                        throw throwable;
                    }
                    try {
                        InputStream inputStream = ignored = success ? connection.getInputStream() : ((HttpURLConnection)connection).getErrorStream();
                        if (ignored != null) {
                            ignored.close();
                        }
                    }
                    catch (IOException e3) {
                        PianoAnalytics.InternalLogger.severe("SendStep.send : " + e3.toString());
                    }
                    ((HttpURLConnection)connection).disconnect();
                }
            }
            if (success) continue;
            PianoAnalyticsUtils.sleep(400);
        } while (!success && count < 3);
        if (!success) {
            PianoAnalytics.InternalLogger.severe("SendStep.send : unable to send hit after retries -> data lost");
        }
    }

    @Override
    public boolean processSendOfflineStorage(Model m, PianoAnalytics.OnWorkListener l) {
        Configuration configuration = m.getConfiguration();
        Map<String, BuiltModel> stored = m.getStorage();
        String userAgent = configuration.get(Configuration.ConfigurationKey.CUSTOM_USER_AGENT);
        this.sendStoredData(stored, userAgent);
        return true;
    }

    @Override
    public boolean processTrackEvents(Context ctx, Model m, PianoAnalytics.OnWorkListener l) {
        Configuration configuration = m.getConfiguration();
        Map<String, BuiltModel> stored = m.getStorage();
        BuiltModel built = m.getBuiltModel();
        String userAgent = configuration.get(Configuration.ConfigurationKey.CUSTOM_USER_AGENT);
        this.sendStoredData(stored, userAgent);
        this.send(built, userAgent);
        return true;
    }
}

