/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import android.content.Context;
import io.piano.analytics.BuiltModel;
import io.piano.analytics.CastUtils;
import io.piano.analytics.Configuration;
import io.piano.analytics.Crypt;
import io.piano.analytics.MapUtils;
import io.piano.analytics.Model;
import io.piano.analytics.PianoAnalytics;
import io.piano.analytics.PianoAnalyticsUtils;
import io.piano.analytics.WorkingQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;

final class StorageStep
implements WorkingQueue.IStep {
    private static StorageStep instance = null;
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss.SSS", Locale.getDefault());
    private final File filesDir;
    private static final String OFFLINE_DATA_FILENAME_PREFIX = "Piano-Analytics-Offline-File_";
    private static final String URI_FIELD = "uri";
    private static final String BODY_FIELD = "body";

    static StorageStep getInstance(Context ctx) {
        if (instance == null) {
            instance = new StorageStep(ctx);
        }
        return instance;
    }

    private StorageStep(Context ctx) {
        this.filesDir = ctx.getFilesDir();
    }

    private boolean storeData(String builtDataJSONStr, Configuration.EncryptionMode encryptionMode) {
        String encryptedData = Crypt.encrypt(builtDataJSONStr, encryptionMode);
        if (encryptedData == null) {
            return false;
        }
        boolean done = false;
        String filename = OFFLINE_DATA_FILENAME_PREFIX + this.dateFormatter.format(new Date());
        try (FileOutputStream stream = new FileOutputStream(new File(this.filesDir, filename));){
            stream.write(encryptedData.getBytes());
            done = true;
        }
        catch (IOException e) {
            PianoAnalytics.InternalLogger.severe("StorageStep.storeData : " + e.toString());
        }
        return done;
    }

    private Map<String, BuiltModel> readData() {
        LinkedHashMap<String, BuiltModel> storedData = new LinkedHashMap<String, BuiltModel>();
        File[] storedDataFiles = this.filesDir.listFiles((dir, name) -> name.startsWith(OFFLINE_DATA_FILENAME_PREFIX));
        if (storedDataFiles == null) {
            return storedData;
        }
        Arrays.sort(storedDataFiles, (f1, f2) -> Long.compare(f1.lastModified(), f2.lastModified()));
        for (File f : storedDataFiles) {
            try {
                Map<String, Object> map = MapUtils.fromJSONString(Crypt.decrypt(PianoAnalyticsUtils.getStringFromInputStream(new FileInputStream(f))));
                storedData.put(f.getAbsolutePath(), new BuiltModel(CastUtils.toString(map.get(URI_FIELD)), CastUtils.toString(map.get(BODY_FIELD)), false));
            }
            catch (FileNotFoundException e) {
                PianoAnalytics.InternalLogger.severe("StorageStep.readData : " + e.toString());
            }
        }
        return storedData;
    }

    @Override
    public void processDeleteOfflineStorage(Model m) {
        int storageDaysRemaining = m.getStorageDaysRemaining();
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, -storageDaysRemaining);
        Date storageRemainingDate = c.getTime();
        Map<String, BuiltModel> stored = this.readData();
        for (String key : stored.keySet()) {
            int index = key.lastIndexOf(OFFLINE_DATA_FILENAME_PREFIX);
            if (index == -1) continue;
            try {
                Date fileDate = this.dateFormatter.parse(key.substring(index + OFFLINE_DATA_FILENAME_PREFIX.length()));
                if (fileDate != null && !fileDate.before(storageRemainingDate) || new File(key).delete()) continue;
                PianoAnalytics.InternalLogger.severe("StorageStep.processDeleteOfflineStorage : could not delete key file");
            }
            catch (ParseException e) {
                PianoAnalytics.InternalLogger.severe("StorageStep.processDeleteOfflineStorage : " + e.toString());
            }
        }
    }

    @Override
    public boolean processSendOfflineStorage(Model m, PianoAnalytics.OnWorkListener l) {
        m.setStorage(this.readData());
        return true;
    }

    @Override
    public boolean processTrackEvents(Context ctx, Model m, PianoAnalytics.OnWorkListener l) {
        Configuration configuration = m.getConfiguration();
        BuiltModel builtModel = m.getBuiltModel();
        Configuration.EncryptionMode encryptionMode = Configuration.EncryptionMode.fromString(configuration.get(Configuration.ConfigurationKey.ENCRYPTION_MODE));
        if (builtModel.isMustBeSaved()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(URI_FIELD, builtModel.getUri());
            map.put(BODY_FIELD, builtModel.getBody());
            if (!this.storeData(new JSONObject(map).toString(), encryptionMode)) {
                PianoAnalytics.InternalLogger.severe("StorageStep.processTrackEvents : data could not be stored");
            }
            return false;
        }
        m.setStorage(this.readData());
        return true;
    }
}

