/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import io.piano.analytics.Configuration;
import io.piano.analytics.Model;
import io.piano.analytics.PianoAnalytics;
import io.piano.analytics.PianoAnalyticsUtils;
import io.piano.analytics.PrivacyStep;
import io.piano.analytics.User;
import io.piano.analytics.UserModel;
import io.piano.analytics.WorkingQueue;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

final class UsersStep
implements WorkingQueue.IStep {
    static UsersStep instance = null;
    private final PrivacyStep privacyStep;
    private final SharedPreferences sharedPreferences;
    private boolean userRecognition = false;
    private User user = null;
    private int userLifetimeStorage;
    private boolean userStored;
    private boolean userStoredFetchedOnCreate;

    static UsersStep getInstance(Context ctx, PrivacyStep privacyStep, Configuration configuration) {
        if (instance == null) {
            instance = new UsersStep(ctx, privacyStep, configuration);
        }
        return instance;
    }

    private UsersStep(Context ctx, PrivacyStep privacyStep, Configuration configuration) {
        this.privacyStep = privacyStep;
        this.sharedPreferences = ctx.getSharedPreferences("PAPreferencesKey", 0);
        String userJSONString = privacyStep.getData(this.sharedPreferences, PianoAnalytics.PrivacyStorageFeature.USER, "PAUser", "", "");
        if (!PianoAnalyticsUtils.isEmptyString(userJSONString)) {
            try {
                this.user = new User(new JSONObject(userJSONString));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (this.user != null) {
            this.userStoredFetchedOnCreate = true;
            this.userStored = true;
            this.userRecognition = true;
            long userStoredTimestamp = this.sharedPreferences.getLong("PAUserGenerationTimestamp", -1L);
            if (userStoredTimestamp == -1L) {
                privacyStep.storeData(this.sharedPreferences.edit(), PianoAnalytics.PrivacyStorageFeature.USER, new Pair((Object)"PAUserGenerationTimestamp", (Object)PianoAnalyticsUtils.currentTimeMillis()));
            }
        }
        try {
            this.userLifetimeStorage = Integer.parseInt(configuration.get(Configuration.ConfigurationKey.STORAGE_LIFETIME_USER));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (PianoAnalyticsUtils.isEmptyUnsignedInteger(this.userLifetimeStorage)) {
            this.userLifetimeStorage = 395;
        }
    }

    private Map<String, Object> getProperties() {
        String category;
        HashMap<String, Object> m = new HashMap<String, Object>();
        User user = this.getUser();
        if (user == null) {
            return m;
        }
        String id = user.getId();
        if (id != null) {
            m.put("user_id", id);
            m.put("user_recognition", this.userRecognition);
        }
        if ((category = user.getCategory()) != null) {
            m.put("user_category", category);
        }
        return m;
    }

    User getUser() {
        if (!this.privacyStep.getVisitorModeAuthorizedStorageFeature(this.privacyStep.getVisitorMode()).contains((Object)PianoAnalytics.PrivacyStorageFeature.USER) || this.privacyStep.getVisitorModeForbiddenStorageFeature(this.privacyStep.getVisitorMode()).contains((Object)PianoAnalytics.PrivacyStorageFeature.USER)) {
            this.privacyStep.storeData(this.sharedPreferences.edit(), PianoAnalytics.PrivacyStorageFeature.USER, new Pair((Object)"PAUser", null));
            this.userRecognition = false;
            if (this.userStoredFetchedOnCreate) {
                this.userStoredFetchedOnCreate = false;
                this.user = null;
            }
            return this.user;
        }
        long now = PianoAnalyticsUtils.currentTimeMillis();
        long userStoredTimestamp = this.sharedPreferences.getLong("PAUserGenerationTimestamp", -1L);
        if (PianoAnalyticsUtils.isEmptyUnsignedLong(userStoredTimestamp)) {
            this.privacyStep.storeData(this.sharedPreferences.edit(), PianoAnalytics.PrivacyStorageFeature.USER, new Pair((Object)"PAUserGenerationTimestamp", (Object)now));
            userStoredTimestamp = now;
        }
        if (now > userStoredTimestamp + (long)this.userLifetimeStorage * 86400000L) {
            this.privacyStep.storeData(this.sharedPreferences.edit(), PianoAnalytics.PrivacyStorageFeature.USER, new Pair((Object)"PAUser", null));
            this.userRecognition = false;
            return null;
        }
        return this.user;
    }

    boolean getUserRecognition() {
        return this.userRecognition;
    }

    @Override
    @SuppressLint(value={"CommitPrefEdits"})
    public void processUpdateContext(Model m) {
        UserModel userModel = m.getUserModel();
        if (userModel == null) {
            return;
        }
        switch (userModel.getUpdateRequestKey()) {
            case SET: {
                this.user = userModel.getUser();
                this.userRecognition = false;
                this.userStored = userModel.getEnableStorage();
                this.userStoredFetchedOnCreate = false;
                if (!this.userStored) break;
                long now = PianoAnalyticsUtils.currentTimeMillis();
                this.privacyStep.storeData(this.sharedPreferences.edit(), PianoAnalytics.PrivacyStorageFeature.USER, new Pair((Object)"PAUser", (Object)this.user.toJSONString()), new Pair((Object)"PAUserGenerationTimestamp", (Object)now));
                break;
            }
            case DELETE: {
                this.user = null;
                this.userRecognition = false;
                this.privacyStep.storeData(this.sharedPreferences.edit(), PianoAnalytics.PrivacyStorageFeature.USER, new Pair((Object)"PAUser", null), new Pair((Object)"PAUserGenerationTimestamp", null));
                break;
            }
        }
    }

    @Override
    public void processGetModel(Context ctx, Model m) {
        m.setUser(this.getUser());
    }

    @Override
    public boolean processTrackEvents(Context ctx, Model m, PianoAnalytics.OnWorkListener l) {
        m.addContextProperties(this.getProperties()).setUser(this.getUser());
        if (!this.userStored) {
            this.user = null;
            this.userRecognition = false;
            this.privacyStep.storeData(this.sharedPreferences.edit(), PianoAnalytics.PrivacyStorageFeature.USER, new Pair((Object)"PAUser", null), new Pair((Object)"PAUserGenerationTimestamp", (Object)0L));
        }
        return true;
    }
}

