/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.provider.Settings;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.huawei.hms.ads.identifier.AdvertisingIdClient;
import io.piano.analytics.CastUtils;
import io.piano.analytics.Configuration;
import io.piano.analytics.Model;
import io.piano.analytics.PianoAnalytics;
import io.piano.analytics.PianoAnalyticsUtils;
import io.piano.analytics.PrivacyStep;
import io.piano.analytics.WorkingQueue;
import java.util.UUID;

final class VisitorIDStep
implements WorkingQueue.IStep {
    private static VisitorIDStep instance = null;
    private final PrivacyStep privacyStep;
    static final String VISITOR_ID_TYPE_PROPERTY = "visitor_id_type";
    private static final String OPT_OUT = "opt-out";
    private static final String GOOGLE_ADS_SERVICES_CLASS = "com.google.android.gms.ads.identifier.AdvertisingIdClient";
    private static final String HUAWEI_ADS_SERVICES_CLASS = "com.huawei.hms.ads.identifier.AdvertisingIdClient";
    private final IVisitorIDStepFunction uuid = (configuration, ctx, prefs, ps) -> {
        long now = PianoAnalyticsUtils.currentTimeMillis();
        String uuid = ps.getData(prefs, PianoAnalytics.PrivacyStorageFeature.VISITOR, "PAIdclientUUID", null, "");
        String uuidDurationConfig = configuration.get(Configuration.ConfigurationKey.STORAGE_LIFETIME_VISITOR);
        Configuration.VisitorStorageMode uuidExpirationModeConfig = Configuration.VisitorStorageMode.fromString(configuration.get(Configuration.ConfigurationKey.VISITOR_STORAGE_MODE));
        SharedPreferences.Editor editor = prefs.edit();
        int uuidDuration = CastUtils.toInt(uuidDurationConfig);
        if (uuid == null) {
            uuid = ps.getData(prefs, PianoAnalytics.PrivacyStorageFeature.VISITOR, "ATIdclientUUID", null, "");
            ps.storeData(prefs.edit(), PianoAnalytics.PrivacyStorageFeature.VISITOR, new Pair((Object)"PAIdclientUUID", (Object)uuid), new Pair((Object)"ATIdclientUUID", null));
        }
        if (uuid != null) {
            long daysSinceGeneration;
            long uuidGenerationTimestampDefault = -1L;
            long uuidGenerationTimestamp = ps.getData(prefs, PianoAnalytics.PrivacyStorageFeature.VISITOR, "PAIdclientUUIDGenerationTimestamp", uuidGenerationTimestampDefault, uuidGenerationTimestampDefault);
            if (uuidGenerationTimestamp == -1L) {
                ps.storeData(editor, PianoAnalytics.PrivacyStorageFeature.VISITOR, new Pair((Object)"PAIdclientUUIDGenerationTimestamp", (Object)now));
                uuidGenerationTimestamp = now;
            }
            if ((daysSinceGeneration = (now - uuidGenerationTimestamp) / 86400000L) >= (long)uuidDuration) {
                uuid = null;
            }
        }
        if (uuid == null) {
            uuid = UUID.randomUUID().toString();
            ps.storeData(editor, PianoAnalytics.PrivacyStorageFeature.VISITOR, new Pair((Object)"PAIdclientUUID", (Object)uuid), new Pair((Object)"PAIdclientUUIDGenerationTimestamp", (Object)now));
            return new Pair((Object)true, (Object)new Pair((Object)false, (Object)uuid));
        }
        if (uuidExpirationModeConfig == Configuration.VisitorStorageMode.RELATIVE) {
            ps.storeData(editor, PianoAnalytics.PrivacyStorageFeature.VISITOR, new Pair((Object)"PAIdclientUUIDGenerationTimestamp", (Object)now));
        }
        return new Pair((Object)true, (Object)new Pair((Object)false, (Object)uuid));
    };
    @SuppressLint(value={"HardwareIds"})
    private final IVisitorIDStepFunction androidID = (c, ctx, prefs, ps) -> new Pair((Object)true, (Object)new Pair((Object)false, (Object)Settings.Secure.getString((ContentResolver)ctx.getContentResolver(), (String)"android_id")));
    private final IVisitorIDStepFunction googleAdvertisingID = (c, ctx, prefs, ps) -> {
        try {
            if (PianoAnalyticsUtils.isClassUnavailable(GOOGLE_ADS_SERVICES_CLASS)) {
                throw new IllegalAccessException("Google Ads Services Class not available");
            }
            AdvertisingIdClient.Info gmsAdInfo = com.google.android.gms.ads.identifier.AdvertisingIdClient.getAdvertisingIdInfo((Context)ctx);
            if (gmsAdInfo == null) {
                throw new IllegalAccessException("Google Advertising ID Info not available");
            }
            return new Pair((Object)true, (Object)new Pair((Object)gmsAdInfo.isLimitAdTrackingEnabled(), (Object)gmsAdInfo.getId()));
        }
        catch (Exception e) {
            PianoAnalytics.InternalLogger.severe("VisitorIDStep.googleAdvertisingID : " + e.toString());
            return new Pair((Object)false, (Object)new Pair((Object)false, null));
        }
    };
    private final IVisitorIDStepFunction huaweiOpenAdvertisingID = (c, ctx, prefs, ps) -> {
        try {
            if (PianoAnalyticsUtils.isClassUnavailable(HUAWEI_ADS_SERVICES_CLASS)) {
                throw new IllegalAccessException("Huawei Ads Services Class not available");
            }
            AdvertisingIdClient.Info hmsAdInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)ctx);
            return new Pair((Object)true, (Object)new Pair((Object)hmsAdInfo.isLimitAdTrackingEnabled(), (Object)hmsAdInfo.getId()));
        }
        catch (Exception e) {
            PianoAnalytics.InternalLogger.severe("VisitorIDStep.huaweiOpenAdvertisingID : " + e.toString());
            return new Pair((Object)false, (Object)new Pair((Object)false, null));
        }
    };
    private final IVisitorIDStepFunction customId = (c, ctx, prefs, ps) -> new Pair((Object)true, (Object)new Pair((Object)false, (Object)c.get(Configuration.ConfigurationKey.VISITOR_ID)));

    static VisitorIDStep getInstance(PrivacyStep privacyStep) {
        if (instance == null) {
            instance = new VisitorIDStep(privacyStep);
        }
        return instance;
    }

    private VisitorIDStep(PrivacyStep privacyStep) {
        this.privacyStep = privacyStep;
    }

    private String getVisitorID(Context ctx, Configuration configuration, Configuration.VisitorIDType visitorIDType) {
        IVisitorIDStepFunction[] iVisitorIDStepFunctions;
        SharedPreferences preferences = ctx.getSharedPreferences("PAPreferencesKey", 0);
        switch (visitorIDType) {
            case ANDROID_ID: {
                iVisitorIDStepFunctions = new IVisitorIDStepFunction[]{this.androidID};
                break;
            }
            case ADVERTISING_ID: {
                iVisitorIDStepFunctions = new IVisitorIDStepFunction[]{this.googleAdvertisingID, this.huaweiOpenAdvertisingID};
                break;
            }
            case GOOGLE_ADVERTISING_ID: {
                iVisitorIDStepFunctions = new IVisitorIDStepFunction[]{this.googleAdvertisingID};
                break;
            }
            case HUAWEI_OPEN_ADVERTISING_ID: {
                iVisitorIDStepFunctions = new IVisitorIDStepFunction[]{this.huaweiOpenAdvertisingID};
                break;
            }
            case CUSTOM: {
                iVisitorIDStepFunctions = new IVisitorIDStepFunction[]{this.customId};
                break;
            }
            default: {
                iVisitorIDStepFunctions = new IVisitorIDStepFunction[]{this.uuid};
            }
        }
        boolean ignoreLimitedAdvertisingTracking = CastUtils.toBool(configuration.get(Configuration.ConfigurationKey.IGNORE_LIMITED_AD_TRACKING));
        String visitorIdValue = null;
        for (IVisitorIDStepFunction function : iVisitorIDStepFunctions) {
            Pair<Boolean, Pair<Boolean, String>> visitorIDInfo = function.getInfo(configuration, ctx, preferences, this.privacyStep);
            boolean retrieveSuccessfully = (Boolean)visitorIDInfo.first;
            boolean trackingLimitedByUser = (Boolean)((Pair)visitorIDInfo.second).first;
            if (!retrieveSuccessfully) continue;
            if (trackingLimitedByUser) {
                if (ignoreLimitedAdvertisingTracking) {
                    visitorIdValue = (String)((Pair)this.uuid.getInfo((Configuration)configuration, (Context)ctx, (SharedPreferences)preferences, (PrivacyStep)this.privacyStep).second).second;
                    break;
                }
                visitorIdValue = OPT_OUT;
                break;
            }
            visitorIdValue = (String)((Pair)visitorIDInfo.second).second;
            break;
        }
        return visitorIdValue;
    }

    @Override
    public void processGetModel(Context ctx, Model m) {
        Configuration configuration = m.getConfiguration();
        Configuration.VisitorIDType visitorIDType = Configuration.VisitorIDType.fromString(configuration.get(Configuration.ConfigurationKey.VISITOR_ID_TYPE));
        configuration.set(Configuration.ConfigurationKey.VISITOR_ID, this.getVisitorID(ctx, configuration, visitorIDType));
    }

    @Override
    public boolean processTrackEvents(Context ctx, Model m, PianoAnalytics.OnWorkListener l) {
        Configuration configuration = m.getConfiguration();
        Configuration.VisitorIDType visitorIDType = Configuration.VisitorIDType.fromString(configuration.get(Configuration.ConfigurationKey.VISITOR_ID_TYPE));
        String customVisitorID = configuration.get(Configuration.ConfigurationKey.VISITOR_ID);
        String customVisitorIDType = configuration.get(Configuration.ConfigurationKey.VISITOR_ID_TYPE);
        if (PianoAnalyticsUtils.isEmptyString(customVisitorID)) {
            configuration.set(Configuration.ConfigurationKey.VISITOR_ID, this.getVisitorID(ctx, configuration, visitorIDType));
        } else {
            this.privacyStep.storeData(ctx.getSharedPreferences("PAPreferencesKey", 0).edit(), PianoAnalytics.PrivacyStorageFeature.VISITOR, new Pair((Object)"PAIdclientUUID", (Object)customVisitorID));
        }
        if (!PianoAnalyticsUtils.isEmptyString(customVisitorIDType)) {
            visitorIDType = Configuration.VisitorIDType.fromString(customVisitorIDType);
        }
        m.addContextProperty(VISITOR_ID_TYPE_PROPERTY, visitorIDType.stringValue());
        return true;
    }

    private static interface IVisitorIDStepFunction {
        public Pair<Boolean, Pair<Boolean, String>> getInfo(Configuration var1, Context var2, SharedPreferences var3, PrivacyStep var4);
    }
}

