/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import android.content.Context;
import io.piano.analytics.BuildStep;
import io.piano.analytics.Configuration;
import io.piano.analytics.ConfigurationStep;
import io.piano.analytics.CrashHandlingStep;
import io.piano.analytics.CustomerContextPropertiesStep;
import io.piano.analytics.InternalContextPropertiesStep;
import io.piano.analytics.LifecycleStep;
import io.piano.analytics.Model;
import io.piano.analytics.OnBeforeBuildCallStep;
import io.piano.analytics.OnBeforeSendCallStep;
import io.piano.analytics.PianoAnalytics;
import io.piano.analytics.PrivacyStep;
import io.piano.analytics.SendStep;
import io.piano.analytics.StorageStep;
import io.piano.analytics.UsersStep;
import io.piano.analytics.VisitorIDStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

final class WorkingQueue {
    private final ExecutorService pool = Executors.newSingleThreadExecutor();
    private final List<IStep> steps;
    private final Context appContext;
    private final Map<ProcessingType, IProcessing> processingMap;

    WorkingQueue(Context context, String configFileLocation) {
        this.appContext = context;
        ConfigurationStep configurationStep = ConfigurationStep.getInstance(context, configFileLocation);
        PrivacyStep ps = PrivacyStep.getInstance(context, configurationStep.getConfiguration());
        this.steps = new ArrayList<IStep>(Arrays.asList(configurationStep, VisitorIDStep.getInstance(ps), CrashHandlingStep.getInstance(context, ps), LifecycleStep.getInstance(context, ps), InternalContextPropertiesStep.getInstance(), CustomerContextPropertiesStep.getInstance(), UsersStep.getInstance(context, ps, configurationStep.getConfiguration()), OnBeforeBuildCallStep.getInstance(), ps, BuildStep.getInstance(), StorageStep.getInstance(context), OnBeforeSendCallStep.getInstance(), SendStep.getInstance()));
        this.processingMap = new EnumMap<ProcessingType, IProcessing>(ProcessingType.class);
        this.processingMap.put(ProcessingType.DELETE_OFFLINE_STORAGE, (steps, ctx, m, l) -> {
            for (IStep s : steps) {
                s.processDeleteOfflineStorage(m);
            }
        });
        this.processingMap.put(ProcessingType.SEND_OFFLINE_STORAGE, (steps, ctx, m, l) -> {
            for (IStep s : steps) {
                if (s.processSendOfflineStorage(m, l)) continue;
                return;
            }
        });
        this.processingMap.put(ProcessingType.TRACK_EVENTS, (steps, ctx, m, l) -> {
            for (IStep s : steps) {
                if (s.processTrackEvents(ctx, m, l)) continue;
                return;
            }
        });
        this.processingMap.put(ProcessingType.SET_CONFIG, (steps, ctx, m, l) -> {
            for (IStep s : steps) {
                s.processSetConfig(m);
            }
        });
        this.processingMap.put(ProcessingType.UPDATE_CONTEXT, (steps, ctx, m, l) -> {
            for (IStep s : steps) {
                s.processUpdateContext(m);
            }
        });
        this.processingMap.put(ProcessingType.UPDATE_PRIVACY_CONTEXT, (steps, ctx, m, l) -> {
            for (IStep s : steps) {
                s.processUpdatePrivacyContext(m);
            }
        });
    }

    void getModelAsync(PianoAnalytics.OnGetModelListener l) {
        this.pool.execute(() -> {
            Model m = new Model();
            for (IStep s : this.steps) {
                s.processGetModel(this.appContext, m);
            }
            l.onGetModel(m);
        });
    }

    void getUserAsync(PianoAnalytics.OnGetUserListener l) {
        this.pool.execute(() -> {
            Model m = new Model();
            for (IStep s : this.steps) {
                s.processGetModel(this.appContext, m);
            }
            l.onGetUser(m.getStoredUser());
        });
    }

    void getConfigurationAsync(Configuration.ConfigurationKey key, PianoAnalytics.OnGetConfigurationListener l) {
        this.pool.execute(() -> {
            Model m = new Model();
            for (IStep s : this.steps) {
                s.processGetConfig(m);
            }
            l.onGetConfiguration(m.getConfiguration().get(key));
        });
    }

    void getPrivacyModeAsync(PianoAnalytics.OnGetPrivacyModeListener l) {
        this.pool.execute(() -> {
            Model m = new Model();
            for (IStep s : this.steps) {
                s.processPrivacyMode(m);
            }
            l.onGetPrivacyMode(m.getPrivacyModel().getVisitorMode());
        });
    }

    void push(ProcessingType pt, Model m, PianoAnalytics.OnWorkListener l) {
        this.pool.execute(() -> {
            IProcessing workingFlowFunction = this.processingMap.get((Object)pt);
            if (workingFlowFunction != null) {
                workingFlowFunction.process(this.steps, this.appContext, m, l);
            }
        });
    }

    private static interface IProcessing {
        public void process(List<IStep> var1, Context var2, Model var3, PianoAnalytics.OnWorkListener var4);
    }

    static interface IStep {
        default public boolean processTrackEvents(Context ctx, Model m, PianoAnalytics.OnWorkListener l) {
            return true;
        }

        default public boolean processSendOfflineStorage(Model m, PianoAnalytics.OnWorkListener l) {
            return true;
        }

        default public void processDeleteOfflineStorage(Model m) {
        }

        default public void processSetConfig(Model m) {
        }

        default public void processGetConfig(Model m) {
        }

        default public void processPrivacyMode(Model m) {
        }

        default public void processUpdateContext(Model m) {
        }

        default public void processUpdatePrivacyContext(Model m) {
        }

        default public void processGetModel(Context ctx, Model m) {
        }
    }

    static enum ProcessingType {
        TRACK_EVENTS,
        SET_CONFIG,
        UPDATE_CONTEXT,
        UPDATE_PRIVACY_CONTEXT,
        SEND_OFFLINE_STORAGE,
        DELETE_OFFLINE_STORAGE;

    }
}

