/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics.avinsights;

import android.text.TextUtils;
import android.util.SparseIntArray;
import io.piano.analytics.Event;
import io.piano.analytics.PianoAnalytics;
import io.piano.analytics.avinsights.AVRunnable;
import io.piano.analytics.avinsights.BufferHeartbeatRunnable;
import io.piano.analytics.avinsights.HeartbeatRunnable;
import io.piano.analytics.avinsights.RebufferHeartbeatRunnable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class Media {
    private static final int MIN_HEARTBEAT_DURATION = 5;
    private static final int MIN_BUFFER_HEARTBEAT_DURATION = 1;
    private static final String AV_POSITION_FIELD = "av_position";
    private static final String AV_PREVIOUS_POSITION_FIELD = "av_previous_position";
    private ScheduledExecutorService heartbeatExecutor;
    private final SparseIntArray heartbeatDurations;
    private final SparseIntArray bufferHeartbeatDurations;
    private final AVRunnable heartbeatRunnable;
    private final AVRunnable bufferHeartbeatRunnable;
    private final AVRunnable rebufferHeartbeatRunnable;
    private String sessionId;
    private String previousEvent = "";
    private int previousHeartbeatDelay = 0;
    private int previousBufferHeartbeatDelay = 0;
    private int previousCursorPositionMillis = 0;
    private int currentCursorPositionMillis = 0;
    private long eventDurationMillis = 0L;
    private int sessionDurationMillis = 0;
    private long startSessionTimeMillis = 0L;
    private long bufferTimeMillis = 0L;
    private boolean isPlaying = false;
    private boolean isPlaybackActivated = false;
    private double playbackSpeed = 1.0;
    private boolean autoHeartbeat;
    private boolean autoBufferHeartbeat;
    private final PianoAnalytics pianoAnalytics;

    public Media(PianoAnalytics pianoAnalytics) {
        this.pianoAnalytics = pianoAnalytics;
        this.heartbeatDurations = new SparseIntArray();
        this.bufferHeartbeatDurations = new SparseIntArray();
        this.heartbeatRunnable = new HeartbeatRunnable(this);
        this.bufferHeartbeatRunnable = new BufferHeartbeatRunnable(this);
        this.rebufferHeartbeatRunnable = new RebufferHeartbeatRunnable(this);
        this.sessionId = UUID.randomUUID().toString();
    }

    public Media(PianoAnalytics pianoAnalytics, String sessionId) {
        this(pianoAnalytics);
        if (!TextUtils.isEmpty((CharSequence)sessionId)) {
            this.sessionId = sessionId;
        }
    }

    public synchronized String getSessionId() {
        return this.sessionId;
    }

    public void track(String event, Map<String, Object> options, Map<String, Object> extraProps) {
        if (options == null) {
            options = new HashMap<String, Object>();
        }
        switch (event) {
            case "av.heartbeat": {
                this.heartbeat(this.parseInt(options.get(AV_POSITION_FIELD)), extraProps);
                break;
            }
            case "av.buffer.heartbeat": {
                this.bufferHeartbeat(extraProps);
                break;
            }
            case "av.rebuffer.heartbeat": {
                this.rebufferHeartbeat(extraProps);
                break;
            }
            case "av.play": {
                this.play(this.parseInt(options.get(AV_POSITION_FIELD)), extraProps);
                break;
            }
            case "av.buffer.start": {
                this.bufferStart(this.parseInt(options.get(AV_POSITION_FIELD)), extraProps);
                break;
            }
            case "av.start": {
                this.playbackStart(this.parseInt(options.get(AV_POSITION_FIELD)), extraProps);
                break;
            }
            case "av.resume": {
                this.playbackResumed(this.parseInt(options.get(AV_POSITION_FIELD)), extraProps);
                break;
            }
            case "av.pause": {
                this.playbackPaused(this.parseInt(options.get(AV_POSITION_FIELD)), extraProps);
                break;
            }
            case "av.stop": {
                this.playbackStopped(this.parseInt(options.get(AV_POSITION_FIELD)), extraProps);
                break;
            }
            case "av.backward": {
                this.seekBackward(this.parseInt(options.get(AV_PREVIOUS_POSITION_FIELD)), this.parseInt(options.get(AV_POSITION_FIELD)), extraProps);
                break;
            }
            case "av.forward": {
                this.seekForward(this.parseInt(options.get(AV_PREVIOUS_POSITION_FIELD)), this.parseInt(options.get(AV_POSITION_FIELD)), extraProps);
                break;
            }
            case "av.seek.start": {
                this.seekStart(this.parseInt(options.get(AV_PREVIOUS_POSITION_FIELD)), extraProps);
                break;
            }
            case "av.error": {
                this.error(this.parseString(options.get("av_player_error")), extraProps);
                break;
            }
            default: {
                this.sendEvents(this.createEvent(event, false, extraProps));
            }
        }
    }

    public synchronized void setPlaybackSpeed(double playbackSpeed) {
        if (this.playbackSpeed == playbackSpeed && playbackSpeed <= 0.0) {
            return;
        }
        this.stopHeartbeatService();
        if (!this.isPlaying) {
            this.playbackSpeed = playbackSpeed;
            return;
        }
        this.heartbeat(-1, null);
        if (this.autoHeartbeat) {
            this.previousHeartbeatDelay = this.updateHeartbeatRunnable(this.previousHeartbeatDelay, this.startSessionTimeMillis, 5, this.heartbeatDurations, this.heartbeatRunnable);
        }
        this.playbackSpeed = playbackSpeed;
    }

    public void heartbeat(int cursorPosition, Map<String, Object> extraProps) {
        this.processHeartbeat(cursorPosition, false, extraProps);
    }

    public void bufferHeartbeat(Map<String, Object> extraProps) {
        this.processBufferHeartbeat(false, extraProps);
    }

    public void rebufferHeartbeat(Map<String, Object> extraProps) {
        this.processRebufferHeartbeat(false, extraProps);
    }

    public synchronized void play(int cursorPosition, Map<String, Object> extraProps) {
        this.startSessionTimeMillis = this.startSessionTimeMillis == 0L ? this.currentTimeMillis() : this.startSessionTimeMillis;
        this.eventDurationMillis = 0L;
        this.previousCursorPositionMillis = cursorPosition = Math.max(cursorPosition, 0);
        this.currentCursorPositionMillis = cursorPosition;
        this.bufferTimeMillis = 0L;
        this.isPlaying = false;
        this.isPlaybackActivated = false;
        this.stopHeartbeatService();
        this.sendEvents(this.createEvent("av.play", true, extraProps));
    }

    public synchronized void bufferStart(int cursorPosition, Map<String, Object> extraProps) {
        this.startSessionTimeMillis = this.startSessionTimeMillis == 0L ? this.currentTimeMillis() : this.startSessionTimeMillis;
        this.updateDuration();
        this.previousCursorPositionMillis = this.currentCursorPositionMillis;
        this.currentCursorPositionMillis = Math.max(cursorPosition, 0);
        this.stopHeartbeatService();
        if (this.isPlaybackActivated) {
            if (this.autoBufferHeartbeat) {
                this.bufferTimeMillis = this.bufferTimeMillis == 0L ? this.currentTimeMillis() : this.bufferTimeMillis;
                this.previousBufferHeartbeatDelay = this.updateHeartbeatRunnable(this.previousBufferHeartbeatDelay, this.bufferTimeMillis, 1, this.bufferHeartbeatDurations, this.rebufferHeartbeatRunnable);
            }
            this.sendEvents(this.createEvent("av.rebuffer.start", true, extraProps));
        } else {
            if (this.autoBufferHeartbeat) {
                this.bufferTimeMillis = this.bufferTimeMillis == 0L ? this.currentTimeMillis() : this.bufferTimeMillis;
                this.previousBufferHeartbeatDelay = this.updateHeartbeatRunnable(this.previousBufferHeartbeatDelay, this.bufferTimeMillis, 1, this.bufferHeartbeatDurations, this.bufferHeartbeatRunnable);
            }
            this.sendEvents(this.createEvent("av.buffer.start", true, extraProps));
        }
    }

    public synchronized void playbackStart(int cursorPosition, Map<String, Object> extraProps) {
        this.startSessionTimeMillis = this.startSessionTimeMillis == 0L ? this.currentTimeMillis() : this.startSessionTimeMillis;
        this.updateDuration();
        this.previousCursorPositionMillis = cursorPosition = Math.max(cursorPosition, 0);
        this.currentCursorPositionMillis = cursorPosition;
        this.bufferTimeMillis = 0L;
        this.isPlaying = true;
        this.isPlaybackActivated = true;
        this.stopHeartbeatService();
        if (this.autoHeartbeat) {
            this.previousHeartbeatDelay = this.updateHeartbeatRunnable(this.previousHeartbeatDelay, this.startSessionTimeMillis, 5, this.heartbeatDurations, this.heartbeatRunnable);
        }
        this.sendEvents(this.createEvent("av.start", true, extraProps));
    }

    public synchronized void playbackResumed(int cursorPosition, Map<String, Object> extraProps) {
        this.startSessionTimeMillis = this.startSessionTimeMillis == 0L ? this.currentTimeMillis() : this.startSessionTimeMillis;
        this.updateDuration();
        this.previousCursorPositionMillis = this.currentCursorPositionMillis;
        this.currentCursorPositionMillis = Math.max(cursorPosition, 0);
        this.bufferTimeMillis = 0L;
        this.isPlaying = true;
        this.isPlaybackActivated = true;
        this.stopHeartbeatService();
        if (this.autoHeartbeat) {
            this.previousHeartbeatDelay = this.updateHeartbeatRunnable(this.previousHeartbeatDelay, this.startSessionTimeMillis, 5, this.heartbeatDurations, this.heartbeatRunnable);
        }
        this.sendEvents(this.createEvent("av.resume", true, extraProps));
    }

    public synchronized void playbackPaused(int cursorPosition, Map<String, Object> extraProps) {
        this.startSessionTimeMillis = this.startSessionTimeMillis == 0L ? this.currentTimeMillis() : this.startSessionTimeMillis;
        this.updateDuration();
        this.previousCursorPositionMillis = this.currentCursorPositionMillis;
        this.currentCursorPositionMillis = Math.max(cursorPosition, 0);
        this.bufferTimeMillis = 0L;
        this.isPlaying = false;
        this.isPlaybackActivated = true;
        this.stopHeartbeatService();
        this.sendEvents(this.createEvent("av.pause", true, extraProps));
    }

    public synchronized void playbackStopped(int cursorPosition, Map<String, Object> extraProps) {
        this.startSessionTimeMillis = this.startSessionTimeMillis == 0L ? this.currentTimeMillis() : this.startSessionTimeMillis;
        this.updateDuration();
        this.previousCursorPositionMillis = this.currentCursorPositionMillis;
        this.currentCursorPositionMillis = Math.max(cursorPosition, 0);
        this.bufferTimeMillis = 0L;
        this.isPlaying = false;
        this.isPlaybackActivated = false;
        this.stopHeartbeatService();
        this.startSessionTimeMillis = 0L;
        this.sessionDurationMillis = 0;
        this.bufferTimeMillis = 0L;
        this.previousHeartbeatDelay = 0;
        this.previousBufferHeartbeatDelay = 0;
        this.sendEvents(this.createEvent("av.stop", true, extraProps));
        this.resetState();
    }

    public void seek(int oldCursorPosition, int newCursorPosition, Map<String, Object> extraProps) {
        if (oldCursorPosition > newCursorPosition) {
            this.seekBackward(oldCursorPosition, newCursorPosition, extraProps);
        } else {
            this.seekForward(oldCursorPosition, newCursorPosition, extraProps);
        }
    }

    public void seekBackward(int oldCursorPosition, int newCursorPosition, Map<String, Object> extraProps) {
        this.processSeek("backward", oldCursorPosition, newCursorPosition, extraProps);
    }

    public void seekForward(int oldCursorPosition, int newCursorPosition, Map<String, Object> extraProps) {
        this.processSeek("forward", oldCursorPosition, newCursorPosition, extraProps);
    }

    public void seekStart(int oldCursorPosition, Map<String, Object> extraProps) {
        this.sendEvents(this.createSeekStart(oldCursorPosition, extraProps));
    }

    public void adClick(Map<String, Object> extraProps) {
        this.sendEvents(this.createEvent("av.ad.click", false, extraProps));
    }

    public void adSkip(Map<String, Object> extraProps) {
        this.sendEvents(this.createEvent("av.ad.skip", false, extraProps));
    }

    public void error(String message, Map<String, Object> extraProps) {
        if (extraProps == null) {
            extraProps = new HashMap<String, Object>();
        }
        extraProps.put("av_player_error", message);
        this.sendEvents(this.createEvent("av.error", false, extraProps));
    }

    public void display(Map<String, Object> extraProps) {
        this.sendEvents(this.createEvent("av.display", false, extraProps));
    }

    public void close(Map<String, Object> extraProps) {
        this.sendEvents(this.createEvent("av.close", false, extraProps));
    }

    public void volume(Map<String, Object> extraProps) {
        this.sendEvents(this.createEvent("av.volume", false, extraProps));
    }

    public void subtitleOn(Map<String, Object> extraProps) {
        this.sendEvents(this.createEvent("av.subtitle.on", false, extraProps));
    }

    public void subtitleOff(Map<String, Object> extraProps) {
        this.sendEvents(this.createEvent("av.subtitle.off", false, extraProps));
    }

    public void fullscreenOn(Map<String, Object> extraProps) {
        this.sendEvents(this.createEvent("av.fullscreen.on", false, extraProps));
    }

    public void fullscreenOff(Map<String, Object> extraProps) {
        this.sendEvents(this.createEvent("av.fullscreen.off", false, extraProps));
    }

    public void quality(Map<String, Object> extraProps) {
        this.sendEvents(this.createEvent("av.quality", false, extraProps));
    }

    public void speed(Map<String, Object> extraProps) {
        this.sendEvents(this.createEvent("av.speed", false, extraProps));
    }

    public void share(Map<String, Object> extraProps) {
        this.sendEvents(this.createEvent("av.share", false, extraProps));
    }

    public Media setHeartbeat(SparseIntArray heartbeat) {
        if (heartbeat == null) {
            return this;
        }
        int size = heartbeat.size();
        if (size == 0) {
            return this;
        }
        this.autoHeartbeat = true;
        this.heartbeatDurations.clear();
        for (int i = 0; i < size; ++i) {
            this.heartbeatDurations.put(heartbeat.keyAt(i), Math.max(heartbeat.valueAt(i), 5));
        }
        if (this.heartbeatDurations.indexOfKey(0) < 0) {
            this.heartbeatDurations.put(0, 5);
        }
        return this;
    }

    public Media setBufferHeartbeat(SparseIntArray bufferHeartbeat) {
        if (bufferHeartbeat == null) {
            return this;
        }
        int size = bufferHeartbeat.size();
        if (size == 0) {
            return this;
        }
        this.autoBufferHeartbeat = true;
        this.bufferHeartbeatDurations.clear();
        for (int i = 0; i < size; ++i) {
            this.bufferHeartbeatDurations.put(bufferHeartbeat.keyAt(i), Math.max(bufferHeartbeat.valueAt(i), 1));
        }
        if (this.bufferHeartbeatDurations.indexOfKey(0) < 0) {
            this.bufferHeartbeatDurations.put(0, 1);
        }
        return this;
    }

    private int updateHeartbeatRunnable(int previousHeartbeatDelay, long startTimerMillis, int MIN_HEARTBEAT_DURATION, SparseIntArray heartbeatDurations, AVRunnable heartbeatRunnable) {
        int minutesDelay = (int)((this.currentTimeMillis() - startTimerMillis) / 60000L);
        int heartbeatDelay = Math.max(heartbeatDurations.get(minutesDelay, previousHeartbeatDelay), MIN_HEARTBEAT_DURATION);
        this.heartbeatExecutor.schedule(heartbeatRunnable, (long)heartbeatDelay, TimeUnit.SECONDS);
        return heartbeatDelay;
    }

    private synchronized Event createSeekStart(int oldCursorPosition, Map<String, Object> extraProps) {
        this.previousCursorPositionMillis = this.currentCursorPositionMillis;
        this.currentCursorPositionMillis = Math.max(oldCursorPosition, 0);
        if (this.isPlaying) {
            this.updateDuration();
        } else {
            this.eventDurationMillis = 0L;
        }
        return this.createEvent("av.seek.start", true, extraProps);
    }

    private synchronized void processSeek(String seekDirection, int oldCursorPosition, int newCursorPosition, Map<String, Object> extraProps) {
        Event seekStart = this.createSeekStart(oldCursorPosition, extraProps);
        this.eventDurationMillis = 0L;
        this.previousCursorPositionMillis = Math.max(oldCursorPosition, 0);
        this.currentCursorPositionMillis = Math.max(newCursorPosition, 0);
        this.sendEvents(seekStart, this.createEvent("av." + seekDirection, true, extraProps));
    }

    private synchronized Event createEvent(String name, boolean withOptions, Map<String, Object> extraProps) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (withOptions) {
            props.put(AV_PREVIOUS_POSITION_FIELD, this.previousCursorPositionMillis);
            props.put(AV_POSITION_FIELD, this.currentCursorPositionMillis);
            props.put("av_duration", this.eventDurationMillis);
            props.put("av_previous_event", this.previousEvent);
            this.previousEvent = name;
        }
        props.put("av_session_id", this.sessionId);
        if (extraProps != null) {
            props.putAll(new HashMap<String, Object>(extraProps));
        }
        return new Event(name, props);
    }

    private void sendEvents(Event ... events) {
        this.pianoAnalytics.sendEvents(Arrays.asList(events), null);
    }

    private void updateDuration() {
        this.eventDurationMillis = this.currentTimeMillis() - this.startSessionTimeMillis - (long)this.sessionDurationMillis;
        this.sessionDurationMillis = (int)((long)this.sessionDurationMillis + this.eventDurationMillis);
    }

    private void stopHeartbeatService() {
        if (this.heartbeatExecutor != null && !this.heartbeatExecutor.isShutdown()) {
            this.heartbeatExecutor.shutdownNow();
        }
        this.heartbeatExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    private void resetState() {
        this.sessionId = UUID.randomUUID().toString();
        this.previousEvent = "";
        this.previousCursorPositionMillis = 0;
        this.currentCursorPositionMillis = 0;
        this.eventDurationMillis = 0L;
    }

    private int parseInt(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Double) {
            return ((Double)o).intValue();
        }
        try {
            return Double.valueOf(this.parseString(o)).intValue();
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    private String parseString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return String.valueOf(o);
    }

    private long currentTimeMillis() {
        long timeMillis;
        int year;
        int retry = 3;
        do {
            --retry;
            timeMillis = System.currentTimeMillis();
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(timeMillis);
            year = cal.get(1);
            if (year >= 2000) continue;
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } while (year < 2000 && retry > 0);
        return timeMillis;
    }

    synchronized void processHeartbeat(int cursorPosition, boolean fromAuto, Map<String, Object> extraProps) {
        this.startSessionTimeMillis = this.startSessionTimeMillis == 0L ? this.currentTimeMillis() : this.startSessionTimeMillis;
        this.updateDuration();
        this.previousCursorPositionMillis = this.currentCursorPositionMillis;
        this.currentCursorPositionMillis = cursorPosition >= 0 ? cursorPosition : (int)((double)this.currentCursorPositionMillis + (double)this.eventDurationMillis * this.playbackSpeed);
        if (fromAuto) {
            this.previousHeartbeatDelay = this.updateHeartbeatRunnable(this.previousHeartbeatDelay, this.startSessionTimeMillis, 5, this.heartbeatDurations, this.heartbeatRunnable);
        }
        this.sendEvents(this.createEvent("av.heartbeat", true, extraProps));
    }

    synchronized void processBufferHeartbeat(boolean fromAuto, Map<String, Object> extraProps) {
        this.startSessionTimeMillis = this.startSessionTimeMillis == 0L ? this.currentTimeMillis() : this.startSessionTimeMillis;
        this.updateDuration();
        if (fromAuto) {
            this.bufferTimeMillis = this.bufferTimeMillis == 0L ? this.currentTimeMillis() : this.bufferTimeMillis;
            this.previousBufferHeartbeatDelay = this.updateHeartbeatRunnable(this.previousBufferHeartbeatDelay, this.bufferTimeMillis, 1, this.bufferHeartbeatDurations, this.bufferHeartbeatRunnable);
        }
        this.sendEvents(this.createEvent("av.buffer.heartbeat", true, extraProps));
    }

    synchronized void processRebufferHeartbeat(boolean fromAuto, Map<String, Object> extraProps) {
        this.startSessionTimeMillis = this.startSessionTimeMillis == 0L ? this.currentTimeMillis() : this.startSessionTimeMillis;
        this.updateDuration();
        this.previousCursorPositionMillis = this.currentCursorPositionMillis;
        if (fromAuto) {
            this.bufferTimeMillis = this.bufferTimeMillis == 0L ? this.currentTimeMillis() : this.bufferTimeMillis;
            this.previousBufferHeartbeatDelay = this.updateHeartbeatRunnable(this.previousBufferHeartbeatDelay, this.bufferTimeMillis, 1, this.bufferHeartbeatDurations, this.rebufferHeartbeatRunnable);
        }
        this.sendEvents(this.createEvent("av.rebuffer.heartbeat", true, extraProps));
    }
}

