/*
 * Decompiled with CFR 0.152.
 */
package io.piano.android.analytics;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import io.piano.android.analytics.DataEncoder;
import io.piano.android.analytics.DatabaseHelper;
import io.piano.android.analytics.model.EventRecord;
import java.io.Closeable;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ)\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000e\"\u00020\f\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bJ\u0012\u0010\u0015\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\"\u0010\u0016\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0016Ju\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001a2\u0010\b\u0002\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000e2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0014\b\u0002\u0010\u001d\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\f\u0018\u00010\u000e2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\"J\u000e\u0010#\u001a\u00020$2\u0006\u0010\t\u001a\u00020\nJ\u0011\u0010%\u001a\u00020&*\u00020\nH\u0000\u00a2\u0006\u0002\b'J\n\u0010(\u001a\u00020\n*\u00020&R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lio/piano/android/analytics/DatabaseHelper;", "Landroid/database/sqlite/SQLiteOpenHelper;", "context", "Landroid/content/Context;", "dataEncoder", "Lio/piano/android/analytics/DataEncoder;", "(Landroid/content/Context;Lio/piano/android/analytics/DataEncoder;)V", "delete", "", "eventRecord", "Lio/piano/android/analytics/model/EventRecord;", "whereClause", "", "whereArgs", "", "(Ljava/lang/String;[Ljava/lang/String;)I", "migrate", "", "db", "Landroid/database/sqlite/SQLiteDatabase;", "version", "onCreate", "onUpgrade", "oldVersion", "newVersion", "query", "", "columns", "selection", "selectionArgs", "groupBy", "having", "orderBy", "limit", "([Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/util/List;", "save", "", "toContentValues", "Landroid/content/ContentValues;", "toContentValues$piano_analytics_release", "toEventRecord", "Companion", "piano-analytics_release"})
public final class DatabaseHelper
extends SQLiteOpenHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataEncoder dataEncoder;
    public static final int DATABASE_VERSION = 1;
    @NotNull
    private static final String DATABASE_NAME = "events.db";

    public DatabaseHelper(@NotNull Context context, @NotNull DataEncoder dataEncoder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dataEncoder, (String)"dataEncoder");
        super(context, DATABASE_NAME, null, 1);
        this.dataEncoder = dataEncoder;
    }

    public void onCreate(@Nullable SQLiteDatabase db) {
        if (db != null) {
            for (int v = 0; v < 1; ++v) {
                this.migrate(db, v);
            }
        }
    }

    public void onUpgrade(@Nullable SQLiteDatabase db, int oldVersion, int newVersion) {
        if (db != null) {
            for (int v = oldVersion; v < newVersion; ++v) {
                this.migrate(db, v);
            }
        }
    }

    public final void migrate(@NotNull SQLiteDatabase db, int version) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        if (version == 0) {
            db.execSQL("CREATE TABLE events (\n_id INTEGER PRIMARY KEY AUTOINCREMENT,\ndata TEXT NOT NULL,\ntime INTEGER,\nisSent INTEGER\n);");
        }
    }

    @NotNull
    public final ContentValues toContentValues$piano_analytics_release(@NotNull EventRecord $this$toContentValues) {
        ContentValues contentValues;
        Intrinsics.checkNotNullParameter((Object)$this$toContentValues, (String)"<this>");
        ContentValues $this$toContentValues_u24lambda_u240 = contentValues = new ContentValues();
        boolean bl = false;
        $this$toContentValues_u24lambda_u240.put("data", this.dataEncoder.encode($this$toContentValues.getData()));
        $this$toContentValues_u24lambda_u240.put("time", Long.valueOf($this$toContentValues.getTimestamp()));
        $this$toContentValues_u24lambda_u240.put("isSent", Boolean.valueOf($this$toContentValues.isSent()));
        return contentValues;
    }

    @NotNull
    public final EventRecord toEventRecord(@NotNull ContentValues $this$toEventRecord) {
        Intrinsics.checkNotNullParameter((Object)$this$toEventRecord, (String)"<this>");
        String string2 = $this$toEventRecord.getAsString("data");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAsString(EventRecord.DATA)");
        String string3 = this.dataEncoder.decode(string2);
        Long l = $this$toEventRecord.getAsLong("time");
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getAsLong(EventRecord.TIME)");
        long l2 = ((Number)l).longValue();
        Long l3 = $this$toEventRecord.getAsLong("_id");
        Boolean bl = $this$toEventRecord.getAsBoolean("isSent");
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getAsBoolean(EventRecord.IS_SENT)");
        return new EventRecord(string3, l2, l3, bl);
    }

    public final long save(@NotNull EventRecord eventRecord) {
        long l;
        Intrinsics.checkNotNullParameter((Object)eventRecord, (String)"eventRecord");
        Long l2 = eventRecord.getId();
        if (l2 != null) {
            long id = ((Number)l2).longValue();
            boolean bl = false;
            String[] stringArray = new String[]{String.valueOf(id)};
            l = this.getWritableDatabase().update("events", this.toContentValues$piano_analytics_release(eventRecord), "_id = ?", stringArray);
        } else {
            l = this.getWritableDatabase().insert("events", null, this.toContentValues$piano_analytics_release(eventRecord));
        }
        return l;
    }

    public final int delete(@NotNull EventRecord eventRecord) {
        int n;
        Intrinsics.checkNotNullParameter((Object)eventRecord, (String)"eventRecord");
        Long l = eventRecord.getId();
        if (l != null) {
            long id = ((Number)l).longValue();
            boolean bl = false;
            String[] stringArray = new String[]{String.valueOf(id)};
            n = this.delete("_id = ?", stringArray);
        } else {
            n = -1;
        }
        return n;
    }

    public final int delete(@Nullable String whereClause, String ... whereArgs) {
        Intrinsics.checkNotNullParameter((Object)whereArgs, (String)"whereArgs");
        return this.getWritableDatabase().delete("events", whereClause, whereArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<EventRecord> query(@Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit) {
        List list;
        Closeable closeable = (Closeable)this.getReadableDatabase().query("events", columns, selection, selectionArgs, groupBy, having, orderBy, limit);
        Throwable throwable = null;
        try {
            Cursor c = (Cursor)closeable;
            boolean bl = false;
            list = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<Cursor>(c){
                final /* synthetic */ Cursor $c;
                {
                    this.$c = $c;
                    super(0);
                }

                @Nullable
                public final Cursor invoke() {
                    return this.$c.moveToNext() ? this.$c : null;
                }
            })), (Function1)((Function1)new Function1<Cursor, ContentValues>((Object)Companion){

                @NotNull
                public final ContentValues invoke(@NotNull Cursor p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return io.piano.android.analytics.DatabaseHelper$Companion.access$cursorRowToContentValues((Companion)this.receiver, p0);
                }
            })), (Function1)((Function1)new Function1<ContentValues, EventRecord>(this){
                final /* synthetic */ DatabaseHelper this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final EventRecord invoke(@NotNull ContentValues it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.toEventRecord(it);
                }
            })), (Function1)query.1.4.INSTANCE));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    public static /* synthetic */ List query$default(DatabaseHelper databaseHelper, String[] stringArray, String string2, String[] stringArray2, String string3, String string4, String string5, String string6, int n, Object object) {
        if ((n & 1) != 0) {
            stringArray = EventRecord.Companion.getCOLUMNS();
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            stringArray2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        if ((n & 0x20) != 0) {
            string5 = "time ASC";
        }
        if ((n & 0x40) != 0) {
            string6 = null;
        }
        return databaseHelper.query(stringArray, string2, stringArray2, string3, string4, string5, string6);
    }

    @JvmStatic
    private static final ContentValues cursorRowToContentValues(Cursor c) {
        return DatabaseHelper.Companion.cursorRowToContentValues(c);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/piano/android/analytics/DatabaseHelper$Companion;", "", "()V", "DATABASE_NAME", "", "DATABASE_VERSION", "", "cursorRowToContentValues", "Landroid/content/ContentValues;", "c", "Landroid/database/Cursor;", "piano-analytics_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final ContentValues cursorRowToContentValues(Cursor c) {
            ContentValues contentValues;
            ContentValues $this$cursorRowToContentValues_u24lambda_u240 = contentValues = new ContentValues();
            boolean bl = false;
            int n = c.getColumnCount();
            block5: for (int i = 0; i < n; ++i) {
                String name = c.getColumnNames()[i];
                switch (c.getType(i)) {
                    case 4: {
                        $this$cursorRowToContentValues_u24lambda_u240.put(name, c.getBlob(i));
                        continue block5;
                    }
                    case 2: {
                        $this$cursorRowToContentValues_u24lambda_u240.put(name, Float.valueOf(c.getFloat(i)));
                        continue block5;
                    }
                    case 1: {
                        $this$cursorRowToContentValues_u24lambda_u240.put(name, Long.valueOf(c.getLong(i)));
                        continue block5;
                    }
                    default: {
                        $this$cursorRowToContentValues_u24lambda_u240.put(name, c.getString(i));
                    }
                }
            }
            return contentValues;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

