/*
 * Decompiled with CFR 0.152.
 */
package io.piano.android.analytics;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import androidx.core.content.ContextCompat;
import io.piano.android.analytics.model.ConnectionType;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0014\u001a\u00020\u0006*\u00020\u0015H\u0002J\u000e\u0010\u0014\u001a\u00020\u0006*\u0004\u0018\u00010\u0016H\u0003J\f\u0010\u0014\u001a\u00020\u0006*\u00020\u0017H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lio/piano/android/analytics/DeviceInfoProvider;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "connectionType", "Lio/piano/android/analytics/model/ConnectionType;", "getConnectionType$piano_analytics_release", "()Lio/piano/android/analytics/model/ConnectionType;", "displayMetrics", "Landroid/util/DisplayMetrics;", "getDisplayMetrics", "()Landroid/util/DisplayMetrics;", "displayMetrics$delegate", "Lkotlin/Lazy;", "packageInfo", "Landroid/content/pm/PackageInfo;", "getPackageInfo", "()Landroid/content/pm/PackageInfo;", "packageInfo$delegate", "toConnectionType", "Landroid/net/NetworkCapabilities;", "Landroid/net/NetworkInfo;", "", "piano-analytics_release"})
public final class DeviceInfoProvider {
    @NotNull
    private final Context context;
    @NotNull
    private final Lazy displayMetrics$delegate;
    @NotNull
    private final Lazy packageInfo$delegate;

    public DeviceInfoProvider(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.displayMetrics$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DisplayMetrics>(this){
            final /* synthetic */ DeviceInfoProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final DisplayMetrics invoke() {
                return DeviceInfoProvider.access$getContext$p(this.this$0).getResources().getDisplayMetrics();
            }
        }));
        this.packageInfo$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PackageInfo>(this){
            final /* synthetic */ DeviceInfoProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final PackageInfo invoke() {
                PackageInfo packageInfo2;
                try {
                    Context $this$invoke_u24lambda_u240 = DeviceInfoProvider.access$getContext$p(this.this$0);
                    boolean bl = false;
                    packageInfo2 = Build.VERSION.SDK_INT >= 33 ? $this$invoke_u24lambda_u240.getPackageManager().getPackageInfo($this$invoke_u24lambda_u240.getPackageName(), PackageManager.PackageInfoFlags.of((long)0L)) : $this$invoke_u24lambda_u240.getPackageManager().getPackageInfo($this$invoke_u24lambda_u240.getPackageName(), 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Timber.Forest.w((Throwable)e, "Problems during package info search", new Object[0]);
                    packageInfo2 = null;
                }
                return packageInfo2;
            }
        }));
    }

    @NotNull
    public final DisplayMetrics getDisplayMetrics() {
        Lazy lazy = this.displayMetrics$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-displayMetrics>(...)");
        return (DisplayMetrics)object;
    }

    @Nullable
    public final PackageInfo getPackageInfo() {
        Lazy lazy = this.packageInfo$delegate;
        return (PackageInfo)lazy.getValue();
    }

    @NotNull
    public final ConnectionType getConnectionType$piano_analytics_release() {
        ConnectionType connectionType;
        ConnectivityManager connectivityManager = (ConnectivityManager)ContextCompat.getSystemService((Context)this.context, ConnectivityManager.class);
        if (connectivityManager == null) {
            return ConnectionType.OFFLINE;
        }
        ConnectivityManager manager = connectivityManager;
        if (Build.VERSION.SDK_INT >= 29) {
            connectionType = manager.getNetworkCapabilities(manager.getActiveNetwork());
            if (connectionType == null || (connectionType = this.toConnectionType((NetworkCapabilities)connectionType)) == null) {
                connectionType = ConnectionType.OFFLINE;
            }
        } else {
            connectionType = this.toConnectionType(manager.getActiveNetworkInfo());
        }
        return connectionType;
    }

    private final ConnectionType toConnectionType(NetworkCapabilities $this$toConnectionType) {
        return !$this$toConnectionType.hasCapability(12) ? ConnectionType.OFFLINE : ($this$toConnectionType.hasTransport(1) || $this$toConnectionType.hasTransport(3) ? ConnectionType.WIFI : ($this$toConnectionType.hasTransport(0) ? ConnectionType.MOBILE : ConnectionType.UNKNOWN));
    }

    @SuppressLint(value={"MissingPermission"})
    private final ConnectionType toConnectionType(NetworkInfo $this$toConnectionType) {
        ConnectionType connectionType;
        block3: {
            block5: {
                block4: {
                    block2: {
                        if ($this$toConnectionType != null && $this$toConnectionType.isConnected()) break block2;
                        connectionType = ConnectionType.OFFLINE;
                        break block3;
                    }
                    if ($this$toConnectionType.getType() != 1) break block4;
                    connectionType = ConnectionType.WIFI;
                    break block3;
                }
                connectionType = (TelephonyManager)ContextCompat.getSystemService((Context)this.context, TelephonyManager.class);
                if (connectionType == null) break block5;
                ConnectionType $this$toConnectionType_u24lambda_u240 = connectionType;
                boolean bl = false;
                int type = Build.VERSION.SDK_INT >= 24 ? $this$toConnectionType_u24lambda_u240.getDataNetworkType() : $this$toConnectionType_u24lambda_u240.getNetworkType();
                ConnectionType connectionType2 = this.toConnectionType(type);
                connectionType = connectionType2;
                if (connectionType2 != null) break block3;
            }
            connectionType = ConnectionType.UNKNOWN;
        }
        return connectionType;
    }

    private final ConnectionType toConnectionType(int $this$toConnectionType) {
        ConnectionType connectionType;
        switch ($this$toConnectionType) {
            case 1: {
                connectionType = ConnectionType.GPRS;
                break;
            }
            case 2: {
                connectionType = ConnectionType.EDGE;
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                connectionType = ConnectionType.TWOG;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 12: {
                connectionType = ConnectionType.THREEG;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                connectionType = ConnectionType.THREEGPLUS;
                break;
            }
            case 13: 
            case 15: {
                connectionType = ConnectionType.FOURG;
                break;
            }
            case 20: {
                connectionType = ConnectionType.FIVEG;
                break;
            }
            default: {
                connectionType = ConnectionType.UNKNOWN;
            }
        }
        return connectionType;
    }

    public static final /* synthetic */ Context access$getContext$p(DeviceInfoProvider $this) {
        return $this.context;
    }
}

