/*
 * Decompiled with CFR 0.152.
 */
package io.piano.android.analytics;

import com.squareup.moshi.JsonAdapter;
import io.piano.android.analytics.DatabaseHelper;
import io.piano.android.analytics.model.Event;
import io.piano.android.analytics.model.EventRecord;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0014\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011J\u0014\u0010\u0012\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/piano/android/analytics/EventRepository;", "", "databaseHelper", "Lio/piano/android/analytics/DatabaseHelper;", "eventAdapter", "Lcom/squareup/moshi/JsonAdapter;", "Lio/piano/android/analytics/model/Event;", "(Lio/piano/android/analytics/DatabaseHelper;Lcom/squareup/moshi/JsonAdapter;)V", "deleteOldEvents", "", "eventsOfflineStorageLifetime", "", "getNotSentEvents", "", "Lio/piano/android/analytics/model/EventRecord;", "markEventsAsSent", "events", "", "putEvents", "piano-analytics_release"})
@SourceDebugExtension(value={"SMAP\nEventRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventRepository.kt\nio/piano/android/analytics/EventRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,38:1\n1855#2,2:39\n1855#2,2:41\n*S KotlinDebug\n*F\n+ 1 EventRepository.kt\nio/piano/android/analytics/EventRepository\n*L\n13#1:39,2\n32#1:41,2\n*E\n"})
public final class EventRepository {
    @NotNull
    private final DatabaseHelper databaseHelper;
    @NotNull
    private final JsonAdapter<Event> eventAdapter;

    public EventRepository(@NotNull DatabaseHelper databaseHelper, @NotNull JsonAdapter<Event> eventAdapter) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseHelper), (String)"databaseHelper");
        Intrinsics.checkNotNullParameter(eventAdapter, (String)"eventAdapter");
        this.databaseHelper = databaseHelper;
        this.eventAdapter = eventAdapter;
    }

    public final void putEvents(@NotNull Collection<Event> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Event e = (Event)element$iv;
            boolean bl = false;
            String string2 = this.eventAdapter.toJson((Object)e);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"eventAdapter.toJson(e)");
            this.databaseHelper.save(new EventRecord(string2, 0L, null, false, 14, null));
        }
    }

    public final void deleteOldEvents(int eventsOfflineStorageLifetime) {
        String[] stringArray = new String[]{String.valueOf(System.currentTimeMillis() - TimeUnit.DAYS.toMillis(eventsOfflineStorageLifetime))};
        this.databaseHelper.delete("time < ?", stringArray);
    }

    @NotNull
    public final List<EventRecord> getNotSentEvents() {
        return DatabaseHelper.query$default(this.databaseHelper, null, "isSent = 0", null, null, null, "time ASC", null, 93, null);
    }

    public final void markEventsAsSent(@NotNull Collection<EventRecord> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventRecord e = (EventRecord)element$iv;
            boolean bl = false;
            e.setSent(true);
            this.databaseHelper.save(e);
        }
    }
}

