/*
 * Decompiled with CFR 0.152.
 */
package io.piano.android.analytics;

import io.piano.android.analytics.Configuration;
import io.piano.android.analytics.PrefsStorage;
import io.piano.android.analytics.model.PrivacyMode;
import io.piano.android.analytics.model.PrivacyStorageFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0015\u001a\u00020\u0016H\u0080\b\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u001bR\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/piano/android/analytics/PrivacyModesStorage;", "", "configuration", "Lio/piano/android/analytics/Configuration;", "prefsStorage", "Lio/piano/android/analytics/PrefsStorage;", "(Lio/piano/android/analytics/Configuration;Lio/piano/android/analytics/PrefsStorage;)V", "allModes", "", "Lio/piano/android/analytics/model/PrivacyMode;", "getAllModes$annotations", "()V", "getAllModes", "()Ljava/util/Set;", "value", "currentMode", "getCurrentMode$annotations", "getCurrentMode", "()Lio/piano/android/analytics/model/PrivacyMode;", "setCurrentMode", "(Lio/piano/android/analytics/model/PrivacyMode;)V", "getNewExpirationTimestamp", "", "getNewExpirationTimestamp$piano_analytics_release", "updatePrefs", "", "mode", "updatePrefs$piano_analytics_release", "Companion", "piano-analytics_release"})
@SourceDebugExtension(value={"SMAP\nPrivacyModesStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrivacyModesStorage.kt\nio/piano/android/analytics/PrivacyModesStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,86:1\n64#1:94\n288#2,2:87\n766#2:89\n857#2,2:90\n1855#2,2:92\n3792#3:95\n4307#3,2:96\n*S KotlinDebug\n*F\n+ 1 PrivacyModesStorage.kt\nio/piano/android/analytics/PrivacyModesStorage\n*L\n74#1:94\n34#1:87,2\n67#1:89\n67#1:90,2\n69#1:92,2\n81#1:95\n81#1:96,2\n*E\n"})
public final class PrivacyModesStorage {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final PrefsStorage prefsStorage;
    @NotNull
    private PrivacyMode currentMode;
    @NotNull
    private final Set<PrivacyMode> allModes;
    @NotNull
    private static final List<PrivacyStorageFeature> cachedPrivacyStorageFeatures;

    public PrivacyModesStorage(@NotNull Configuration configuration, @NotNull PrefsStorage prefsStorage) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)prefsStorage, (String)"prefsStorage");
        this.configuration = configuration;
        this.prefsStorage = prefsStorage;
        this.prefsStorage.setPrivacyStorageFilter$piano_analytics_release((Function1<? super PrivacyStorageFeature, Boolean>)((Function1)new Function1<PrivacyStorageFeature, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull PrivacyStorageFeature privacyStorageFeature) {
                Intrinsics.checkNotNullParameter((Object)((Object)privacyStorageFeature), (String)"privacyStorageFeature");
                boolean isNotForbidden = !this.getCurrentMode().getForbiddenStorageFeatures().contains((Object)PrivacyStorageFeature.ALL) || !this.getCurrentMode().getForbiddenStorageFeatures().contains((Object)privacyStorageFeature);
                boolean isAllowed = this.getCurrentMode().getAllowedStorageFeatures().contains((Object)PrivacyStorageFeature.ALL) || this.getCurrentMode().getAllowedStorageFeatures().contains((Object)privacyStorageFeature);
                return isNotForbidden && isAllowed;
            }
        }));
        this.currentMode = this.configuration.getDefaultPrivacyMode();
        Object[] objectArray = new PrivacyMode[]{PrivacyMode.Companion.getNO_CONSENT(), PrivacyMode.Companion.getNO_STORAGE(), PrivacyMode.Companion.getOPTIN(), PrivacyMode.Companion.getOPTOUT(), PrivacyMode.Companion.getEXEMPT()};
        this.allModes = SetsKt.mutableSetOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PrivacyMode getCurrentMode() {
        if (!Intrinsics.areEqual((Object)this.currentMode, (Object)PrivacyMode.Companion.getNO_CONSENT()) && !Intrinsics.areEqual((Object)this.currentMode, (Object)PrivacyMode.Companion.getNO_STORAGE())) {
            long l = System.currentTimeMillis();
            long l2 = this.prefsStorage.getPrivacyExpirationTimestamp();
            boolean bl = 1L <= l2 ? l2 <= l : false;
            if (bl) {
                this.setCurrentMode(this.configuration.getDefaultPrivacyMode());
            } else {
                PrivacyMode privacyMode;
                Object v1;
                block5: {
                    void $this$firstOrNull$iv;
                    Iterable iterable = this.allModes;
                    PrivacyModesStorage privacyModesStorage = this;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PrivacyMode it = (PrivacyMode)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getVisitorMode(), (Object)this.prefsStorage.getPrivacyMode())) continue;
                        v1 = element$iv;
                        break block5;
                    }
                    v1 = null;
                }
                if ((privacyMode = (PrivacyMode)v1) == null) {
                    privacyMode = this.configuration.getDefaultPrivacyMode();
                }
                privacyModesStorage.currentMode = privacyMode;
            }
        }
        return this.currentMode;
    }

    public final void setCurrentMode(@NotNull PrivacyMode value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!this.allModes.contains(value)) {
            boolean bl = false;
            String string2 = "Privacy mode " + value.getVisitorMode() + " is not registered.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.currentMode = value;
        this.updatePrefs$piano_analytics_release(value);
    }

    public static /* synthetic */ void getCurrentMode$annotations() {
    }

    @NotNull
    public final Set<PrivacyMode> getAllModes() {
        return this.allModes;
    }

    public static /* synthetic */ void getAllModes$annotations() {
    }

    public final long getNewExpirationTimestamp$piano_analytics_release() {
        boolean $i$f$getNewExpirationTimestamp$piano_analytics_release = false;
        return System.currentTimeMillis() + TimeUnit.DAYS.toMillis(this.configuration.getPrivacyStorageLifetime());
    }

    public final void updatePrefs$piano_analytics_release(@NotNull PrivacyMode mode) {
        PrefsStorage prefsStorage;
        Iterator $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Iterable $this$filter$iv = cachedPrivacyStorageFeatures;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            PrivacyStorageFeature it = (PrivacyStorageFeature)((Object)element$iv$iv);
            boolean bl = false;
            if (!(mode.getForbiddenStorageFeatures().contains((Object)it) || !mode.getAllowedStorageFeatures().contains((Object)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PrivacyStorageFeature it = (PrivacyStorageFeature)((Object)element$iv);
            boolean bl = false;
            this.prefsStorage.cleanStorageFeature$piano_analytics_release(it);
        }
        PrefsStorage $this$updatePrefs_u24lambda_u244 = prefsStorage = this.prefsStorage;
        boolean bl = false;
        $this$updatePrefs_u24lambda_u244.setPrivacyMode(mode.getVisitorMode());
        PrivacyModesStorage this_$iv = this;
        boolean $i$f$getNewExpirationTimestamp$piano_analytics_release = false;
        $this$updatePrefs_u24lambda_u244.setPrivacyExpirationTimestamp(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(this_$iv.configuration.getPrivacyStorageLifetime()));
        $this$updatePrefs_u24lambda_u244.setPrivacyVisitorConsent(mode.getVisitorConsent());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$filterTo$iv$iv;
        Companion = new Companion(null);
        PrivacyStorageFeature[] $this$filter$iv = PrivacyStorageFeature.values();
        boolean $i$f$filter = false;
        PrivacyStorageFeature[] privacyStorageFeatureArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(it != PrivacyStorageFeature.ALL)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        cachedPrivacyStorageFeatures = (List)var3_3;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lio/piano/android/analytics/PrivacyModesStorage$Companion;", "", "()V", "cachedPrivacyStorageFeatures", "", "Lio/piano/android/analytics/model/PrivacyStorageFeature;", "getCachedPrivacyStorageFeatures$annotations", "piano-analytics_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getCachedPrivacyStorageFeatures$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

