/*
 * Decompiled with CFR 0.152.
 */
package io.piano.android.analytics;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/piano/android/analytics/RetryInterceptor;", "Lokhttp3/Interceptor;", "maxAttempts", "", "sleepBetweenAttempts", "", "(IJ)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "piano-analytics_release"})
public final class RetryInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxAttempts;
    private final long sleepBetweenAttempts;
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    public static final long DEFAULT_SLEEP_MS = 400L;

    public RetryInterceptor(int maxAttempts, long sleepBetweenAttempts) {
        this.maxAttempts = maxAttempts;
        this.sleepBetweenAttempts = sleepBetweenAttempts;
    }

    public /* synthetic */ RetryInterceptor(int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        if ((n2 & 2) != 0) {
            l = 400L;
        }
        this(n, l);
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        int attempt = 1;
        int n = this.maxAttempts;
        if (attempt <= n) {
            while (true) {
                block7: {
                    try {
                        Response response = chain.proceed(request);
                        if (response.isSuccessful()) {
                            return response;
                        }
                        Timber.Forest.d("Unsuccessful request, retrying attempt " + attempt, new Object[0]);
                    }
                    catch (Exception e) {
                        Timber.Forest.d("Exception at request, retrying attempt " + attempt, new Object[0]);
                        if (attempt != this.maxAttempts) break block7;
                        throw e;
                    }
                }
                try {
                    Thread.sleep(this.sleepBetweenAttempts);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (attempt == n) break;
                ++attempt;
            }
        }
        throw new IOException("Reached max retry count");
    }

    public RetryInterceptor() {
        this(0, 0L, 3, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/piano/android/analytics/RetryInterceptor$Companion;", "", "()V", "DEFAULT_MAX_ATTEMPTS", "", "DEFAULT_SLEEP_MS", "", "piano-analytics_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

