/*
 * Decompiled with CFR 0.152.
 */
package io.piano.android.analytics.idproviders;

import io.piano.android.analytics.Configuration;
import io.piano.android.analytics.PrivacyModesStorage;
import io.piano.android.analytics.idproviders.IdProvider;
import io.piano.android.analytics.model.PrivacyMode;
import io.piano.android.analytics.model.VisitorIDType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lio/piano/android/analytics/idproviders/VisitorIdProvider;", "Lio/piano/android/analytics/idproviders/IdProvider;", "configuration", "Lio/piano/android/analytics/Configuration;", "privacyModesStorage", "Lio/piano/android/analytics/PrivacyModesStorage;", "limitedTrackingIdProvider", "idByTypeProvider", "Lkotlin/Function1;", "Lio/piano/android/analytics/model/VisitorIDType;", "(Lio/piano/android/analytics/Configuration;Lio/piano/android/analytics/PrivacyModesStorage;Lio/piano/android/analytics/idproviders/IdProvider;Lkotlin/jvm/functions/Function1;)V", "isLimitAdTrackingEnabled", "", "()Z", "visitorId", "", "getVisitorId", "()Ljava/lang/String;", "Companion", "piano-analytics_release"})
public final class VisitorIdProvider
implements IdProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final PrivacyModesStorage privacyModesStorage;
    @NotNull
    private final IdProvider limitedTrackingIdProvider;
    @NotNull
    private final Function1<VisitorIDType, IdProvider> idByTypeProvider;
    @NotNull
    public static final String NO_CONSENT_ID = "Consent-NO";
    @NotNull
    public static final String NO_STORAGE_ID = "no-storage";
    @NotNull
    public static final String OPT_OUT_ID = "opt-out";

    public VisitorIdProvider(@NotNull Configuration configuration, @NotNull PrivacyModesStorage privacyModesStorage, @NotNull IdProvider limitedTrackingIdProvider, @NotNull Function1<? super VisitorIDType, ? extends IdProvider> idByTypeProvider) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)privacyModesStorage, (String)"privacyModesStorage");
        Intrinsics.checkNotNullParameter((Object)limitedTrackingIdProvider, (String)"limitedTrackingIdProvider");
        Intrinsics.checkNotNullParameter(idByTypeProvider, (String)"idByTypeProvider");
        this.configuration = configuration;
        this.privacyModesStorage = privacyModesStorage;
        this.limitedTrackingIdProvider = limitedTrackingIdProvider;
        this.idByTypeProvider = idByTypeProvider;
    }

    @Override
    @Nullable
    public String getVisitorId() {
        String string2;
        PrivacyMode privacyMode = this.privacyModesStorage.getCurrentMode();
        if (Intrinsics.areEqual((Object)privacyMode, (Object)PrivacyMode.Companion.getNO_STORAGE())) {
            string2 = NO_STORAGE_ID;
        } else if (Intrinsics.areEqual((Object)privacyMode, (Object)PrivacyMode.Companion.getNO_CONSENT())) {
            string2 = NO_CONSENT_ID;
        } else if (Intrinsics.areEqual((Object)privacyMode, (Object)PrivacyMode.Companion.getOPTOUT())) {
            string2 = OPT_OUT_ID;
        } else {
            IdProvider provider = (IdProvider)this.idByTypeProvider.invoke((Object)this.configuration.getVisitorIDType());
            string2 = !provider.isLimitAdTrackingEnabled() ? provider.getVisitorId() : (this.configuration.getIgnoreLimitedAdTracking() ? this.limitedTrackingIdProvider.getVisitorId() : OPT_OUT_ID);
        }
        return string2;
    }

    @Override
    public boolean isLimitAdTrackingEnabled() {
        return ((IdProvider)this.idByTypeProvider.invoke((Object)this.configuration.getVisitorIDType())).isLimitAdTrackingEnabled();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/piano/android/analytics/idproviders/VisitorIdProvider$Companion;", "", "()V", "NO_CONSENT_ID", "", "NO_STORAGE_ID", "OPT_OUT_ID", "piano-analytics_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

