/*
 * Decompiled with CFR 0.152.
 */
package io.piano.android.analytics;

import com.squareup.moshi.JsonAdapter;
import io.piano.android.analytics.Configuration;
import io.piano.android.analytics.PrefsStorage;
import io.piano.android.analytics.model.User;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0019\u001a\u00020\u001aH\u0080\b\u00a2\u0006\u0002\b\u001bJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0082\bJ\u000f\u0010\u001e\u001a\u0004\u0018\u00010\b*\u00020\u000bH\u0082\bR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\b8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u0004\u0018\u00010\b8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lio/piano/android/analytics/UserStorage;", "", "configuration", "Lio/piano/android/analytics/Configuration;", "prefsStorage", "Lio/piano/android/analytics/PrefsStorage;", "userJsonAdapter", "Lcom/squareup/moshi/JsonAdapter;", "Lio/piano/android/analytics/model/User;", "(Lio/piano/android/analytics/Configuration;Lio/piano/android/analytics/PrefsStorage;Lcom/squareup/moshi/JsonAdapter;)V", "cachedUserPreference", "", "value", "currentUser", "getCurrentUser", "()Lio/piano/android/analytics/model/User;", "setCurrentUser", "(Lio/piano/android/analytics/model/User;)V", "storedUser", "getStoredUser", "<set-?>", "", "userRecognized", "getUserRecognized", "()Z", "getGenerationTimestamp", "", "getGenerationTimestamp$piano_analytics_release", "saveUser", "", "parseUser", "piano-analytics_release"})
@SourceDebugExtension(value={"SMAP\nUserStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserStorage.kt\nio/piano/android/analytics/UserStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n63#1:70\n67#1:71\n63#1:73\n56#1,2:74\n58#1,10:77\n56#1,2:87\n58#1,10:90\n67#1:100\n1#2:72\n1#2:76\n1#2:89\n*S KotlinDebug\n*F\n+ 1 UserStorage.kt\nio/piano/android/analytics/UserStorage\n*L\n16#1:70\n18#1:71\n27#1:73\n31#1:74,2\n31#1:77,10\n44#1:87,2\n44#1:90,10\n59#1:100\n31#1:76\n44#1:89\n*E\n"})
public final class UserStorage {
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final PrefsStorage prefsStorage;
    @NotNull
    private final JsonAdapter<User> userJsonAdapter;
    @Nullable
    private String cachedUserPreference;
    @Nullable
    private User storedUser;
    @Nullable
    private User currentUser;
    private boolean userRecognized;

    /*
     * WARNING - void declaration
     */
    public UserStorage(@NotNull Configuration configuration, @NotNull PrefsStorage prefsStorage, @NotNull JsonAdapter<User> userJsonAdapter) {
        User user;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)prefsStorage, (String)"prefsStorage");
        Intrinsics.checkNotNullParameter(userJsonAdapter, (String)"userJsonAdapter");
        this.configuration = configuration;
        this.prefsStorage = prefsStorage;
        this.userJsonAdapter = userJsonAdapter;
        String string2 = this.cachedUserPreference = this.prefsStorage.getUser();
        if (string2 != null) {
            void this_$iv;
            UserStorage userStorage = this;
            String $this$parseUser$iv = string2;
            boolean $i$f$parseUser = false;
            user = (User)this_$iv.userJsonAdapter.fromJson($this$parseUser$iv);
        } else {
            user = null;
        }
        this.storedUser = user;
        this.userRecognized = this.getStoredUser() != null;
    }

    /*
     * WARNING - void declaration
     */
    private final User getStoredUser() {
        UserStorage this_$iv = this;
        boolean $i$f$getGenerationTimestamp$piano_analytics_release = false;
        long now = System.currentTimeMillis();
        Long l = this.prefsStorage.getUserGenerateTimestamp();
        long it2 = ((Number)l).longValue();
        boolean bl = false;
        Long l2 = !(it2 == 0L) ? l : null;
        long generationTimestamp = l2 != null ? l2 : now;
        this.prefsStorage.setUserGenerateTimestamp(generationTimestamp);
        long expireTimestamp = generationTimestamp + TimeUnit.DAYS.toMillis(this.configuration.getUserStorageLifetime());
        if (expireTimestamp > now) {
            if (!Intrinsics.areEqual((Object)this.cachedUserPreference, (Object)this.prefsStorage.getUser())) {
                User user;
                this.cachedUserPreference = this.prefsStorage.getUser();
                String it2 = this.cachedUserPreference;
                if (it2 != null) {
                    void this_$iv2;
                    UserStorage userStorage = this;
                    String $this$parseUser$iv = it2;
                    boolean $i$f$parseUser = false;
                    user = (User)this_$iv2.userJsonAdapter.fromJson($this$parseUser$iv);
                } else {
                    user = null;
                }
                this.storedUser = user;
            }
        } else {
            void this_$iv3;
            this.userRecognized = false;
            UserStorage it2 = this;
            Object value$iv = null;
            boolean $i$f$saveUser = false;
            this_$iv3.storedUser = value$iv;
            this_$iv3.cachedUserPreference = null;
            this_$iv3.prefsStorage.setUser(this_$iv3.cachedUserPreference);
            this_$iv3.prefsStorage.setUserGenerateTimestamp(0L);
        }
        return this.storedUser;
    }

    @Nullable
    public final User getCurrentUser() {
        User user = this.currentUser;
        if (user == null) {
            user = this.getStoredUser();
        }
        return user;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCurrentUser(@Nullable User value) {
        this.userRecognized = false;
        if (value == null || value.getShouldBeStored()) {
            long l;
            String string2;
            Object object;
            UserStorage this_$iv = this;
            boolean $i$f$saveUser = false;
            this_$iv.storedUser = value;
            UserStorage userStorage = this_$iv;
            User user = value;
            if (user != null) {
                void it$iv;
                User user2 = user;
                object = userStorage;
                boolean bl = false;
                string2 = this_$iv.userJsonAdapter.toJson((Object)it$iv);
                userStorage = object;
            } else {
                string2 = null;
            }
            userStorage.cachedUserPreference = string2;
            this_$iv.prefsStorage.setUser(this_$iv.cachedUserPreference);
            Object object2 = this_$iv.prefsStorage;
            User user3 = value;
            if (user3 != null) {
                User user4 = user3;
                object = object2;
                boolean bl = false;
                UserStorage this_$iv$iv = this_$iv;
                boolean $i$f$getGenerationTimestamp$piano_analytics_release = false;
                object2 = object;
                l = ((Number)System.currentTimeMillis()).longValue();
            } else {
                l = 0L;
            }
            ((PrefsStorage)object2).setUserGenerateTimestamp(l);
        }
    }

    public final boolean getUserRecognized() {
        return this.userRecognized;
    }

    /*
     * WARNING - void declaration
     */
    private final void saveUser(User value) {
        long l;
        String string2;
        Object object;
        boolean $i$f$saveUser = false;
        this.storedUser = value;
        UserStorage userStorage = this;
        User user = value;
        if (user != null) {
            void it;
            User user2 = user;
            object = userStorage;
            boolean bl = false;
            string2 = this.userJsonAdapter.toJson((Object)it);
            userStorage = object;
        } else {
            string2 = null;
        }
        userStorage.cachedUserPreference = string2;
        this.prefsStorage.setUser(this.cachedUserPreference);
        Object object2 = this.prefsStorage;
        User user3 = value;
        if (user3 != null) {
            User user4 = user3;
            object = object2;
            boolean bl = false;
            UserStorage this_$iv = this;
            boolean $i$f$getGenerationTimestamp$piano_analytics_release = false;
            long l2 = System.currentTimeMillis();
            object2 = object;
            l = l2;
        } else {
            l = 0L;
        }
        ((PrefsStorage)object2).setUserGenerateTimestamp(l);
    }

    private final User parseUser(String $this$parseUser) {
        boolean $i$f$parseUser = false;
        return (User)this.userJsonAdapter.fromJson($this$parseUser);
    }

    public final long getGenerationTimestamp$piano_analytics_release() {
        boolean $i$f$getGenerationTimestamp$piano_analytics_release = false;
        return System.currentTimeMillis();
    }
}

