/*
 * Decompiled with CFR 0.152.
 */
package io.piano.android.analytics;

import io.piano.android.analytics.Configuration;
import io.piano.android.analytics.PrefsStorage;
import io.piano.android.analytics.model.PrivacyMode;
import io.piano.android.analytics.model.PrivacyStorageFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0016\u001a\u00020\u0017H\u0080\b\u00a2\u0006\u0002\b\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b R\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0011\u0010\u000b\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/piano/android/analytics/PrivacyModesStorage;", "", "configuration", "Lio/piano/android/analytics/Configuration;", "prefsStorage", "Lio/piano/android/analytics/PrefsStorage;", "(Lio/piano/android/analytics/Configuration;Lio/piano/android/analytics/PrefsStorage;)V", "allModes", "", "Lio/piano/android/analytics/model/PrivacyMode;", "getAllModes$annotations", "()V", "getAllModes", "()Ljava/util/Set;", "cachedMode", "value", "currentMode", "getCurrentMode$annotations", "getCurrentMode", "()Lio/piano/android/analytics/model/PrivacyMode;", "setCurrentMode", "(Lio/piano/android/analytics/model/PrivacyMode;)V", "getNewExpirationTimestamp", "", "getNewExpirationTimestamp$piano_analytics_release", "isFeatureAllowed", "", "privacyStorageFeature", "Lio/piano/android/analytics/model/PrivacyStorageFeature;", "updatePrefs", "", "mode", "updatePrefs$piano_analytics_release", "Companion", "piano-analytics_release"})
@SourceDebugExtension(value={"SMAP\nPrivacyModesStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrivacyModesStorage.kt\nio/piano/android/analytics/PrivacyModesStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,91:1\n69#1:94\n288#2,2:92\n766#2:95\n857#2,2:96\n1855#2,2:98\n3792#3:100\n4307#3,2:101\n*S KotlinDebug\n*F\n+ 1 PrivacyModesStorage.kt\nio/piano/android/analytics/PrivacyModesStorage\n*L\n74#1:94\n47#1:92,2\n76#1:95\n76#1:96,2\n78#1:98,2\n86#1:100\n86#1:101,2\n*E\n"})
public final class PrivacyModesStorage {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final PrefsStorage prefsStorage;
    @NotNull
    private final Set<PrivacyMode> allModes;
    @NotNull
    private PrivacyMode currentMode;
    @NotNull
    private PrivacyMode cachedMode;
    @NotNull
    private static final List<PrivacyStorageFeature> cachedPrivacyStorageFeatures;

    public PrivacyModesStorage(@NotNull Configuration configuration, @NotNull PrefsStorage prefsStorage) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)prefsStorage, (String)"prefsStorage");
        this.configuration = configuration;
        this.prefsStorage = prefsStorage;
        this.prefsStorage.setPrivacyStorageFilter$piano_analytics_release((Function1<? super PrivacyStorageFeature, Boolean>)((Function1)new Function1<PrivacyStorageFeature, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull PrivacyStorageFeature p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return ((PrivacyModesStorage)this.receiver).isFeatureAllowed(p0);
            }
        }));
        Object[] objectArray = new PrivacyMode[]{PrivacyMode.Companion.getNO_CONSENT(), PrivacyMode.Companion.getNO_STORAGE(), PrivacyMode.Companion.getOPTIN(), PrivacyMode.Companion.getOPTOUT(), PrivacyMode.Companion.getEXEMPT()};
        this.allModes = SetsKt.mutableSetOf((Object[])objectArray);
        this.currentMode = this.configuration.getDefaultPrivacyMode();
        this.cachedMode = this.getCurrentMode();
    }

    private final boolean isFeatureAllowed(PrivacyStorageFeature privacyStorageFeature) {
        boolean isNotForbidden = !this.cachedMode.getForbiddenStorageFeatures().contains((Object)PrivacyStorageFeature.ALL) || !this.cachedMode.getForbiddenStorageFeatures().contains((Object)privacyStorageFeature);
        boolean isAllowed = this.cachedMode.getAllowedStorageFeatures().contains((Object)PrivacyStorageFeature.ALL) || this.cachedMode.getAllowedStorageFeatures().contains((Object)privacyStorageFeature);
        return isNotForbidden && isAllowed;
    }

    @NotNull
    public final Set<PrivacyMode> getAllModes() {
        return this.allModes;
    }

    public static /* synthetic */ void getAllModes$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PrivacyMode getCurrentMode() {
        if (!Intrinsics.areEqual((Object)this.currentMode, (Object)PrivacyMode.Companion.getNO_CONSENT()) && !Intrinsics.areEqual((Object)this.currentMode, (Object)PrivacyMode.Companion.getNO_STORAGE())) {
            long l = System.currentTimeMillis();
            long l2 = this.prefsStorage.getPrivacyExpirationTimestamp();
            boolean bl = 1L <= l2 ? l2 <= l : false;
            if (bl) {
                this.setCurrentMode(this.configuration.getDefaultPrivacyMode());
            } else {
                PrivacyMode privacyMode;
                Object v1;
                block5: {
                    void $this$firstOrNull$iv;
                    Iterable iterable = this.allModes;
                    PrivacyModesStorage privacyModesStorage = this;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PrivacyMode it = (PrivacyMode)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getVisitorMode(), (Object)this.prefsStorage.getPrivacyMode())) continue;
                        v1 = element$iv;
                        break block5;
                    }
                    v1 = null;
                }
                if ((privacyMode = (PrivacyMode)v1) == null) {
                    privacyMode = this.configuration.getDefaultPrivacyMode();
                }
                privacyModesStorage.currentMode = privacyMode;
            }
        }
        this.cachedMode = this.currentMode;
        return this.currentMode;
    }

    public final void setCurrentMode(@NotNull PrivacyMode value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!this.allModes.contains(value)) {
            boolean bl = false;
            String string2 = "Privacy mode " + value.getVisitorMode() + " is not registered.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.cachedMode = value;
        this.currentMode = value;
        this.updatePrefs$piano_analytics_release(value);
    }

    public static /* synthetic */ void getCurrentMode$annotations() {
    }

    public final long getNewExpirationTimestamp$piano_analytics_release() {
        boolean $i$f$getNewExpirationTimestamp$piano_analytics_release = false;
        return System.currentTimeMillis() + TimeUnit.DAYS.toMillis(this.configuration.getPrivacyStorageLifetime());
    }

    /*
     * WARNING - void declaration
     */
    public final void updatePrefs$piano_analytics_release(@NotNull PrivacyMode mode) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        PrefsStorage prefsStorage;
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        PrefsStorage $this$updatePrefs_u24lambda_u244 = prefsStorage = this.prefsStorage;
        boolean bl = false;
        $this$updatePrefs_u24lambda_u244.setPrivacyMode(mode.getVisitorMode());
        PrivacyModesStorage this_$iv = this;
        boolean $i$f$getNewExpirationTimestamp$piano_analytics_release = false;
        $this$updatePrefs_u24lambda_u244.setPrivacyExpirationTimestamp(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(this_$iv.configuration.getPrivacyStorageLifetime()));
        $this$updatePrefs_u24lambda_u244.setPrivacyVisitorConsent(mode.getVisitorConsent());
        Iterable $this$filter$iv = cachedPrivacyStorageFeatures;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PrivacyStorageFeature it = (PrivacyStorageFeature)((Object)element$iv$iv);
            boolean bl2 = false;
            if (!(!this.isFeatureAllowed(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PrivacyStorageFeature it = (PrivacyStorageFeature)((Object)element$iv);
            boolean bl3 = false;
            $this$updatePrefs_u24lambda_u244.cleanStorageFeature$piano_analytics_release(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$filterTo$iv$iv;
        Companion = new Companion(null);
        PrivacyStorageFeature[] $this$filter$iv = PrivacyStorageFeature.values();
        boolean $i$f$filter = false;
        PrivacyStorageFeature[] privacyStorageFeatureArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(it != PrivacyStorageFeature.ALL)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        cachedPrivacyStorageFeatures = (List)var3_3;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lio/piano/android/analytics/PrivacyModesStorage$Companion;", "", "()V", "cachedPrivacyStorageFeatures", "", "Lio/piano/android/analytics/model/PrivacyStorageFeature;", "getCachedPrivacyStorageFeatures$annotations", "piano-analytics_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getCachedPrivacyStorageFeatures$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

