/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone;

import io.pinecone.PineconeClientConfig;
import io.pinecone.model.CreateIndexRequest;
import java.io.IOException;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;

public class PineconeIndexOperationClient {
    private AsyncHttpClient client;
    private PineconeClientConfig clientConfig;
    private String url;

    PineconeIndexOperationClient(PineconeClientConfig clientConfig, AsyncHttpClient client) {
        this.clientConfig = clientConfig;
        this.client = client;
        this.url = "https://controller." + clientConfig.getEnvironment() + ".pinecone.io/databases/";
    }

    public PineconeIndexOperationClient(PineconeClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.client = new DefaultAsyncHttpClient();
        this.url = "https://controller." + clientConfig.getEnvironment() + ".pinecone.io/databases/";
    }

    public void deleteIndex(String indexName) throws IOException {
        System.out.println("Sending delete index request:");
        ((BoundRequestBuilder)((BoundRequestBuilder)this.client.prepare("DELETE", this.url + indexName).setHeader((CharSequence)"accept", "text/plain")).setHeader((CharSequence)"Api-Key", this.clientConfig.getApiKey())).execute().toCompletableFuture().join();
        this.client.close();
    }

    public void createIndex(CreateIndexRequest createIndexRequest) throws IOException {
        ((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)this.client.prepare("POST", this.url).setHeader((CharSequence)"accept", "text/plain")).setHeader((CharSequence)"content-type", "application/json")).setHeader((CharSequence)"Api-Key", this.clientConfig.getApiKey())).setBody(createIndexRequest.toJson())).execute().toCompletableFuture().join();
        this.client.close();
    }
}

