/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone;

import io.pinecone.PineconeValidationException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class PineconeClientConfig {
    private String apiKey;
    private String projectName;
    private String environment;
    private int serverSideTimeoutSec = 20;

    public PineconeClientConfig() {
    }

    protected PineconeClientConfig(PineconeClientConfig other) {
        this.apiKey = other.apiKey;
        this.projectName = other.projectName;
        this.environment = other.environment;
        this.serverSideTimeoutSec = other.serverSideTimeoutSec;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public PineconeClientConfig withApiKey(String apiKey) {
        PineconeClientConfig config = new PineconeClientConfig(this);
        config.apiKey = apiKey;
        return config;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public PineconeClientConfig withProjectName(String projectName) {
        PineconeClientConfig config = new PineconeClientConfig(this);
        config.projectName = projectName;
        return config;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public PineconeClientConfig withEnvironment(String environment) {
        PineconeClientConfig config = new PineconeClientConfig(this);
        config.environment = environment;
        return config;
    }

    public int getServerSideTimeoutSec() {
        return this.serverSideTimeoutSec;
    }

    public PineconeClientConfig withServerSideTimeoutSec(int serverSideTimeout) {
        PineconeClientConfig config = new PineconeClientConfig(this);
        config.serverSideTimeoutSec = serverSideTimeout;
        return config;
    }

    void validate() {
        if (this.apiKey == null) {
            throw new PineconeValidationException("Invalid Pinecone config: missing apiKey");
        }
    }

    public String toString() {
        return "PineconeConnectionConfig(apiKey=" + this.maskedApiKey() + ", projectName=" + this.projectName + ", environment=" + this.environment + ", serverSideTimeoutSec=" + this.getServerSideTimeoutSec() + ")";
    }

    private String maskedApiKey() {
        if (this.apiKey == null) {
            return "NULL";
        }
        List splits = Arrays.stream(this.apiKey.split("-")).map(split -> String.join((CharSequence)"", Collections.nCopies(split.length(), "*"))).collect(Collectors.toList());
        return String.join((CharSequence)"-", splits);
    }
}

