/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone;

import io.grpc.ManagedChannel;
import io.pinecone.PineconeClientConfig;
import io.pinecone.exceptions.PineconeValidationException;
import java.util.function.BiFunction;

public class PineconeConnectionConfig {
    private BiFunction<PineconeClientConfig, PineconeConnectionConfig, ManagedChannel> customChannelBuilder;
    private String indexName;
    private String connectionUrl;

    public PineconeConnectionConfig() {
    }

    protected PineconeConnectionConfig(PineconeConnectionConfig other) {
        this.indexName = other.indexName;
        this.connectionUrl = other.connectionUrl;
        this.customChannelBuilder = other.customChannelBuilder;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public PineconeConnectionConfig withIndexName(String indexName) {
        PineconeConnectionConfig config = new PineconeConnectionConfig(this);
        config.indexName = indexName;
        return config;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public PineconeConnectionConfig withConnectionUrl(String connectionUrl) {
        PineconeConnectionConfig config = new PineconeConnectionConfig(this);
        config.connectionUrl = connectionUrl;
        return config;
    }

    public BiFunction<PineconeClientConfig, PineconeConnectionConfig, ManagedChannel> getCustomChannelBuilder() {
        return this.customChannelBuilder;
    }

    public PineconeConnectionConfig withCustomChannelBuilder(BiFunction<PineconeClientConfig, PineconeConnectionConfig, ManagedChannel> customChannelBuilder) {
        PineconeConnectionConfig config = new PineconeConnectionConfig(this);
        config.customChannelBuilder = customChannelBuilder;
        return config;
    }

    void validate() {
        if (this.indexName == null && this.connectionUrl == null) {
            throw new PineconeValidationException("Invalid PineconeConnectionConfig, indexName or connection url must be specified.");
        }
    }

    public String toString() {
        return "PineconeConnectionConfig(customChannelBuilder=" + this.getCustomChannelBuilder() + ", indexName=" + this.getIndexName() + ", connectionUrl=" + this.getConnectionUrl() + ")";
    }
}

