/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.pinecone.exceptions.PineconeValidationException;
import io.pinecone.model.IndexMetadataConfig;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CreateIndexRequest {
    private String indexName;
    private Integer dimension;
    private String metric = "cosine";
    private Integer pods;
    private Integer replicas = 1;
    private String podType = "p1.x1";
    private IndexMetadataConfig metadataConfig;
    private String sourceCollection;

    public CreateIndexRequest withIndexName(String name) {
        this.indexName = name;
        return this;
    }

    @Nonnull
    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public CreateIndexRequest withDimension(Integer dimension) {
        this.dimension = dimension;
        return this;
    }

    @Nonnull
    public Integer getDimension() {
        return this.dimension;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public CreateIndexRequest withMetric(String metric) {
        this.metric = metric;
        return this;
    }

    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public CreateIndexRequest withPods(Integer pods) {
        this.pods = pods;
        return this;
    }

    public Integer getPods() {
        return this.pods;
    }

    public void setPods(Integer pods) {
        this.pods = pods;
    }

    public CreateIndexRequest withReplicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public CreateIndexRequest withPodType(String podType) {
        this.podType = podType;
        return this;
    }

    public String getPodType() {
        return this.podType;
    }

    public void setPodType(String podType) {
        this.podType = podType;
    }

    public CreateIndexRequest withMetadataConfig(IndexMetadataConfig metadataConfig) {
        this.metadataConfig = metadataConfig;
        return this;
    }

    @Nullable
    public IndexMetadataConfig getMetadataConfig() {
        return this.metadataConfig;
    }

    public void setMetadataConfig(IndexMetadataConfig metadataConfig) {
        this.metadataConfig = metadataConfig;
    }

    public CreateIndexRequest withSourceCollection(String sourceCollection) {
        this.sourceCollection = sourceCollection;
        return this;
    }

    @Nullable
    public String getSourceCollection() {
        return this.sourceCollection;
    }

    public void setSourceCollection(String sourceCollection) {
        this.sourceCollection = sourceCollection;
    }

    public String toJson() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.createObjectNode().put("metric", this.metric).put("pods", this.pods).put("replicas", this.replicas).put("pod_type", this.podType).put("name", this.indexName).put("dimension", this.dimension).put("source_collection", this.sourceCollection).set("metadata_config", mapper.valueToTree((Object)this.metadataConfig));
        CreateIndexRequest.validateJsonObject(jsonNode);
        return jsonNode.toString();
    }

    public static void validateJsonObject(JsonNode jsonNode) {
        if (jsonNode.get("name").isNull()) {
            throw new PineconeValidationException("Index name cannot be empty");
        }
        if (jsonNode.get("dimension").isNull()) {
            throw new PineconeValidationException("Dimension cannot be empty");
        }
    }
}

