/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone.commons;

import com.google.protobuf.Struct;
import io.pinecone.exceptions.PineconeValidationException;
import io.pinecone.proto.DeleteRequest;
import io.pinecone.proto.DescribeIndexStatsRequest;
import io.pinecone.proto.FetchRequest;
import io.pinecone.proto.QueryRequest;
import io.pinecone.proto.SparseValues;
import io.pinecone.proto.UpdateRequest;
import io.pinecone.proto.UpsertRequest;
import io.pinecone.proto.Vector;
import io.pinecone.unsigned_indices_model.SparseValuesWithUnsignedIndices;
import io.pinecone.unsigned_indices_model.VectorWithUnsignedIndices;
import io.pinecone.utils.SparseIndicesConverter;
import java.util.ArrayList;
import java.util.List;

public interface IndexInterface<T, U, V, W, X, Y>
extends AutoCloseable {
    default public UpsertRequest validateUpsertRequest(String id, List<Float> values, List<Long> sparseIndices, List<Float> sparseValues, Struct metadata, String namespace) {
        UpsertRequest.Builder upsertRequest = UpsertRequest.newBuilder();
        Vector vector = this.buildUpsertVector(id, values, sparseIndices, sparseValues, metadata);
        upsertRequest.addVectors(vector);
        if (namespace != null) {
            upsertRequest.setNamespace(namespace);
        }
        return upsertRequest.build();
    }

    default public UpsertRequest validateUpsertRequest(List<VectorWithUnsignedIndices> vectorWithUnsignedIndicesList, String namespace) {
        ArrayList<Vector> vectors = new ArrayList<Vector>(vectorWithUnsignedIndicesList.size());
        for (VectorWithUnsignedIndices vectorWithUnsignedIndices : vectorWithUnsignedIndicesList) {
            SparseValuesWithUnsignedIndices sparseValuesWithUnsignedIndices = vectorWithUnsignedIndices.getSparseValuesWithUnsignedIndices();
            Vector vector = this.buildUpsertVector(vectorWithUnsignedIndices.getId(), vectorWithUnsignedIndices.getValuesList(), sparseValuesWithUnsignedIndices != null ? sparseValuesWithUnsignedIndices.getIndicesWithUnsigned32IntList() : null, sparseValuesWithUnsignedIndices != null ? sparseValuesWithUnsignedIndices.getValuesList() : null, vectorWithUnsignedIndices.getMetadata());
            vectors.add(vector);
        }
        return UpsertRequest.newBuilder().addAllVectors(vectors).setNamespace(namespace).build();
    }

    default public Vector buildUpsertVector(String id, List<Float> values, List<Long> sparseIndices, List<Float> sparseValues, Struct metadata) {
        if (id == null || id.isEmpty() || values == null || values.isEmpty()) {
            throw new PineconeValidationException("Invalid upsert request. Please ensure that both id and values are provided.");
        }
        Vector.Builder vectorBuilder = Vector.newBuilder().setId(id).addAllValues(values);
        if (sparseIndices != null && sparseValues == null || sparseIndices == null && sparseValues != null) {
            throw new PineconeValidationException("Invalid upsert request. Please ensure that both sparse indices and values are present.");
        }
        if (sparseIndices != null) {
            if (sparseIndices.size() != sparseValues.size()) {
                throw new PineconeValidationException("Invalid upsert request. Please ensure that both sparse indices and values are of the same length.");
            }
            vectorBuilder.setSparseValues(SparseValues.newBuilder().addAllIndices(SparseIndicesConverter.convertUnsigned32IntToSigned32Int(sparseIndices)).addAllValues(sparseValues).build());
        }
        if (metadata != null) {
            vectorBuilder.setMetadata(metadata);
        }
        return vectorBuilder.build();
    }

    public static VectorWithUnsignedIndices buildUpsertVectorWithUnsignedIndices(String id, List<Float> values, List<Long> sparseIndices, List<Float> sparseValues, Struct metadata) {
        if (id == null || id.isEmpty() || values == null || values.isEmpty()) {
            throw new PineconeValidationException("Invalid upsert request. Please ensure that both id and values are provided.");
        }
        VectorWithUnsignedIndices vectorWithUnsignedIndices = new VectorWithUnsignedIndices(id, values);
        if (sparseIndices != null && sparseValues == null || sparseIndices == null && sparseValues != null) {
            throw new PineconeValidationException("Invalid upsert request. Please ensure that both sparse indices and values are present.");
        }
        if (sparseIndices != null) {
            if (sparseIndices.size() != sparseValues.size()) {
                throw new PineconeValidationException("Invalid upsert request. Please ensure that both sparse indices and values are of the same length.");
            }
            SparseValuesWithUnsignedIndices sparseValuesWithUnsignedIndices = new SparseValuesWithUnsignedIndices();
            sparseValuesWithUnsignedIndices.setIndicesWithUnsigned32Int(sparseIndices);
            sparseValuesWithUnsignedIndices.setValues(sparseValues);
            vectorWithUnsignedIndices.setSparseValuesWithUnsignedIndices(sparseValuesWithUnsignedIndices);
        }
        if (metadata != null) {
            vectorWithUnsignedIndices.setMetadata(metadata);
        }
        return vectorWithUnsignedIndices;
    }

    default public QueryRequest validateQueryRequest(int topK, List<Float> vector, List<Long> sparseIndices, List<Float> sparseValues, String id, String namespace, Struct filter, boolean includeValues, boolean includeMetadata) {
        QueryRequest.Builder queryRequest = QueryRequest.newBuilder();
        if (id != null && !id.isEmpty() && vector != null && !vector.isEmpty()) {
            throw new PineconeValidationException("Invalid query request. Cannot query with both vector id and vector values.");
        }
        if (id != null && !id.isEmpty()) {
            queryRequest.setId(id);
        }
        if (namespace != null) {
            queryRequest.setNamespace(namespace);
        }
        queryRequest.setTopK(topK).setIncludeValues(includeValues).setIncludeMetadata(includeMetadata);
        if (filter != null) {
            queryRequest.setFilter(filter);
        }
        if (vector != null && !vector.isEmpty()) {
            queryRequest.addAllVector(vector);
        }
        if (sparseIndices != null && sparseValues == null || sparseIndices == null && sparseValues != null) {
            throw new PineconeValidationException("Invalid upsert request. Please ensure that both sparse indices and values are present.");
        }
        if (sparseIndices != null) {
            if (sparseIndices.size() != sparseValues.size()) {
                throw new PineconeValidationException("Invalid upsert request. Please ensure that both sparse indices and values are of the same length.");
            }
            queryRequest.setSparseVector(SparseValues.newBuilder().addAllIndices(SparseIndicesConverter.convertUnsigned32IntToSigned32Int(sparseIndices)).addAllValues(sparseValues).build());
        }
        return queryRequest.build();
    }

    default public FetchRequest validateFetchRequest(List<String> ids, String namespace) {
        FetchRequest.Builder fetchRequest = FetchRequest.newBuilder();
        if (ids == null || ids.isEmpty()) {
            throw new PineconeValidationException("Invalid fetch request. Vector ids must be present");
        }
        fetchRequest.addAllIds(ids);
        if (namespace != null) {
            fetchRequest.setNamespace(namespace);
        }
        return fetchRequest.build();
    }

    default public UpdateRequest validateUpdateRequest(String id, List<Float> values, Struct metadata, String namespace, List<Long> sparseIndices, List<Float> sparseValues) {
        UpdateRequest.Builder updateRequest = UpdateRequest.newBuilder();
        if (id == null) {
            throw new PineconeValidationException("Invalid update request. Vector id must be present");
        }
        updateRequest.setId(id);
        if (values != null) {
            updateRequest.addAllValues(values);
        }
        if (metadata != null) {
            updateRequest.setSetMetadata(metadata);
        }
        if (namespace != null) {
            updateRequest.setNamespace(namespace);
        }
        if (sparseIndices != null && sparseValues == null || sparseIndices == null && sparseValues != null) {
            throw new PineconeValidationException("Invalid upsert request. Please ensure that both sparse indices and values are present.");
        }
        if (sparseIndices != null) {
            if (sparseIndices.size() != sparseValues.size()) {
                throw new PineconeValidationException("Invalid upsert request. Please ensure that both sparse indices and values are of the same length.");
            }
            updateRequest.setSparseValues(SparseValues.newBuilder().addAllIndices(SparseIndicesConverter.convertUnsigned32IntToSigned32Int(sparseIndices)).addAllValues(sparseValues).build());
        }
        return updateRequest.build();
    }

    default public DeleteRequest validateDeleteRequest(List<String> ids, boolean deleteAll, String namespace, Struct filter) {
        DeleteRequest.Builder deleteRequest = DeleteRequest.newBuilder().setDeleteAll(deleteAll);
        if (ids != null && !ids.isEmpty()) {
            deleteRequest.addAllIds(ids);
        }
        if (namespace != null) {
            deleteRequest.setNamespace(namespace);
        }
        if (filter != null) {
            deleteRequest.setFilter(filter);
        }
        return deleteRequest.build();
    }

    default public DescribeIndexStatsRequest validateDescribeIndexStatsRequest(Struct filter) {
        DescribeIndexStatsRequest.Builder describeIndexStatsRequest = DescribeIndexStatsRequest.newBuilder();
        if (filter != null) {
            describeIndexStatsRequest.setFilter(filter);
        }
        return describeIndexStatsRequest.build();
    }

    public T upsert(List<VectorWithUnsignedIndices> var1, String var2);

    public T upsert(String var1, List<Float> var2);

    public T upsert(String var1, List<Float> var2, String var3);

    public T upsert(String var1, List<Float> var2, List<Long> var3, List<Float> var4, Struct var5, String var6);

    public U queryByVectorId(int var1, String var2);

    public U queryByVectorId(int var1, String var2, boolean var3, boolean var4);

    public U queryByVectorId(int var1, String var2, String var3);

    public U queryByVectorId(int var1, String var2, String var3, boolean var4, boolean var5);

    public U queryByVectorId(int var1, String var2, String var3, Struct var4);

    public U queryByVectorId(int var1, String var2, String var3, Struct var4, boolean var5, boolean var6);

    public U queryByVector(int var1, List<Float> var2);

    public U queryByVector(int var1, List<Float> var2, boolean var3, boolean var4);

    public U queryByVector(int var1, List<Float> var2, String var3);

    public U queryByVector(int var1, List<Float> var2, String var3, boolean var4, boolean var5);

    public U queryByVector(int var1, List<Float> var2, String var3, Struct var4);

    public U queryByVector(int var1, List<Float> var2, String var3, Struct var4, boolean var5, boolean var6);

    public U query(int var1, List<Float> var2, List<Long> var3, List<Float> var4, String var5, String var6, Struct var7, boolean var8, boolean var9);

    public V fetch(List<String> var1);

    public V fetch(List<String> var1, String var2);

    public W update(String var1, List<Float> var2);

    public W update(String var1, List<Float> var2, String var3);

    public W update(String var1, List<Float> var2, Struct var3, String var4, List<Long> var5, List<Float> var6);

    public X deleteByIds(List<String> var1);

    public X deleteByIds(List<String> var1, String var2);

    public X deleteByFilter(Struct var1);

    public X deleteByFilter(Struct var1, String var2);

    public X deleteAll(String var1);

    public X delete(List<String> var1, boolean var2, String var3, Struct var4);

    public Y describeIndexStats();

    public Y describeIndexStats(Struct var1);
}

