/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone.clients;

import io.pinecone.clients.AsyncIndex;
import io.pinecone.clients.Index;
import io.pinecone.configs.PineconeConfig;
import io.pinecone.configs.PineconeConnection;
import io.pinecone.exceptions.FailedRequestInfo;
import io.pinecone.exceptions.HttpErrorMapper;
import io.pinecone.exceptions.PineconeException;
import io.pinecone.exceptions.PineconeValidationException;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.OkHttpClient;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.api.ManageIndexesApi;
import org.openapitools.client.model.CollectionList;
import org.openapitools.client.model.CollectionModel;
import org.openapitools.client.model.ConfigureIndexRequest;
import org.openapitools.client.model.ConfigureIndexRequestSpec;
import org.openapitools.client.model.ConfigureIndexRequestSpecPod;
import org.openapitools.client.model.CreateCollectionRequest;
import org.openapitools.client.model.CreateIndexRequest;
import org.openapitools.client.model.CreateIndexRequestSpec;
import org.openapitools.client.model.CreateIndexRequestSpecPod;
import org.openapitools.client.model.CreateIndexRequestSpecPodMetadataConfig;
import org.openapitools.client.model.IndexList;
import org.openapitools.client.model.IndexMetric;
import org.openapitools.client.model.IndexModel;
import org.openapitools.client.model.ServerlessSpec;

public class Pinecone {
    private static final ConcurrentHashMap<String, PineconeConnection> connectionsMap = new ConcurrentHashMap();
    private final ManageIndexesApi manageIndexesApi;
    private final PineconeConfig config;

    Pinecone(PineconeConfig config, ManageIndexesApi manageIndexesApi) {
        this.config = config;
        this.manageIndexesApi = manageIndexesApi;
    }

    public IndexModel createServerlessIndex(String indexName, String metric, int dimension, String cloud, String region) throws PineconeException {
        if (indexName == null || indexName.isEmpty()) {
            throw new PineconeValidationException("Index name cannot be null or empty");
        }
        if (metric == null || metric.isEmpty()) {
            throw new PineconeValidationException("Metric cannot be null or empty. Must be one of " + Arrays.toString((Object[])IndexMetric.values()));
        }
        try {
            IndexMetric.fromValue(metric.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            throw new PineconeValidationException("Metric cannot be null or empty. Must be one of " + Arrays.toString((Object[])IndexMetric.values()));
        }
        if (dimension < 1) {
            throw new PineconeValidationException("Dimension must be greater than 0. See limits for more info: https://docs.pinecone.io/reference/limits");
        }
        if (cloud == null || cloud.isEmpty()) {
            throw new PineconeValidationException("Cloud cannot be null or empty. Must be one of " + Arrays.toString((Object[])ServerlessSpec.CloudEnum.values()));
        }
        try {
            ServerlessSpec.CloudEnum.fromValue(cloud.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            throw new PineconeValidationException("Cloud cannot be null or empty. Must be one of " + Arrays.toString((Object[])ServerlessSpec.CloudEnum.values()));
        }
        if (region == null || region.isEmpty()) {
            throw new PineconeValidationException("Region cannot be null or empty");
        }
        IndexMetric userMetric = IndexMetric.fromValue(metric.toLowerCase());
        ServerlessSpec.CloudEnum cloudProvider = ServerlessSpec.CloudEnum.fromValue(cloud.toLowerCase());
        ServerlessSpec serverlessSpec = new ServerlessSpec().cloud(cloudProvider).region(region);
        CreateIndexRequestSpec createServerlessIndexRequestSpec = new CreateIndexRequestSpec().serverless(serverlessSpec);
        IndexModel indexModel = null;
        try {
            indexModel = this.manageIndexesApi.createIndex(new CreateIndexRequest().name(indexName).metric(userMetric).dimension(dimension).spec(createServerlessIndexRequestSpec));
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return indexModel;
    }

    public IndexModel createPodsIndex(String indexName, Integer dimension, String environment, String podType) {
        return this.createPodsIndex(indexName, dimension, environment, podType, null, null, null, null, null, null);
    }

    public IndexModel createPodsIndex(String indexName, Integer dimension, String environment, String podType, String metric) {
        return this.createPodsIndex(indexName, dimension, environment, podType, metric, null, null, null, null, null);
    }

    public IndexModel createPodsIndex(String indexName, Integer dimension, String environment, String podType, String metric, CreateIndexRequestSpecPodMetadataConfig metadataConfig) {
        return this.createPodsIndex(indexName, dimension, environment, podType, metric, null, null, null, metadataConfig, null);
    }

    public IndexModel createPodsIndex(String indexName, Integer dimension, String environment, String podType, String metric, String sourceCollection) {
        return this.createPodsIndex(indexName, dimension, environment, podType, metric, null, null, null, null, sourceCollection);
    }

    public IndexModel createPodsIndex(String indexName, Integer dimension, String environment, String podType, Integer pods) {
        return this.createPodsIndex(indexName, dimension, environment, podType, null, null, null, pods, null, null);
    }

    public IndexModel createPodsIndex(String indexName, Integer dimension, String environment, String podType, Integer pods, CreateIndexRequestSpecPodMetadataConfig metadataConfig) {
        return this.createPodsIndex(indexName, dimension, environment, podType, null, null, null, pods, metadataConfig, null);
    }

    public IndexModel createPodsIndex(String indexName, Integer dimension, String environment, String podType, Integer replicas, Integer shards) {
        return this.createPodsIndex(indexName, dimension, environment, podType, null, replicas, shards, null, null, null);
    }

    public IndexModel createPodsIndex(String indexName, Integer dimension, String environment, String podType, Integer replicas, Integer shards, CreateIndexRequestSpecPodMetadataConfig metadataConfig) {
        return this.createPodsIndex(indexName, dimension, environment, podType, null, replicas, shards, null, metadataConfig, null);
    }

    public IndexModel createPodsIndex(String indexName, Integer dimension, String environment, String podType, String metric, Integer replicas, Integer shards, Integer pods, CreateIndexRequestSpecPodMetadataConfig metadataConfig, String sourceCollection) throws PineconeException {
        Pinecone.validatePodIndexParams(indexName, dimension, environment, podType, metric, replicas, shards, pods);
        CreateIndexRequestSpecPod podSpec = new CreateIndexRequestSpecPod().environment(environment).podType(podType).replicas(replicas).shards(shards).pods(pods).metadataConfig(metadataConfig).sourceCollection(sourceCollection);
        CreateIndexRequestSpec createIndexRequestSpec = new CreateIndexRequestSpec().pod(podSpec);
        CreateIndexRequest createIndexRequest = new CreateIndexRequest().name(indexName).dimension(dimension).metric(metric != null ? IndexMetric.fromValue(metric) : IndexMetric.COSINE).spec(createIndexRequestSpec);
        IndexModel indexModel = null;
        try {
            indexModel = this.manageIndexesApi.createIndex(createIndexRequest);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return indexModel;
    }

    public static void validatePodIndexParams(String indexName, Integer dimension, String environment, String podType, String metric, Integer replicas, Integer shards, Integer pods) {
        if (indexName == null || indexName.isEmpty()) {
            throw new PineconeValidationException("indexName cannot be null or empty");
        }
        if (dimension == null) {
            throw new PineconeValidationException("Dimension cannot be null");
        }
        if (dimension < 1) {
            throw new PineconeValidationException("Dimension must be greater than 0. See limits for more info: https://docs.pinecone.io/reference/limits");
        }
        if (environment == null || environment.isEmpty()) {
            throw new PineconeValidationException("Environment cannot be null or empty");
        }
        if (podType == null || podType.isEmpty()) {
            throw new PineconeValidationException("podType cannot be null or empty");
        }
        if (metric != null && metric.isEmpty()) {
            throw new PineconeValidationException("Metric cannot be null or empty. Must be one of " + Arrays.toString((Object[])IndexMetric.values()));
        }
        if (replicas != null && replicas < 1) {
            throw new PineconeValidationException("Number of replicas must be >= 1");
        }
        if (shards != null && shards < 1) {
            throw new PineconeValidationException("Number of shards must be >= 1");
        }
        if (pods != null && pods < 1) {
            throw new PineconeValidationException("Number of pods must be >= 1");
        }
        if (replicas != null && shards != null && pods != null && replicas * shards != pods) {
            throw new PineconeValidationException("Number of pods does not equal number of shards times number of replicas");
        }
    }

    public IndexModel describeIndex(String indexName) throws PineconeException {
        IndexModel indexModel = null;
        try {
            indexModel = this.manageIndexesApi.describeIndex(indexName);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return indexModel;
    }

    public IndexModel configureIndex(String indexName, String podType, Integer replicas) throws PineconeException {
        if (indexName == null || indexName.isEmpty()) {
            throw new PineconeValidationException("indexName cannot be null or empty");
        }
        if (podType == null && replicas == null) {
            throw new PineconeValidationException("Must provide either podType or replicas");
        }
        if (replicas != null && replicas < 1) {
            throw new PineconeValidationException("Number of replicas must be >= 1");
        }
        ConfigureIndexRequest configureIndexRequest = new ConfigureIndexRequest().spec(new ConfigureIndexRequestSpec().pod(new ConfigureIndexRequestSpecPod().replicas(replicas).podType(podType)));
        IndexModel indexModel = null;
        try {
            indexModel = this.manageIndexesApi.configureIndex(indexName, configureIndexRequest);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return indexModel;
    }

    public IndexModel configureIndex(String indexName, Integer replicas) throws PineconeException {
        return this.configureIndex(indexName, null, replicas);
    }

    public IndexModel configureIndex(String indexName, String podType) throws PineconeException {
        return this.configureIndex(indexName, podType, null);
    }

    public IndexList listIndexes() throws PineconeException {
        IndexList indexList = null;
        try {
            indexList = this.manageIndexesApi.listIndexes();
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return indexList;
    }

    public void deleteIndex(String indexName) throws PineconeException {
        try {
            this.manageIndexesApi.deleteIndex(indexName);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
    }

    public CollectionModel createCollection(String collectionName, String sourceIndex) throws PineconeException {
        if (collectionName == null || collectionName.isEmpty()) {
            throw new PineconeValidationException("collectionName cannot be null or empty");
        }
        if (sourceIndex == null || sourceIndex.isEmpty()) {
            throw new PineconeValidationException("sourceIndex cannot be null or empty");
        }
        CreateCollectionRequest createCollectionRequest = new CreateCollectionRequest().name(collectionName).source(sourceIndex);
        CollectionModel collection = null;
        try {
            collection = this.manageIndexesApi.createCollection(createCollectionRequest);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return collection;
    }

    public CollectionModel describeCollection(String collectionName) throws PineconeException {
        CollectionModel collection = null;
        try {
            collection = this.manageIndexesApi.describeCollection(collectionName);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return collection;
    }

    public CollectionList listCollections() throws PineconeException {
        CollectionList collections = null;
        try {
            collections = this.manageIndexesApi.listCollections();
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return collections;
    }

    public void deleteCollection(String collectionName) throws PineconeException {
        try {
            this.manageIndexesApi.deleteCollection(collectionName);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
    }

    public Index getIndexConnection(String indexName) throws PineconeValidationException {
        if (indexName == null || indexName.isEmpty()) {
            throw new PineconeValidationException("Index name cannot be null or empty");
        }
        this.config.setHost(this.getIndexHost(indexName));
        PineconeConnection connection = this.getConnection(indexName);
        return new Index(connection, indexName);
    }

    public AsyncIndex getAsyncIndexConnection(String indexName) throws PineconeValidationException {
        if (indexName == null || indexName.isEmpty()) {
            throw new PineconeValidationException("Index name cannot be null or empty");
        }
        this.config.setHost(this.getIndexHost(indexName));
        PineconeConnection connection = this.getConnection(indexName);
        return new AsyncIndex(connection, indexName);
    }

    PineconeConnection getConnection(String indexName) {
        return connectionsMap.computeIfAbsent(indexName, key -> new PineconeConnection(this.config));
    }

    ConcurrentHashMap<String, PineconeConnection> getConnectionsMap() {
        return connectionsMap;
    }

    String getIndexHost(String indexName) {
        return this.describeIndex(indexName).getHost();
    }

    static void closeConnection(String indexName) {
        connectionsMap.remove(indexName);
    }

    private void handleApiException(ApiException apiException) throws PineconeException {
        int statusCode = apiException.getCode();
        String responseBody = apiException.getResponseBody();
        FailedRequestInfo failedRequestInfo = new FailedRequestInfo(statusCode, responseBody);
        HttpErrorMapper.mapHttpStatusError(failedRequestInfo, apiException);
    }

    public static class Builder {
        private final String apiKey;
        private String sourceTag;
        private OkHttpClient okHttpClient = new OkHttpClient();

        public Builder(String apiKey) {
            this.apiKey = apiKey;
        }

        public Builder withSourceTag(String sourceTag) {
            this.sourceTag = sourceTag;
            return this;
        }

        public Builder withOkHttpClient(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            return this;
        }

        public Pinecone build() {
            PineconeConfig clientConfig = new PineconeConfig(this.apiKey);
            clientConfig.setSourceTag(this.sourceTag);
            clientConfig.validate();
            ApiClient apiClient = new ApiClient(this.okHttpClient);
            apiClient.setApiKey(clientConfig.getApiKey());
            apiClient.setUserAgent(clientConfig.getUserAgent());
            if (Boolean.parseBoolean(System.getenv("PINECONE_DEBUG"))) {
                apiClient.setDebugging(true);
            }
            ManageIndexesApi manageIndexesApi = new ManageIndexesApi();
            manageIndexesApi.setApiClient(apiClient);
            return new Pinecone(clientConfig, manageIndexesApi);
        }
    }
}

