/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone.configs;

import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.MetadataUtils;
import io.pinecone.configs.PineconeConfig;
import io.pinecone.exceptions.PineconeException;
import io.pinecone.exceptions.PineconeValidationException;
import io.pinecone.proto.VectorServiceGrpc;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PineconeConnection
implements AutoCloseable {
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 64000000;
    private static final Logger logger = LoggerFactory.getLogger(PineconeConnection.class);
    private final PineconeConfig config;
    final ManagedChannel channel;
    private VectorServiceGrpc.VectorServiceBlockingStub blockingStub;
    private VectorServiceGrpc.VectorServiceFutureStub asyncStub;

    public PineconeConnection(PineconeConfig config) {
        this.config = config;
        if (config.getCustomManagedChannel() != null) {
            this.channel = config.getCustomManagedChannel();
        } else {
            if (config.getHost() == null || config.getHost().isEmpty()) {
                throw new PineconeValidationException("Index-name or host is required for data plane operations");
            }
            this.channel = PineconeConnection.buildChannel(config.getHost());
        }
        this.initialize();
    }

    private void initialize() {
        this.channel.notifyWhenStateChanged(this.channel.getState(false), this::onConnectivityStateChanged);
        Metadata metadata = PineconeConnection.assembleMetadata(this.config);
        this.blockingStub = this.generateBlockingStub(metadata);
        this.asyncStub = this.generateAsyncStub(metadata);
        logger.debug("created new PineconeConnection for channel: {}", (Object)this.channel);
    }

    private VectorServiceGrpc.VectorServiceBlockingStub generateBlockingStub(Metadata metadata) {
        return (VectorServiceGrpc.VectorServiceBlockingStub)((VectorServiceGrpc.VectorServiceBlockingStub)((VectorServiceGrpc.VectorServiceBlockingStub)VectorServiceGrpc.newBlockingStub((Channel)this.channel).withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withMaxInboundMessageSize(64000000)).withMaxOutboundMessageSize(64000000);
    }

    private VectorServiceGrpc.VectorServiceFutureStub generateAsyncStub(Metadata metadata) {
        return (VectorServiceGrpc.VectorServiceFutureStub)((VectorServiceGrpc.VectorServiceFutureStub)((VectorServiceGrpc.VectorServiceFutureStub)VectorServiceGrpc.newFutureStub((Channel)this.channel).withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withMaxInboundMessageSize(64000000)).withMaxOutboundMessageSize(64000000);
    }

    @Override
    public void close() {
        try {
            logger.debug("closing channel");
            this.channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("Channel shutdown interrupted before termination confirmed");
        }
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    public VectorServiceGrpc.VectorServiceBlockingStub getBlockingStub() {
        return this.blockingStub;
    }

    public VectorServiceGrpc.VectorServiceFutureStub getAsyncStub() {
        return this.asyncStub;
    }

    private void onConnectivityStateChanged() {
        logger.debug("channel connectivity state changed to {} for {}", (Object)this.channel.getState(false), (Object)this.channel);
    }

    public static ManagedChannel buildChannel(String host) {
        String endpoint = PineconeConnection.formatEndpoint(host);
        NettyChannelBuilder builder = NettyChannelBuilder.forTarget((String)endpoint);
        try {
            builder = ((NettyChannelBuilder)builder.overrideAuthority(endpoint)).negotiationType(NegotiationType.TLS).sslContext(GrpcSslContexts.forClient().build());
        }
        catch (SSLException e) {
            throw new PineconeException("SSL error opening gRPC channel", e);
        }
        return builder.build();
    }

    private static Metadata assembleMetadata(PineconeConfig config) {
        Metadata metadata = new Metadata();
        metadata.put(Metadata.Key.of((String)"api-key", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)config.getApiKey());
        metadata.put(Metadata.Key.of((String)"User-Agent", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)config.getUserAgentGrpc());
        return metadata;
    }

    public static String formatEndpoint(String host) {
        if (host != null && !host.isEmpty()) {
            return host.replaceFirst("https?://", "");
        }
        throw new PineconeValidationException("Index host cannot be null or empty");
    }
}

