/*
 * Pinecone Control Plane API
 * Pinecone is a vector database that makes it easy to search and retrieve billions of high-dimensional vectors.
 *
 * The version of the OpenAPI document: 2024-07
 * Contact: support@pinecone.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.control.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import org.openapitools.control.client.model.PodSpec;
import org.openapitools.control.client.model.ServerlessSpec;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.openapitools.control.client.JSON;

/**
 * The spec object defines how the index should be deployed.  For serverless indexes, you define only the [cloud and region](http://docs.pinecone.io/guides/indexes/understanding-indexes#cloud-regions) where the index should be hosted. For pod-based indexes, you define the [environment](http://docs.pinecone.io/guides/indexes/understanding-indexes#pod-environments) where the index should be hosted, the [pod type and size](http://docs.pinecone.io/guides/indexes/understanding-indexes#pod-types) to use, and other index characteristics. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-07-18T20:37:01.807093Z[Etc/UTC]")
public class IndexSpec {
  public static final String SERIALIZED_NAME_SERVERLESS = "serverless";
  @SerializedName(SERIALIZED_NAME_SERVERLESS)
  private ServerlessSpec serverless;

  public static final String SERIALIZED_NAME_POD = "pod";
  @SerializedName(SERIALIZED_NAME_POD)
  private PodSpec pod;

  public IndexSpec() {
  }

  public IndexSpec serverless(ServerlessSpec serverless) {
    
    this.serverless = serverless;
    return this;
  }

   /**
   * Get serverless
   * @return serverless
  **/
  @javax.annotation.Nullable
  public ServerlessSpec getServerless() {
    return serverless;
  }


  public void setServerless(ServerlessSpec serverless) {
    this.serverless = serverless;
  }


  public IndexSpec pod(PodSpec pod) {
    
    this.pod = pod;
    return this;
  }

   /**
   * Get pod
   * @return pod
  **/
  @javax.annotation.Nullable
  public PodSpec getPod() {
    return pod;
  }


  public void setPod(PodSpec pod) {
    this.pod = pod;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IndexSpec indexSpec = (IndexSpec) o;
    return Objects.equals(this.serverless, indexSpec.serverless) &&
        Objects.equals(this.pod, indexSpec.pod);
  }

  @Override
  public int hashCode() {
    return Objects.hash(serverless, pod);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IndexSpec {\n");
    sb.append("    serverless: ").append(toIndentedString(serverless)).append("\n");
    sb.append("    pod: ").append(toIndentedString(pod)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Element and throws an exception if issues found
  *
  * @param jsonElement JSON Element
  * @throws IOException if the JSON Element is invalid with respect to IndexSpec
  */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!IndexSpec.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in IndexSpec is not found in the empty JSON string", IndexSpec.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!IndexSpec.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `IndexSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // validate the optional field `serverless`
      if (jsonObj.get("serverless") != null && !jsonObj.get("serverless").isJsonNull()) {
        ServerlessSpec.validateJsonElement(jsonObj.get("serverless"));
      }
      // validate the optional field `pod`
      if (jsonObj.get("pod") != null && !jsonObj.get("pod").isJsonNull()) {
        PodSpec.validateJsonElement(jsonObj.get("pod"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!IndexSpec.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'IndexSpec' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<IndexSpec> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(IndexSpec.class));

       return (TypeAdapter<T>) new TypeAdapter<IndexSpec>() {
           @Override
           public void write(JsonWriter out, IndexSpec value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public IndexSpec read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of IndexSpec given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of IndexSpec
  * @throws IOException if the JSON string is invalid with respect to IndexSpec
  */
  public static IndexSpec fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, IndexSpec.class);
  }

 /**
  * Convert an instance of IndexSpec to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

