/*
 * Pinecone Data Plane API
 * Pinecone is a vector database that makes it easy to search and retrieve billions of high-dimensional vectors.
 *
 * The version of the OpenAPI document: 2024-10
 * Contact: support@pinecone.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.db_data.client.api;

import org.openapitools.db_data.client.ApiCallback;
import org.openapitools.db_data.client.ApiClient;
import org.openapitools.db_data.client.ApiException;
import org.openapitools.db_data.client.ApiResponse;
import org.openapitools.db_data.client.Configuration;
import org.openapitools.db_data.client.Pair;
import org.openapitools.db_data.client.ProgressRequestBody;
import org.openapitools.db_data.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.openapitools.db_data.client.model.DeleteRequest;
import org.openapitools.db_data.client.model.DescribeIndexStatsRequest;
import org.openapitools.db_data.client.model.FetchResponse;
import org.openapitools.db_data.client.model.IndexDescription;
import org.openapitools.db_data.client.model.ListResponse;
import org.openapitools.db_data.client.model.QueryRequest;
import org.openapitools.db_data.client.model.QueryResponse;
import org.openapitools.db_data.client.model.RpcStatus;
import org.openapitools.db_data.client.model.UpdateRequest;
import org.openapitools.db_data.client.model.UpsertRequest;
import org.openapitools.db_data.client.model.UpsertResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VectorOperationsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public VectorOperationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VectorOperationsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for deleteVectors
     * @param deleteRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteVectorsCall(DeleteRequest deleteRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = deleteRequest;

        // create path and map variables
        String localVarPath = "/vectors/delete";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteVectorsValidateBeforeCall(DeleteRequest deleteRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'deleteRequest' is set
        if (deleteRequest == null) {
            throw new ApiException("Missing the required parameter 'deleteRequest' when calling deleteVectors(Async)");
        }

        return deleteVectorsCall(deleteRequest, _callback);

    }

    /**
     * Delete vectors
     * The &#x60;delete&#x60; operation deletes vectors, by id, from a single namespace.  For guidance and examples, see [Delete data](https://docs.pinecone.io/guides/data/delete-data).
     * @param deleteRequest  (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public Object deleteVectors(DeleteRequest deleteRequest) throws ApiException {
        ApiResponse<Object> localVarResp = deleteVectorsWithHttpInfo(deleteRequest);
        return localVarResp.getData();
    }

    /**
     * Delete vectors
     * The &#x60;delete&#x60; operation deletes vectors, by id, from a single namespace.  For guidance and examples, see [Delete data](https://docs.pinecone.io/guides/data/delete-data).
     * @param deleteRequest  (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> deleteVectorsWithHttpInfo(DeleteRequest deleteRequest) throws ApiException {
        okhttp3.Call localVarCall = deleteVectorsValidateBeforeCall(deleteRequest, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Delete vectors (asynchronously)
     * The &#x60;delete&#x60; operation deletes vectors, by id, from a single namespace.  For guidance and examples, see [Delete data](https://docs.pinecone.io/guides/data/delete-data).
     * @param deleteRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteVectorsAsync(DeleteRequest deleteRequest, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteVectorsValidateBeforeCall(deleteRequest, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for describeIndexStats
     * @param describeIndexStatsRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call describeIndexStatsCall(DescribeIndexStatsRequest describeIndexStatsRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = describeIndexStatsRequest;

        // create path and map variables
        String localVarPath = "/describe_index_stats";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call describeIndexStatsValidateBeforeCall(DescribeIndexStatsRequest describeIndexStatsRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'describeIndexStatsRequest' is set
        if (describeIndexStatsRequest == null) {
            throw new ApiException("Missing the required parameter 'describeIndexStatsRequest' when calling describeIndexStats(Async)");
        }

        return describeIndexStatsCall(describeIndexStatsRequest, _callback);

    }

    /**
     * Get index stats
     * The &#x60;describe_index_stats&#x60; operation returns statistics about the contents of an index, including the vector count per namespace, the number of dimensions, and the index fullness.  Serverless indexes scale automatically as needed, so index fullness is relevant only for pod-based indexes.  For pod-based indexes, the index fullness result may be inaccurate during pod resizing; to get the status of a pod resizing process, use [&#x60;describe_index&#x60;](https://docs.pinecone.io/reference/api/control-plane/describe_index).
     * @param describeIndexStatsRequest  (required)
     * @return IndexDescription
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public IndexDescription describeIndexStats(DescribeIndexStatsRequest describeIndexStatsRequest) throws ApiException {
        ApiResponse<IndexDescription> localVarResp = describeIndexStatsWithHttpInfo(describeIndexStatsRequest);
        return localVarResp.getData();
    }

    /**
     * Get index stats
     * The &#x60;describe_index_stats&#x60; operation returns statistics about the contents of an index, including the vector count per namespace, the number of dimensions, and the index fullness.  Serverless indexes scale automatically as needed, so index fullness is relevant only for pod-based indexes.  For pod-based indexes, the index fullness result may be inaccurate during pod resizing; to get the status of a pod resizing process, use [&#x60;describe_index&#x60;](https://docs.pinecone.io/reference/api/control-plane/describe_index).
     * @param describeIndexStatsRequest  (required)
     * @return ApiResponse&lt;IndexDescription&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<IndexDescription> describeIndexStatsWithHttpInfo(DescribeIndexStatsRequest describeIndexStatsRequest) throws ApiException {
        okhttp3.Call localVarCall = describeIndexStatsValidateBeforeCall(describeIndexStatsRequest, null);
        Type localVarReturnType = new TypeToken<IndexDescription>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get index stats (asynchronously)
     * The &#x60;describe_index_stats&#x60; operation returns statistics about the contents of an index, including the vector count per namespace, the number of dimensions, and the index fullness.  Serverless indexes scale automatically as needed, so index fullness is relevant only for pod-based indexes.  For pod-based indexes, the index fullness result may be inaccurate during pod resizing; to get the status of a pod resizing process, use [&#x60;describe_index&#x60;](https://docs.pinecone.io/reference/api/control-plane/describe_index).
     * @param describeIndexStatsRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call describeIndexStatsAsync(DescribeIndexStatsRequest describeIndexStatsRequest, final ApiCallback<IndexDescription> _callback) throws ApiException {

        okhttp3.Call localVarCall = describeIndexStatsValidateBeforeCall(describeIndexStatsRequest, _callback);
        Type localVarReturnType = new TypeToken<IndexDescription>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for fetchVectors
     * @param ids The vector IDs to fetch. Does not accept values containing spaces. (required)
     * @param namespace  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call fetchVectorsCall(List<String> ids, String namespace, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/vectors/fetch";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (ids != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "ids", ids));
        }

        if (namespace != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("namespace", namespace));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call fetchVectorsValidateBeforeCall(List<String> ids, String namespace, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'ids' is set
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling fetchVectors(Async)");
        }

        return fetchVectorsCall(ids, namespace, _callback);

    }

    /**
     * Fetch vectors
     * The &#x60;fetch&#x60; operation looks up and returns vectors, by ID, from a single namespace. The returned vectors include the vector data and/or metadata.  For guidance and examples, see [Fetch data](https://docs.pinecone.io/guides/data/fetch-data).
     * @param ids The vector IDs to fetch. Does not accept values containing spaces. (required)
     * @param namespace  (optional)
     * @return FetchResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public FetchResponse fetchVectors(List<String> ids, String namespace) throws ApiException {
        ApiResponse<FetchResponse> localVarResp = fetchVectorsWithHttpInfo(ids, namespace);
        return localVarResp.getData();
    }

    /**
     * Fetch vectors
     * The &#x60;fetch&#x60; operation looks up and returns vectors, by ID, from a single namespace. The returned vectors include the vector data and/or metadata.  For guidance and examples, see [Fetch data](https://docs.pinecone.io/guides/data/fetch-data).
     * @param ids The vector IDs to fetch. Does not accept values containing spaces. (required)
     * @param namespace  (optional)
     * @return ApiResponse&lt;FetchResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FetchResponse> fetchVectorsWithHttpInfo(List<String> ids, String namespace) throws ApiException {
        okhttp3.Call localVarCall = fetchVectorsValidateBeforeCall(ids, namespace, null);
        Type localVarReturnType = new TypeToken<FetchResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Fetch vectors (asynchronously)
     * The &#x60;fetch&#x60; operation looks up and returns vectors, by ID, from a single namespace. The returned vectors include the vector data and/or metadata.  For guidance and examples, see [Fetch data](https://docs.pinecone.io/guides/data/fetch-data).
     * @param ids The vector IDs to fetch. Does not accept values containing spaces. (required)
     * @param namespace  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call fetchVectorsAsync(List<String> ids, String namespace, final ApiCallback<FetchResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = fetchVectorsValidateBeforeCall(ids, namespace, _callback);
        Type localVarReturnType = new TypeToken<FetchResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listVectors
     * @param prefix The vector IDs to fetch. Does not accept values containing spaces. (optional)
     * @param limit Max number of IDs to return per page. (optional)
     * @param paginationToken Pagination token to continue a previous listing operation. (optional)
     * @param namespace  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listVectorsCall(String prefix, Long limit, String paginationToken, String namespace, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/vectors/list";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (prefix != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("prefix", prefix));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("paginationToken", paginationToken));
        }

        if (namespace != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("namespace", namespace));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listVectorsValidateBeforeCall(String prefix, Long limit, String paginationToken, String namespace, final ApiCallback _callback) throws ApiException {
        return listVectorsCall(prefix, limit, paginationToken, namespace, _callback);

    }

    /**
     * List vector IDs
     * The &#x60;list&#x60; operation lists the IDs of vectors in a single namespace of a serverless index. An optional prefix can be passed to limit the results to IDs with a common prefix.  &#x60;list&#x60; returns up to 100 IDs at a time by default in sorted order (bitwise \&quot;C\&quot; collation). If the &#x60;limit&#x60; parameter is set, &#x60;list&#x60; returns up to that number of IDs instead. Whenever there are additional IDs to return, the response also includes a &#x60;pagination_token&#x60; that you can use to get the next batch of IDs. When the response does not include a &#x60;pagination_token&#x60;, there are no more IDs to return.  For guidance and examples, see [List record IDs](https://docs.pinecone.io/guides/data/list-record-ids).  **Note:** &#x60;list_vectors&#x60; is supported only for serverless indexes.
     * @param prefix The vector IDs to fetch. Does not accept values containing spaces. (optional)
     * @param limit Max number of IDs to return per page. (optional)
     * @param paginationToken Pagination token to continue a previous listing operation. (optional)
     * @param namespace  (optional)
     * @return ListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public ListResponse listVectors(String prefix, Long limit, String paginationToken, String namespace) throws ApiException {
        ApiResponse<ListResponse> localVarResp = listVectorsWithHttpInfo(prefix, limit, paginationToken, namespace);
        return localVarResp.getData();
    }

    /**
     * List vector IDs
     * The &#x60;list&#x60; operation lists the IDs of vectors in a single namespace of a serverless index. An optional prefix can be passed to limit the results to IDs with a common prefix.  &#x60;list&#x60; returns up to 100 IDs at a time by default in sorted order (bitwise \&quot;C\&quot; collation). If the &#x60;limit&#x60; parameter is set, &#x60;list&#x60; returns up to that number of IDs instead. Whenever there are additional IDs to return, the response also includes a &#x60;pagination_token&#x60; that you can use to get the next batch of IDs. When the response does not include a &#x60;pagination_token&#x60;, there are no more IDs to return.  For guidance and examples, see [List record IDs](https://docs.pinecone.io/guides/data/list-record-ids).  **Note:** &#x60;list_vectors&#x60; is supported only for serverless indexes.
     * @param prefix The vector IDs to fetch. Does not accept values containing spaces. (optional)
     * @param limit Max number of IDs to return per page. (optional)
     * @param paginationToken Pagination token to continue a previous listing operation. (optional)
     * @param namespace  (optional)
     * @return ApiResponse&lt;ListResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListResponse> listVectorsWithHttpInfo(String prefix, Long limit, String paginationToken, String namespace) throws ApiException {
        okhttp3.Call localVarCall = listVectorsValidateBeforeCall(prefix, limit, paginationToken, namespace, null);
        Type localVarReturnType = new TypeToken<ListResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List vector IDs (asynchronously)
     * The &#x60;list&#x60; operation lists the IDs of vectors in a single namespace of a serverless index. An optional prefix can be passed to limit the results to IDs with a common prefix.  &#x60;list&#x60; returns up to 100 IDs at a time by default in sorted order (bitwise \&quot;C\&quot; collation). If the &#x60;limit&#x60; parameter is set, &#x60;list&#x60; returns up to that number of IDs instead. Whenever there are additional IDs to return, the response also includes a &#x60;pagination_token&#x60; that you can use to get the next batch of IDs. When the response does not include a &#x60;pagination_token&#x60;, there are no more IDs to return.  For guidance and examples, see [List record IDs](https://docs.pinecone.io/guides/data/list-record-ids).  **Note:** &#x60;list_vectors&#x60; is supported only for serverless indexes.
     * @param prefix The vector IDs to fetch. Does not accept values containing spaces. (optional)
     * @param limit Max number of IDs to return per page. (optional)
     * @param paginationToken Pagination token to continue a previous listing operation. (optional)
     * @param namespace  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listVectorsAsync(String prefix, Long limit, String paginationToken, String namespace, final ApiCallback<ListResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listVectorsValidateBeforeCall(prefix, limit, paginationToken, namespace, _callback);
        Type localVarReturnType = new TypeToken<ListResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryVectors
     * @param queryRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryVectorsCall(QueryRequest queryRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = queryRequest;

        // create path and map variables
        String localVarPath = "/query";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryVectorsValidateBeforeCall(QueryRequest queryRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'queryRequest' is set
        if (queryRequest == null) {
            throw new ApiException("Missing the required parameter 'queryRequest' when calling queryVectors(Async)");
        }

        return queryVectorsCall(queryRequest, _callback);

    }

    /**
     * Query vectors
     * The &#x60;query&#x60; operation searches a namespace, using a query vector. It retrieves the ids of the most similar items in a namespace, along with their similarity scores.  For guidance and examples, see [Query data](https://docs.pinecone.io/guides/data/query-data).
     * @param queryRequest  (required)
     * @return QueryResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public QueryResponse queryVectors(QueryRequest queryRequest) throws ApiException {
        ApiResponse<QueryResponse> localVarResp = queryVectorsWithHttpInfo(queryRequest);
        return localVarResp.getData();
    }

    /**
     * Query vectors
     * The &#x60;query&#x60; operation searches a namespace, using a query vector. It retrieves the ids of the most similar items in a namespace, along with their similarity scores.  For guidance and examples, see [Query data](https://docs.pinecone.io/guides/data/query-data).
     * @param queryRequest  (required)
     * @return ApiResponse&lt;QueryResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<QueryResponse> queryVectorsWithHttpInfo(QueryRequest queryRequest) throws ApiException {
        okhttp3.Call localVarCall = queryVectorsValidateBeforeCall(queryRequest, null);
        Type localVarReturnType = new TypeToken<QueryResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Query vectors (asynchronously)
     * The &#x60;query&#x60; operation searches a namespace, using a query vector. It retrieves the ids of the most similar items in a namespace, along with their similarity scores.  For guidance and examples, see [Query data](https://docs.pinecone.io/guides/data/query-data).
     * @param queryRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryVectorsAsync(QueryRequest queryRequest, final ApiCallback<QueryResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryVectorsValidateBeforeCall(queryRequest, _callback);
        Type localVarReturnType = new TypeToken<QueryResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateVector
     * @param updateRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateVectorCall(UpdateRequest updateRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = updateRequest;

        // create path and map variables
        String localVarPath = "/vectors/update";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateVectorValidateBeforeCall(UpdateRequest updateRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'updateRequest' is set
        if (updateRequest == null) {
            throw new ApiException("Missing the required parameter 'updateRequest' when calling updateVector(Async)");
        }

        return updateVectorCall(updateRequest, _callback);

    }

    /**
     * Update a vector
     * The &#x60;update&#x60; operation updates a vector in a namespace. If a value is included, it will overwrite the previous value. If a &#x60;set_metadata&#x60; is included, the values of the fields specified in it will be added or overwrite the previous value.  For guidance and examples, see [Update data](https://docs.pinecone.io/guides/data/update-data).
     * @param updateRequest  (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public Object updateVector(UpdateRequest updateRequest) throws ApiException {
        ApiResponse<Object> localVarResp = updateVectorWithHttpInfo(updateRequest);
        return localVarResp.getData();
    }

    /**
     * Update a vector
     * The &#x60;update&#x60; operation updates a vector in a namespace. If a value is included, it will overwrite the previous value. If a &#x60;set_metadata&#x60; is included, the values of the fields specified in it will be added or overwrite the previous value.  For guidance and examples, see [Update data](https://docs.pinecone.io/guides/data/update-data).
     * @param updateRequest  (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> updateVectorWithHttpInfo(UpdateRequest updateRequest) throws ApiException {
        okhttp3.Call localVarCall = updateVectorValidateBeforeCall(updateRequest, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update a vector (asynchronously)
     * The &#x60;update&#x60; operation updates a vector in a namespace. If a value is included, it will overwrite the previous value. If a &#x60;set_metadata&#x60; is included, the values of the fields specified in it will be added or overwrite the previous value.  For guidance and examples, see [Update data](https://docs.pinecone.io/guides/data/update-data).
     * @param updateRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateVectorAsync(UpdateRequest updateRequest, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateVectorValidateBeforeCall(updateRequest, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for upsertVectors
     * @param upsertRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call upsertVectorsCall(UpsertRequest upsertRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = upsertRequest;

        // create path and map variables
        String localVarPath = "/vectors/upsert";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call upsertVectorsValidateBeforeCall(UpsertRequest upsertRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'upsertRequest' is set
        if (upsertRequest == null) {
            throw new ApiException("Missing the required parameter 'upsertRequest' when calling upsertVectors(Async)");
        }

        return upsertVectorsCall(upsertRequest, _callback);

    }

    /**
     * Upsert vectors
     * The &#x60;upsert&#x60; operation writes vectors into a namespace. If a new value is upserted for an existing vector ID, it will overwrite the previous value.  For guidance and examples, see [Upsert data](https://docs.pinecone.io/guides/data/upsert-data).
     * @param upsertRequest  (required)
     * @return UpsertResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public UpsertResponse upsertVectors(UpsertRequest upsertRequest) throws ApiException {
        ApiResponse<UpsertResponse> localVarResp = upsertVectorsWithHttpInfo(upsertRequest);
        return localVarResp.getData();
    }

    /**
     * Upsert vectors
     * The &#x60;upsert&#x60; operation writes vectors into a namespace. If a new value is upserted for an existing vector ID, it will overwrite the previous value.  For guidance and examples, see [Upsert data](https://docs.pinecone.io/guides/data/upsert-data).
     * @param upsertRequest  (required)
     * @return ApiResponse&lt;UpsertResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UpsertResponse> upsertVectorsWithHttpInfo(UpsertRequest upsertRequest) throws ApiException {
        okhttp3.Call localVarCall = upsertVectorsValidateBeforeCall(upsertRequest, null);
        Type localVarReturnType = new TypeToken<UpsertResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Upsert vectors (asynchronously)
     * The &#x60;upsert&#x60; operation writes vectors into a namespace. If a new value is upserted for an existing vector ID, it will overwrite the previous value.  For guidance and examples, see [Upsert data](https://docs.pinecone.io/guides/data/upsert-data).
     * @param upsertRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 4XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
        <tr><td> 5XX </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call upsertVectorsAsync(UpsertRequest upsertRequest, final ApiCallback<UpsertResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = upsertVectorsValidateBeforeCall(upsertRequest, _callback);
        Type localVarReturnType = new TypeToken<UpsertResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
