/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone.configs;

import io.grpc.ManagedChannel;
import io.pinecone.configs.ProxyConfig;
import io.pinecone.exceptions.PineconeConfigurationException;
import okhttp3.OkHttpClient;

public class PineconeConfig {
    private String apiKey;
    private String host;
    private String sourceTag;
    private ProxyConfig proxyConfig;
    private OkHttpClient customOkHttpClient;
    private ManagedChannel customManagedChannel;
    private boolean enableTLS = true;

    public PineconeConfig(String apiKey) {
        this(apiKey, null);
    }

    public PineconeConfig(String apiKey, String sourceTag) {
        this(apiKey, sourceTag, null, null);
    }

    public PineconeConfig(String apiKey, String sourceTag, ProxyConfig proxyConfig, OkHttpClient customOkHttpClient) {
        this.apiKey = apiKey;
        this.sourceTag = sourceTag;
        this.proxyConfig = proxyConfig;
        this.customOkHttpClient = customOkHttpClient;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getSourceTag() {
        return this.sourceTag;
    }

    public void setSourceTag(String sourceTag) {
        this.sourceTag = this.normalizeSourceTag(sourceTag);
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public ManagedChannel getCustomManagedChannel() {
        return this.customManagedChannel;
    }

    public OkHttpClient getCustomOkHttpClient() {
        return this.customOkHttpClient;
    }

    public void setCustomOkHttpClient(OkHttpClient customOkHttpClient) {
        this.customOkHttpClient = customOkHttpClient;
    }

    public void setCustomManagedChannel(ManagedChannel customManagedChannel) {
        this.customManagedChannel = customManagedChannel;
    }

    public void validate() {
        if (this.apiKey == null || this.apiKey.isEmpty()) {
            throw new PineconeConfigurationException("The API key is required and must not be empty or null");
        }
        if (this.proxyConfig != null) {
            this.proxyConfig.validate();
        }
    }

    public String getUserAgent() {
        return this.buildUserAgent();
    }

    public boolean isTLSEnabled() {
        return this.enableTLS;
    }

    public void setTLSEnabled(boolean enableTLS) {
        this.enableTLS = enableTLS;
    }

    private String buildUserAgent() {
        String userAgent = String.format("lang=java; %s=%s", "pineconeClientVersion", "v3.0.0");
        if (this.getSourceTag() != null && !this.getSourceTag().isEmpty()) {
            userAgent = userAgent + "; source_tag=" + this.getSourceTag();
        }
        return userAgent;
    }

    private String normalizeSourceTag(String input) {
        if (input == null) {
            return null;
        }
        return input.toLowerCase().replaceAll("[^a-z0-9_: ]", "").trim().replaceAll("\\s+", "_");
    }

    public static interface CustomChannelBuilder {
        public ManagedChannel buildChannel();
    }
}

