/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone.utils;

import io.pinecone.exceptions.PineconeValidationException;
import java.util.ArrayList;
import java.util.List;

public class SparseIndicesConverter {
    public static List<Integer> convertUnsigned32IntToSigned32Int(List<Long> unsigned32IntValues) {
        ArrayList<Integer> int32Values = new ArrayList<Integer>();
        for (Long value : unsigned32IntValues) {
            if (value < 0L || value > 0xFFFFFFFFL) {
                throw new PineconeValidationException("Sparse indices are out of range for unsigned 32-bit integers.");
            }
            int32Values.add(value.intValue());
        }
        return int32Values;
    }

    public static List<Long> convertSigned32IntToUnsigned32Int(List<Integer> signed32IntValues) {
        ArrayList<Long> uint32Values = new ArrayList<Long>();
        for (Integer value : signed32IntValues) {
            if (value < 0) {
                uint32Values.add((long)value.intValue() + 0x100000000L);
                continue;
            }
            uint32Values.add((long)value);
        }
        return uint32Values;
    }
}

