/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.db_control.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.db_control.client.ApiCallback;
import org.openapitools.db_control.client.ApiClient;
import org.openapitools.db_control.client.ApiException;
import org.openapitools.db_control.client.ApiResponse;
import org.openapitools.db_control.client.Configuration;
import org.openapitools.db_control.client.Pair;
import org.openapitools.db_control.client.model.BackupList;
import org.openapitools.db_control.client.model.BackupModel;
import org.openapitools.db_control.client.model.CollectionList;
import org.openapitools.db_control.client.model.CollectionModel;
import org.openapitools.db_control.client.model.ConfigureIndexRequest;
import org.openapitools.db_control.client.model.CreateBackupRequest;
import org.openapitools.db_control.client.model.CreateCollectionRequest;
import org.openapitools.db_control.client.model.CreateIndexForModelRequest;
import org.openapitools.db_control.client.model.CreateIndexFromBackupRequest;
import org.openapitools.db_control.client.model.CreateIndexFromBackupResponse;
import org.openapitools.db_control.client.model.CreateIndexRequest;
import org.openapitools.db_control.client.model.IndexList;
import org.openapitools.db_control.client.model.IndexModel;
import org.openapitools.db_control.client.model.RestoreJobList;
import org.openapitools.db_control.client.model.RestoreJobModel;

public class ManageIndexesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ManageIndexesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ManageIndexesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call configureIndexCall(String indexName, ConfigureIndexRequest configureIndexRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ConfigureIndexRequest localVarPostBody = configureIndexRequest;
        String localVarPath = "/indexes/{index_name}".replace("{index_name}", this.localVarApiClient.escapeString(indexName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call configureIndexValidateBeforeCall(String indexName, ConfigureIndexRequest configureIndexRequest, ApiCallback _callback) throws ApiException {
        if (indexName == null) {
            throw new ApiException("Missing the required parameter 'indexName' when calling configureIndex(Async)");
        }
        if (configureIndexRequest == null) {
            throw new ApiException("Missing the required parameter 'configureIndexRequest' when calling configureIndex(Async)");
        }
        return this.configureIndexCall(indexName, configureIndexRequest, _callback);
    }

    public IndexModel configureIndex(String indexName, ConfigureIndexRequest configureIndexRequest) throws ApiException {
        ApiResponse<IndexModel> localVarResp = this.configureIndexWithHttpInfo(indexName, configureIndexRequest);
        return localVarResp.getData();
    }

    public ApiResponse<IndexModel> configureIndexWithHttpInfo(String indexName, ConfigureIndexRequest configureIndexRequest) throws ApiException {
        Call localVarCall = this.configureIndexValidateBeforeCall(indexName, configureIndexRequest, null);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call configureIndexAsync(String indexName, ConfigureIndexRequest configureIndexRequest, ApiCallback<IndexModel> _callback) throws ApiException {
        Call localVarCall = this.configureIndexValidateBeforeCall(indexName, configureIndexRequest, _callback);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createBackupCall(String indexName, CreateBackupRequest createBackupRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateBackupRequest localVarPostBody = createBackupRequest;
        String localVarPath = "/indexes/{index_name}/backups".replace("{index_name}", this.localVarApiClient.escapeString(indexName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBackupValidateBeforeCall(String indexName, CreateBackupRequest createBackupRequest, ApiCallback _callback) throws ApiException {
        if (indexName == null) {
            throw new ApiException("Missing the required parameter 'indexName' when calling createBackup(Async)");
        }
        if (createBackupRequest == null) {
            throw new ApiException("Missing the required parameter 'createBackupRequest' when calling createBackup(Async)");
        }
        return this.createBackupCall(indexName, createBackupRequest, _callback);
    }

    public BackupModel createBackup(String indexName, CreateBackupRequest createBackupRequest) throws ApiException {
        ApiResponse<BackupModel> localVarResp = this.createBackupWithHttpInfo(indexName, createBackupRequest);
        return localVarResp.getData();
    }

    public ApiResponse<BackupModel> createBackupWithHttpInfo(String indexName, CreateBackupRequest createBackupRequest) throws ApiException {
        Call localVarCall = this.createBackupValidateBeforeCall(indexName, createBackupRequest, null);
        Type localVarReturnType = new TypeToken<BackupModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createBackupAsync(String indexName, CreateBackupRequest createBackupRequest, ApiCallback<BackupModel> _callback) throws ApiException {
        Call localVarCall = this.createBackupValidateBeforeCall(indexName, createBackupRequest, _callback);
        Type localVarReturnType = new TypeToken<BackupModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createCollectionCall(CreateCollectionRequest createCollectionRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateCollectionRequest localVarPostBody = createCollectionRequest;
        String localVarPath = "/collections";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCollectionValidateBeforeCall(CreateCollectionRequest createCollectionRequest, ApiCallback _callback) throws ApiException {
        if (createCollectionRequest == null) {
            throw new ApiException("Missing the required parameter 'createCollectionRequest' when calling createCollection(Async)");
        }
        return this.createCollectionCall(createCollectionRequest, _callback);
    }

    public CollectionModel createCollection(CreateCollectionRequest createCollectionRequest) throws ApiException {
        ApiResponse<CollectionModel> localVarResp = this.createCollectionWithHttpInfo(createCollectionRequest);
        return localVarResp.getData();
    }

    public ApiResponse<CollectionModel> createCollectionWithHttpInfo(CreateCollectionRequest createCollectionRequest) throws ApiException {
        Call localVarCall = this.createCollectionValidateBeforeCall(createCollectionRequest, null);
        Type localVarReturnType = new TypeToken<CollectionModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createCollectionAsync(CreateCollectionRequest createCollectionRequest, ApiCallback<CollectionModel> _callback) throws ApiException {
        Call localVarCall = this.createCollectionValidateBeforeCall(createCollectionRequest, _callback);
        Type localVarReturnType = new TypeToken<CollectionModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createIndexCall(CreateIndexRequest createIndexRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateIndexRequest localVarPostBody = createIndexRequest;
        String localVarPath = "/indexes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createIndexValidateBeforeCall(CreateIndexRequest createIndexRequest, ApiCallback _callback) throws ApiException {
        if (createIndexRequest == null) {
            throw new ApiException("Missing the required parameter 'createIndexRequest' when calling createIndex(Async)");
        }
        return this.createIndexCall(createIndexRequest, _callback);
    }

    public IndexModel createIndex(CreateIndexRequest createIndexRequest) throws ApiException {
        ApiResponse<IndexModel> localVarResp = this.createIndexWithHttpInfo(createIndexRequest);
        return localVarResp.getData();
    }

    public ApiResponse<IndexModel> createIndexWithHttpInfo(CreateIndexRequest createIndexRequest) throws ApiException {
        Call localVarCall = this.createIndexValidateBeforeCall(createIndexRequest, null);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createIndexAsync(CreateIndexRequest createIndexRequest, ApiCallback<IndexModel> _callback) throws ApiException {
        Call localVarCall = this.createIndexValidateBeforeCall(createIndexRequest, _callback);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createIndexForModelCall(CreateIndexForModelRequest createIndexForModelRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateIndexForModelRequest localVarPostBody = createIndexForModelRequest;
        String localVarPath = "/indexes/create-for-model";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createIndexForModelValidateBeforeCall(CreateIndexForModelRequest createIndexForModelRequest, ApiCallback _callback) throws ApiException {
        if (createIndexForModelRequest == null) {
            throw new ApiException("Missing the required parameter 'createIndexForModelRequest' when calling createIndexForModel(Async)");
        }
        return this.createIndexForModelCall(createIndexForModelRequest, _callback);
    }

    public IndexModel createIndexForModel(CreateIndexForModelRequest createIndexForModelRequest) throws ApiException {
        ApiResponse<IndexModel> localVarResp = this.createIndexForModelWithHttpInfo(createIndexForModelRequest);
        return localVarResp.getData();
    }

    public ApiResponse<IndexModel> createIndexForModelWithHttpInfo(CreateIndexForModelRequest createIndexForModelRequest) throws ApiException {
        Call localVarCall = this.createIndexForModelValidateBeforeCall(createIndexForModelRequest, null);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createIndexForModelAsync(CreateIndexForModelRequest createIndexForModelRequest, ApiCallback<IndexModel> _callback) throws ApiException {
        Call localVarCall = this.createIndexForModelValidateBeforeCall(createIndexForModelRequest, _callback);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createIndexFromBackupOperationCall(String backupId, CreateIndexFromBackupRequest createIndexFromBackupRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateIndexFromBackupRequest localVarPostBody = createIndexFromBackupRequest;
        String localVarPath = "/backups/{backup_id}/create-index".replace("{backup_id}", this.localVarApiClient.escapeString(backupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createIndexFromBackupOperationValidateBeforeCall(String backupId, CreateIndexFromBackupRequest createIndexFromBackupRequest, ApiCallback _callback) throws ApiException {
        if (backupId == null) {
            throw new ApiException("Missing the required parameter 'backupId' when calling createIndexFromBackupOperation(Async)");
        }
        if (createIndexFromBackupRequest == null) {
            throw new ApiException("Missing the required parameter 'createIndexFromBackupRequest' when calling createIndexFromBackupOperation(Async)");
        }
        return this.createIndexFromBackupOperationCall(backupId, createIndexFromBackupRequest, _callback);
    }

    public CreateIndexFromBackupResponse createIndexFromBackupOperation(String backupId, CreateIndexFromBackupRequest createIndexFromBackupRequest) throws ApiException {
        ApiResponse<CreateIndexFromBackupResponse> localVarResp = this.createIndexFromBackupOperationWithHttpInfo(backupId, createIndexFromBackupRequest);
        return localVarResp.getData();
    }

    public ApiResponse<CreateIndexFromBackupResponse> createIndexFromBackupOperationWithHttpInfo(String backupId, CreateIndexFromBackupRequest createIndexFromBackupRequest) throws ApiException {
        Call localVarCall = this.createIndexFromBackupOperationValidateBeforeCall(backupId, createIndexFromBackupRequest, null);
        Type localVarReturnType = new TypeToken<CreateIndexFromBackupResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createIndexFromBackupOperationAsync(String backupId, CreateIndexFromBackupRequest createIndexFromBackupRequest, ApiCallback<CreateIndexFromBackupResponse> _callback) throws ApiException {
        Call localVarCall = this.createIndexFromBackupOperationValidateBeforeCall(backupId, createIndexFromBackupRequest, _callback);
        Type localVarReturnType = new TypeToken<CreateIndexFromBackupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteBackupCall(String backupId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/backups/{backup_id}".replace("{backup_id}", this.localVarApiClient.escapeString(backupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteBackupValidateBeforeCall(String backupId, ApiCallback _callback) throws ApiException {
        if (backupId == null) {
            throw new ApiException("Missing the required parameter 'backupId' when calling deleteBackup(Async)");
        }
        return this.deleteBackupCall(backupId, _callback);
    }

    public void deleteBackup(String backupId) throws ApiException {
        this.deleteBackupWithHttpInfo(backupId);
    }

    public ApiResponse<Void> deleteBackupWithHttpInfo(String backupId) throws ApiException {
        Call localVarCall = this.deleteBackupValidateBeforeCall(backupId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteBackupAsync(String backupId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteBackupValidateBeforeCall(backupId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteCollectionCall(String collectionName, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/collections/{collection_name}".replace("{collection_name}", this.localVarApiClient.escapeString(collectionName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionValidateBeforeCall(String collectionName, ApiCallback _callback) throws ApiException {
        if (collectionName == null) {
            throw new ApiException("Missing the required parameter 'collectionName' when calling deleteCollection(Async)");
        }
        return this.deleteCollectionCall(collectionName, _callback);
    }

    public void deleteCollection(String collectionName) throws ApiException {
        this.deleteCollectionWithHttpInfo(collectionName);
    }

    public ApiResponse<Void> deleteCollectionWithHttpInfo(String collectionName) throws ApiException {
        Call localVarCall = this.deleteCollectionValidateBeforeCall(collectionName, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteCollectionAsync(String collectionName, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionValidateBeforeCall(collectionName, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteIndexCall(String indexName, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/indexes/{index_name}".replace("{index_name}", this.localVarApiClient.escapeString(indexName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteIndexValidateBeforeCall(String indexName, ApiCallback _callback) throws ApiException {
        if (indexName == null) {
            throw new ApiException("Missing the required parameter 'indexName' when calling deleteIndex(Async)");
        }
        return this.deleteIndexCall(indexName, _callback);
    }

    public void deleteIndex(String indexName) throws ApiException {
        this.deleteIndexWithHttpInfo(indexName);
    }

    public ApiResponse<Void> deleteIndexWithHttpInfo(String indexName) throws ApiException {
        Call localVarCall = this.deleteIndexValidateBeforeCall(indexName, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteIndexAsync(String indexName, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteIndexValidateBeforeCall(indexName, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call describeBackupCall(String backupId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/backups/{backup_id}".replace("{backup_id}", this.localVarApiClient.escapeString(backupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call describeBackupValidateBeforeCall(String backupId, ApiCallback _callback) throws ApiException {
        if (backupId == null) {
            throw new ApiException("Missing the required parameter 'backupId' when calling describeBackup(Async)");
        }
        return this.describeBackupCall(backupId, _callback);
    }

    public BackupModel describeBackup(String backupId) throws ApiException {
        ApiResponse<BackupModel> localVarResp = this.describeBackupWithHttpInfo(backupId);
        return localVarResp.getData();
    }

    public ApiResponse<BackupModel> describeBackupWithHttpInfo(String backupId) throws ApiException {
        Call localVarCall = this.describeBackupValidateBeforeCall(backupId, null);
        Type localVarReturnType = new TypeToken<BackupModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call describeBackupAsync(String backupId, ApiCallback<BackupModel> _callback) throws ApiException {
        Call localVarCall = this.describeBackupValidateBeforeCall(backupId, _callback);
        Type localVarReturnType = new TypeToken<BackupModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call describeCollectionCall(String collectionName, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/collections/{collection_name}".replace("{collection_name}", this.localVarApiClient.escapeString(collectionName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call describeCollectionValidateBeforeCall(String collectionName, ApiCallback _callback) throws ApiException {
        if (collectionName == null) {
            throw new ApiException("Missing the required parameter 'collectionName' when calling describeCollection(Async)");
        }
        return this.describeCollectionCall(collectionName, _callback);
    }

    public CollectionModel describeCollection(String collectionName) throws ApiException {
        ApiResponse<CollectionModel> localVarResp = this.describeCollectionWithHttpInfo(collectionName);
        return localVarResp.getData();
    }

    public ApiResponse<CollectionModel> describeCollectionWithHttpInfo(String collectionName) throws ApiException {
        Call localVarCall = this.describeCollectionValidateBeforeCall(collectionName, null);
        Type localVarReturnType = new TypeToken<CollectionModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call describeCollectionAsync(String collectionName, ApiCallback<CollectionModel> _callback) throws ApiException {
        Call localVarCall = this.describeCollectionValidateBeforeCall(collectionName, _callback);
        Type localVarReturnType = new TypeToken<CollectionModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call describeIndexCall(String indexName, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/indexes/{index_name}".replace("{index_name}", this.localVarApiClient.escapeString(indexName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call describeIndexValidateBeforeCall(String indexName, ApiCallback _callback) throws ApiException {
        if (indexName == null) {
            throw new ApiException("Missing the required parameter 'indexName' when calling describeIndex(Async)");
        }
        return this.describeIndexCall(indexName, _callback);
    }

    public IndexModel describeIndex(String indexName) throws ApiException {
        ApiResponse<IndexModel> localVarResp = this.describeIndexWithHttpInfo(indexName);
        return localVarResp.getData();
    }

    public ApiResponse<IndexModel> describeIndexWithHttpInfo(String indexName) throws ApiException {
        Call localVarCall = this.describeIndexValidateBeforeCall(indexName, null);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call describeIndexAsync(String indexName, ApiCallback<IndexModel> _callback) throws ApiException {
        Call localVarCall = this.describeIndexValidateBeforeCall(indexName, _callback);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call describeRestoreJobCall(String jobId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/restore-jobs/{job_id}".replace("{job_id}", this.localVarApiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call describeRestoreJobValidateBeforeCall(String jobId, ApiCallback _callback) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling describeRestoreJob(Async)");
        }
        return this.describeRestoreJobCall(jobId, _callback);
    }

    public RestoreJobModel describeRestoreJob(String jobId) throws ApiException {
        ApiResponse<RestoreJobModel> localVarResp = this.describeRestoreJobWithHttpInfo(jobId);
        return localVarResp.getData();
    }

    public ApiResponse<RestoreJobModel> describeRestoreJobWithHttpInfo(String jobId) throws ApiException {
        Call localVarCall = this.describeRestoreJobValidateBeforeCall(jobId, null);
        Type localVarReturnType = new TypeToken<RestoreJobModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call describeRestoreJobAsync(String jobId, ApiCallback<RestoreJobModel> _callback) throws ApiException {
        Call localVarCall = this.describeRestoreJobValidateBeforeCall(jobId, _callback);
        Type localVarReturnType = new TypeToken<RestoreJobModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCollectionsCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/collections";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCollectionsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.listCollectionsCall(_callback);
    }

    public CollectionList listCollections() throws ApiException {
        ApiResponse<CollectionList> localVarResp = this.listCollectionsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<CollectionList> listCollectionsWithHttpInfo() throws ApiException {
        Call localVarCall = this.listCollectionsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<CollectionList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCollectionsAsync(ApiCallback<CollectionList> _callback) throws ApiException {
        Call localVarCall = this.listCollectionsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<CollectionList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listIndexBackupsCall(String indexName, Integer limit, String paginationToken, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/indexes/{index_name}/backups".replace("{index_name}", this.localVarApiClient.escapeString(indexName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("paginationToken", paginationToken));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listIndexBackupsValidateBeforeCall(String indexName, Integer limit, String paginationToken, ApiCallback _callback) throws ApiException {
        if (indexName == null) {
            throw new ApiException("Missing the required parameter 'indexName' when calling listIndexBackups(Async)");
        }
        return this.listIndexBackupsCall(indexName, limit, paginationToken, _callback);
    }

    public BackupList listIndexBackups(String indexName, Integer limit, String paginationToken) throws ApiException {
        ApiResponse<BackupList> localVarResp = this.listIndexBackupsWithHttpInfo(indexName, limit, paginationToken);
        return localVarResp.getData();
    }

    public ApiResponse<BackupList> listIndexBackupsWithHttpInfo(String indexName, Integer limit, String paginationToken) throws ApiException {
        Call localVarCall = this.listIndexBackupsValidateBeforeCall(indexName, limit, paginationToken, null);
        Type localVarReturnType = new TypeToken<BackupList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listIndexBackupsAsync(String indexName, Integer limit, String paginationToken, ApiCallback<BackupList> _callback) throws ApiException {
        Call localVarCall = this.listIndexBackupsValidateBeforeCall(indexName, limit, paginationToken, _callback);
        Type localVarReturnType = new TypeToken<BackupList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listIndexesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/indexes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listIndexesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.listIndexesCall(_callback);
    }

    public IndexList listIndexes() throws ApiException {
        ApiResponse<IndexList> localVarResp = this.listIndexesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<IndexList> listIndexesWithHttpInfo() throws ApiException {
        Call localVarCall = this.listIndexesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<IndexList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listIndexesAsync(ApiCallback<IndexList> _callback) throws ApiException {
        Call localVarCall = this.listIndexesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<IndexList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listProjectBackupsCall(Integer limit, String paginationToken, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/backups";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("paginationToken", paginationToken));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listProjectBackupsValidateBeforeCall(Integer limit, String paginationToken, ApiCallback _callback) throws ApiException {
        return this.listProjectBackupsCall(limit, paginationToken, _callback);
    }

    public BackupList listProjectBackups(Integer limit, String paginationToken) throws ApiException {
        ApiResponse<BackupList> localVarResp = this.listProjectBackupsWithHttpInfo(limit, paginationToken);
        return localVarResp.getData();
    }

    public ApiResponse<BackupList> listProjectBackupsWithHttpInfo(Integer limit, String paginationToken) throws ApiException {
        Call localVarCall = this.listProjectBackupsValidateBeforeCall(limit, paginationToken, null);
        Type localVarReturnType = new TypeToken<BackupList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listProjectBackupsAsync(Integer limit, String paginationToken, ApiCallback<BackupList> _callback) throws ApiException {
        Call localVarCall = this.listProjectBackupsValidateBeforeCall(limit, paginationToken, _callback);
        Type localVarReturnType = new TypeToken<BackupList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listRestoreJobsCall(Integer limit, String paginationToken, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/restore-jobs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("paginationToken", paginationToken));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listRestoreJobsValidateBeforeCall(Integer limit, String paginationToken, ApiCallback _callback) throws ApiException {
        return this.listRestoreJobsCall(limit, paginationToken, _callback);
    }

    public RestoreJobList listRestoreJobs(Integer limit, String paginationToken) throws ApiException {
        ApiResponse<RestoreJobList> localVarResp = this.listRestoreJobsWithHttpInfo(limit, paginationToken);
        return localVarResp.getData();
    }

    public ApiResponse<RestoreJobList> listRestoreJobsWithHttpInfo(Integer limit, String paginationToken) throws ApiException {
        Call localVarCall = this.listRestoreJobsValidateBeforeCall(limit, paginationToken, null);
        Type localVarReturnType = new TypeToken<RestoreJobList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listRestoreJobsAsync(Integer limit, String paginationToken, ApiCallback<RestoreJobList> _callback) throws ApiException {
        Call localVarCall = this.listRestoreJobsValidateBeforeCall(limit, paginationToken, _callback);
        Type localVarReturnType = new TypeToken<RestoreJobList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

