/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.inference.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.inference.client.JSON;

public class SparseEmbedding {
    public static final String SERIALIZED_NAME_SPARSE_VALUES = "sparse_values";
    @SerializedName(value="sparse_values")
    private List<Float> sparseValues = new ArrayList<Float>();
    public static final String SERIALIZED_NAME_SPARSE_INDICES = "sparse_indices";
    @SerializedName(value="sparse_indices")
    private List<Long> sparseIndices = new ArrayList<Long>();
    public static final String SERIALIZED_NAME_SPARSE_TOKENS = "sparse_tokens";
    @SerializedName(value="sparse_tokens")
    private List<String> sparseTokens;
    public static final String SERIALIZED_NAME_VECTOR_TYPE = "vector_type";
    @SerializedName(value="vector_type")
    private String vectorType;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SparseEmbedding sparseValues(List<Float> sparseValues) {
        this.sparseValues = sparseValues;
        return this;
    }

    public SparseEmbedding addSparseValuesItem(Float sparseValuesItem) {
        if (this.sparseValues == null) {
            this.sparseValues = new ArrayList<Float>();
        }
        this.sparseValues.add(sparseValuesItem);
        return this;
    }

    @Nonnull
    public List<Float> getSparseValues() {
        return this.sparseValues;
    }

    public void setSparseValues(List<Float> sparseValues) {
        this.sparseValues = sparseValues;
    }

    public SparseEmbedding sparseIndices(List<Long> sparseIndices) {
        this.sparseIndices = sparseIndices;
        return this;
    }

    public SparseEmbedding addSparseIndicesItem(Long sparseIndicesItem) {
        if (this.sparseIndices == null) {
            this.sparseIndices = new ArrayList<Long>();
        }
        this.sparseIndices.add(sparseIndicesItem);
        return this;
    }

    @Nonnull
    public List<Long> getSparseIndices() {
        return this.sparseIndices;
    }

    public void setSparseIndices(List<Long> sparseIndices) {
        this.sparseIndices = sparseIndices;
    }

    public SparseEmbedding sparseTokens(List<String> sparseTokens) {
        this.sparseTokens = sparseTokens;
        return this;
    }

    public SparseEmbedding addSparseTokensItem(String sparseTokensItem) {
        if (this.sparseTokens == null) {
            this.sparseTokens = new ArrayList<String>();
        }
        this.sparseTokens.add(sparseTokensItem);
        return this;
    }

    @Nullable
    public List<String> getSparseTokens() {
        return this.sparseTokens;
    }

    public void setSparseTokens(List<String> sparseTokens) {
        this.sparseTokens = sparseTokens;
    }

    public SparseEmbedding vectorType(String vectorType) {
        this.vectorType = vectorType;
        return this;
    }

    @Nonnull
    public String getVectorType() {
        return this.vectorType;
    }

    public void setVectorType(String vectorType) {
        this.vectorType = vectorType;
    }

    public SparseEmbedding putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparseEmbedding sparseEmbedding = (SparseEmbedding)o;
        return Objects.equals(this.sparseValues, sparseEmbedding.sparseValues) && Objects.equals(this.sparseIndices, sparseEmbedding.sparseIndices) && Objects.equals(this.sparseTokens, sparseEmbedding.sparseTokens) && Objects.equals(this.vectorType, sparseEmbedding.vectorType) && Objects.equals(this.additionalProperties, sparseEmbedding.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.sparseValues, this.sparseIndices, this.sparseTokens, this.vectorType, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SparseEmbedding {\n");
        sb.append("    sparseValues: ").append(this.toIndentedString(this.sparseValues)).append("\n");
        sb.append("    sparseIndices: ").append(this.toIndentedString(this.sparseIndices)).append("\n");
        sb.append("    sparseTokens: ").append(this.toIndentedString(this.sparseTokens)).append("\n");
        sb.append("    vectorType: ").append(this.toIndentedString(this.vectorType)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in SparseEmbedding is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_SPARSE_VALUES) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_SPARSE_VALUES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `sparse_values` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SPARSE_VALUES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SPARSE_INDICES) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_SPARSE_INDICES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `sparse_indices` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SPARSE_INDICES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SPARSE_TOKENS) != null && !jsonObj.get(SERIALIZED_NAME_SPARSE_TOKENS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SPARSE_TOKENS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `sparse_tokens` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SPARSE_TOKENS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_VECTOR_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `vector_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VECTOR_TYPE).toString()));
        }
    }

    public static SparseEmbedding fromJson(String jsonString) throws IOException {
        return (SparseEmbedding)JSON.getGson().fromJson(jsonString, SparseEmbedding.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SPARSE_VALUES);
        openapiFields.add(SERIALIZED_NAME_SPARSE_INDICES);
        openapiFields.add(SERIALIZED_NAME_SPARSE_TOKENS);
        openapiFields.add(SERIALIZED_NAME_VECTOR_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SPARSE_VALUES);
        openapiRequiredFields.add(SERIALIZED_NAME_SPARSE_INDICES);
        openapiRequiredFields.add(SERIALIZED_NAME_VECTOR_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!SparseEmbedding.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SparseEmbedding.class));
            return new TypeAdapter<SparseEmbedding>(){

                public void write(JsonWriter out, SparseEmbedding value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public SparseEmbedding read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    SparseEmbedding.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    SparseEmbedding instance = (SparseEmbedding)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

