/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.boot.scs.serviceregistry;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.spring.boot.CfEnvProcessor;
import io.pivotal.cfenv.spring.boot.CfEnvProcessorProperties;
import java.util.Map;

public class CfEurekaClientProcessor
implements CfEnvProcessor {
    public boolean accept(CfService service) {
        return service.existsByTagIgnoreCase(new String[]{"eureka"});
    }

    public void process(CfCredentials cfCredentials, Map<String, Object> properties) {
        String uri = cfCredentials.getUri(new String[0]);
        String clientId = cfCredentials.getString(new String[]{"client_id"});
        String clientSecret = cfCredentials.getString(new String[]{"client_secret"});
        String accessTokenUri = cfCredentials.getString(new String[]{"access_token_uri"});
        properties.put("eureka.client.serviceUrl.defaultZone", uri + "/eureka/");
        properties.put("eureka.client.region", "default");
        properties.put("eureka.client.oauth2.client-id", clientId);
        properties.put("eureka.client.oauth2.client-secret", clientSecret);
        properties.put("eureka.client.oauth2.access-token-uri", accessTokenUri);
    }

    public CfEnvProcessorProperties getProperties() {
        return CfEnvProcessorProperties.builder().propertyPrefixes("eureka.client").serviceName("Spring Cloud Netflix Eureka").build();
    }
}

