/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.boot.scs;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.spring.boot.CfEnvProcessor;
import io.pivotal.cfenv.spring.boot.CfEnvProcessorProperties;
import java.util.Map;

public class CfConfigClientProcessor
implements CfEnvProcessor {
    public boolean accept(CfService service) {
        return service.existsByTagIgnoreCase(new String[]{"configuration"});
    }

    public void process(CfCredentials cfCredentials, Map<String, Object> properties) {
        properties.put("spring.cloud.config.uri", cfCredentials.getUri(new String[0]));
        properties.put("spring.cloud.config.client.oauth2.client-id", cfCredentials.getString(new String[]{"client_id"}));
        properties.put("spring.cloud.config.client.oauth2.client-secret", cfCredentials.getString(new String[]{"client_secret"}));
        properties.put("spring.cloud.config.client.oauth2.access-token-uri", cfCredentials.getString(new String[]{"access_token_uri"}));
        properties.put("spring.cloud.config.client.oauth2.scope", "");
        properties.put("spring.cloud.refresh.additional-property-sources-to-retain", this.getClass().getSimpleName());
    }

    public CfEnvProcessorProperties getProperties() {
        return CfEnvProcessorProperties.builder().propertyPrefixes("spring.cloud.config.client").serviceName("Spring Cloud Config").build();
    }
}

