/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.spring.boot;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.core.UriInfo;
import io.pivotal.cfenv.spring.boot.CfEnvProcessor;
import io.pivotal.cfenv.spring.boot.CfEnvProcessorProperties;
import io.pivotal.cfenv.spring.boot.ConnectorLibraryDetector;
import java.util.Map;
import java.util.Optional;

public class RedisCfEnvProcessor
implements CfEnvProcessor {
    private static String[] redisSchemes = new String[]{"redis", "rediss"};

    @Override
    public boolean accept(CfService service) {
        boolean serviceIsBound;
        boolean bl = serviceIsBound = service.existsByTagIgnoreCase(new String[]{"redis"}) || service.existsByLabelStartsWith("rediscloud") || service.existsByUriSchemeStartsWith(redisSchemes) || service.existsByCredentialsContainsUriField(redisSchemes);
        if (serviceIsBound) {
            ConnectorLibraryDetector.assertNoConnectorLibrary();
        }
        return serviceIsBound;
    }

    @Override
    public void process(CfCredentials cfCredentials, Map<String, Object> properties) {
        String uri = cfCredentials.getUri(redisSchemes);
        if (uri == null) {
            properties.put("spring.redis.host", cfCredentials.getHost());
            properties.put("spring.redis.password", cfCredentials.getPassword());
            Optional<String> tlsPort = Optional.ofNullable(cfCredentials.getString(new String[]{"tls_port"}));
            if (tlsPort.isPresent()) {
                properties.put("spring.redis.port", tlsPort.get());
                properties.put("spring.redis.ssl", "true");
            } else {
                properties.put("spring.redis.port", cfCredentials.getPort());
            }
        } else {
            UriInfo uriInfo = new UriInfo(uri);
            properties.put("spring.redis.host", uriInfo.getHost());
            properties.put("spring.redis.port", uriInfo.getPort());
            properties.put("spring.redis.password", uriInfo.getPassword());
            if (uriInfo.getScheme().equals("rediss")) {
                properties.put("spring.redis.ssl", "true");
            }
        }
    }

    @Override
    public CfEnvProcessorProperties getProperties() {
        return CfEnvProcessorProperties.builder().propertyPrefixes("spring.redis").serviceName("Redis").build();
    }
}

