/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.spring.boot;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.spring.boot.CfEnvProcessor;
import io.pivotal.cfenv.spring.boot.CfEnvProcessorProperties;
import java.util.ArrayList;
import java.util.Map;

public class GenAIChatCfEnvProcessor
implements CfEnvProcessor {
    @Override
    public boolean accept(CfService service) {
        boolean isGenAIService;
        boolean bl = isGenAIService = service.existsByTagIgnoreCase(new String[]{"genai"}) || service.existsByLabelStartsWith("genai");
        if (isGenAIService) {
            ArrayList modelCapabilities = (ArrayList)service.getCredentials().getMap().get("model_capabilities");
            return modelCapabilities.contains("chat");
        }
        return false;
    }

    @Override
    public void process(CfCredentials cfCredentials, Map<String, Object> properties) {
        properties.put("spring.ai.openai.api-key", "redundant");
        properties.put("spring.ai.openai.chat.base-url", cfCredentials.getString(new String[]{"api_base"}));
        properties.put("spring.ai.openai.chat.api-key", cfCredentials.getString(new String[]{"api_key"}));
        properties.put("spring.ai.openai.chat.options.model", cfCredentials.getString(new String[]{"model_name"}));
    }

    @Override
    public CfEnvProcessorProperties getProperties() {
        return CfEnvProcessorProperties.builder().propertyPrefixes("spring.ai.openai.chat").serviceName("GenAI on Tanzu Platform (chat)").build();
    }
}

