/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.spring.boot;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.spring.boot.CfEnvProcessor;
import io.pivotal.cfenv.spring.boot.CfEnvProcessorProperties;
import java.util.ArrayList;
import java.util.Map;

public class GenAIEmbeddingCfEnvProcessor
implements CfEnvProcessor {
    @Override
    public boolean accept(CfService service) {
        boolean isGenAIService;
        boolean bl = isGenAIService = service.existsByTagIgnoreCase(new String[]{"genai"}) || service.existsByLabelStartsWith("genai");
        if (isGenAIService) {
            ArrayList modelCapabilities = (ArrayList)service.getCredentials().getMap().get("model_capabilities");
            return modelCapabilities.contains("embedding");
        }
        return false;
    }

    @Override
    public void process(CfCredentials cfCredentials, Map<String, Object> properties) {
        properties.put("spring.ai.openai.api-key", "redundant");
        properties.put("spring.ai.openai.embedding.base-url", cfCredentials.getString(new String[]{"api_base"}));
        properties.put("spring.ai.openai.embedding.api-key", cfCredentials.getString(new String[]{"api_key"}));
        properties.put("spring.ai.openai.embedding.options.model", cfCredentials.getString(new String[]{"model_name"}));
    }

    @Override
    public CfEnvProcessorProperties getProperties() {
        return CfEnvProcessorProperties.builder().propertyPrefixes("spring.ai.openai.embedding").serviceName("GenAI on Tanzu Platform (embedding)").build();
    }
}

