/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.spring.boot;

import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.jdbc.CfJdbcEnv;
import io.pivotal.cfenv.jdbc.CfJdbcService;
import io.pivotal.cfenv.spring.boot.CfServiceEnablingEnvironmentPostProcessor;
import io.pivotal.cfenv.spring.boot.ConnectorLibraryDetector;
import io.pivotal.cfenv.spring.boot.DeferredLog;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class CfDataSourceEnvironmentPostProcessor
implements CfServiceEnablingEnvironmentPostProcessor,
Ordered,
ApplicationListener<ApplicationEvent> {
    private static final DeferredLog DEFERRED_LOG = new DeferredLog();
    private static int invocationCount;
    private int order = -2147483637;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.increaseInvocationCount();
        if (CloudPlatform.CLOUD_FOUNDRY.isActive((Environment)environment)) {
            CfJdbcService cfJdbcService;
            CfJdbcEnv cfJdbcEnv = new CfJdbcEnv();
            try {
                cfJdbcService = cfJdbcEnv.findJdbcService();
                cfJdbcService = this.isEnabled((CfService)cfJdbcService, (Environment)environment) ? cfJdbcService : null;
            }
            catch (Exception e) {
                List<CfJdbcService> jdbcServices = cfJdbcEnv.findJdbcServices().stream().filter(service -> this.isEnabled((CfService)service, (Environment)environment)).toList();
                if (jdbcServices.size() > 1) {
                    if (invocationCount == 1) {
                        DEFERRED_LOG.debug("Skipping execution of CfDataSourceEnvironmentPostProcessor. " + e.getMessage());
                    }
                    return;
                }
                CfJdbcService cfJdbcService2 = cfJdbcService = jdbcServices.size() == 1 ? jdbcServices.get(0) : null;
            }
            if (cfJdbcService != null) {
                MutablePropertySources propertySources;
                Map<String, String> queryOptions;
                ConnectorLibraryDetector.assertNoConnectorLibrary();
                LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                properties.put("spring.datasource.url", cfJdbcService.getJdbcUrl());
                properties.put("spring.datasource.username", cfJdbcService.getUsername());
                properties.put("spring.datasource.password", cfJdbcService.getPassword());
                String driverClassName = cfJdbcService.getDriverClassName();
                if (driverClassName != null) {
                    properties.put("spring.datasource.driver-class-name", driverClassName);
                }
                String[] splitJDBCUrl = cfJdbcService.getJdbcUrl().split("\\?");
                String r2dbcUrl = splitJDBCUrl[0].replaceFirst("jdbc:", "r2dbc:");
                properties.put("spring.r2dbc.url", r2dbcUrl);
                properties.put("spring.r2dbc.username", cfJdbcService.getUsername());
                properties.put("spring.r2dbc.password", cfJdbcService.getPassword());
                if (splitJDBCUrl.length == 2 && (queryOptions = this.parseQueryString(splitJDBCUrl[1])).size() > 0) {
                    queryOptions.forEach((key, value) -> {
                        switch (key) {
                            case "enabledTLSProtocols": {
                                properties.put("spring.r2dbc.properties.tlsVersion", (String)value);
                                break;
                            }
                            default: {
                                properties.put(String.format("spring.r2dbc.properties.%s", key), (String)value);
                            }
                        }
                    });
                }
                if ((propertySources = environment.getPropertySources()).contains("commandLineArgs")) {
                    propertySources.addAfter("commandLineArgs", (PropertySource)new MapPropertySource("cfenvjdbc", properties));
                } else {
                    propertySources.addFirst((PropertySource)new MapPropertySource("cfenvjdbc", properties));
                }
                if (invocationCount == 1) {
                    DEFERRED_LOG.info("Setting spring.datasource properties from bound service [" + cfJdbcService.getName() + "]");
                }
            }
        } else {
            DEFERRED_LOG.debug("Not setting spring.datasource.url, not in Cloud Foundry Environment");
        }
    }

    private Map<String, String> parseQueryString(String queryParams) {
        String[] options;
        if (queryParams == null || queryParams.equals("")) {
            return Collections.emptyMap();
        }
        HashMap<String, String> retVal = new HashMap<String, String>();
        for (String option : options = queryParams.split("&")) {
            String[] keyValue = option.split("=");
            if (keyValue.length != 2 || keyValue[0].length() == 0 || keyValue[1].length() == 0) continue;
            retVal.put(keyValue[0], keyValue[1]);
        }
        return retVal;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationPreparedEvent) {
            DEFERRED_LOG.switchTo(CfDataSourceEnvironmentPostProcessor.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseInvocationCount() {
        CfDataSourceEnvironmentPostProcessor cfDataSourceEnvironmentPostProcessor = this;
        synchronized (cfDataSourceEnvironmentPostProcessor) {
            ++invocationCount;
        }
    }
}

