/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.jdbc;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.core.UriInfo;
import io.pivotal.cfenv.jdbc.AbstractJdbcUrlCreator;

public class DB2JdbcUrlCreator
extends AbstractJdbcUrlCreator {
    public static final String DB2_SCHEME = "db2";
    public static final String[] DB2_TAGS = new String[]{"sqldb", "dashDB", "db2"};
    public static final String DB2_LABEL = "db2";

    @Override
    public boolean isDatabaseService(CfService cfService) {
        return this.jdbcUrlMatchesScheme(cfService, "db2") || cfService.existsByTagIgnoreCase(DB2_TAGS) || cfService.existsByLabelStartsWith("db2") || cfService.existsByUriSchemeStartsWith(new String[]{"db2"}) || cfService.existsByCredentialsContainsUriField(new String[]{"db2"});
    }

    @Override
    public String buildJdbcUrlFromUriField(CfCredentials cfCredentials) {
        UriInfo uriInfo = cfCredentials.getUriInfo("db2");
        return String.format("jdbc:%s://%s:%d/%s:user=%s;password=%s;", "db2", uriInfo.getHost(), uriInfo.getPort(), uriInfo.getPath(), uriInfo.getUsername(), uriInfo.getPassword());
    }

    @Override
    public String getDriverClassName() {
        return "com.ibm.db2.jcc.DB2Driver";
    }
}

