/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.jdbc;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.core.UriInfo;
import io.pivotal.cfenv.jdbc.AbstractJdbcUrlCreator;

public class MySqlJdbcUrlCreator
extends AbstractJdbcUrlCreator {
    public static final String MYSQL_SCHEME = "mysql";
    public static final String MARIADB_SCHEME = "mariadb";
    public static final String[] MYSQL_SCHEMES = new String[]{"mysql", "mariadb"};
    public static final String MYSQL_TAG = "mysql";
    public static final String MARIADB_TAG = "mariadb";
    public static final String[] MYSQL_TAGS = new String[]{"mysql", "mariadb"};
    public static final String MYSQL_LABEL = "mysql";
    public static final String MARIADB_LABEL = "mariadb";
    public static final String[] MYSQL_LABELS = new String[]{"mysql", "mariadb"};
    public static final String MYSQL_DRIVER_CLASS_NAME = "com.mysql.cj.jdbc.Driver";
    public static final String MARIADB_DRIVER_CLASS_NAME = "org.mariadb.jdbc.Driver";

    @Override
    public boolean isDatabaseService(CfService cfService) {
        return this.jdbcUrlMatchesScheme(cfService, MYSQL_SCHEMES) || cfService.existsByTagIgnoreCase(MYSQL_TAGS) || cfService.existsByLabelStartsWith(MYSQL_LABELS) || cfService.existsByUriSchemeStartsWith(MYSQL_SCHEMES) || cfService.existsByCredentialsContainsUriField(MYSQL_SCHEMES);
    }

    private boolean isMariaDbService(CfService cfService) {
        return this.jdbcUrlMatchesScheme(cfService, "mariadb") || cfService.existsByTagIgnoreCase(new String[]{"mariadb"}) || cfService.existsByLabelContains("mariadb") || cfService.existsByUriSchemeStartsWith(new String[]{"mariadb"}) || cfService.existsByCredentialsContainsUriField(new String[]{"mariadb"});
    }

    @Override
    public String getDriverClassName() {
        String driverClassNameToUse;
        try {
            driverClassNameToUse = MARIADB_DRIVER_CLASS_NAME;
            Class.forName(driverClassNameToUse, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                driverClassNameToUse = MYSQL_DRIVER_CLASS_NAME;
                Class.forName(driverClassNameToUse, false, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e2) {
                return null;
            }
        }
        return driverClassNameToUse;
    }

    @Override
    public String createJdbcUrl(CfService cfService) {
        CfCredentials cfCredentials = cfService.getCredentials();
        String jdbcUrl = (String)cfCredentials.getMap().get("jdbcUrl");
        if (jdbcUrl == null) {
            jdbcUrl = this.buildJdbcUrlFromUriField(cfCredentials);
        }
        if (this.isMariaDbService(cfService) && this.getDriverClassName().equals(MARIADB_DRIVER_CLASS_NAME)) {
            jdbcUrl = jdbcUrl.replaceFirst("^(jdbc:mysql)", "jdbc:mariadb");
        }
        return jdbcUrl;
    }

    @Override
    public String buildJdbcUrlFromUriField(CfCredentials cfCredentials) {
        UriInfo uriInfo = cfCredentials.getUriInfo("mysql");
        return String.format("%s%s://%s%s/%s%s%s", "jdbc:", "mysql", uriInfo.getHost(), uriInfo.formatPort(), uriInfo.getPath(), uriInfo.formatUserNameAndPasswordQuery(), uriInfo.formatQuery());
    }
}

