/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.test;

import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import mockit.Mock;
import mockit.MockUp;
import org.springframework.core.io.Resource;

public class CfEnvTestUtils {
    public static MockUp<?> mockVcapServicesFromString(final String serviceJson) {
        final Map<String, String> env = System.getenv();
        return new MockUp<System>(){

            @Mock
            public String getenv(String name) {
                if (name.equalsIgnoreCase("VCAP_SERVICES")) {
                    return serviceJson;
                }
                if (name.equalsIgnoreCase("VCAP_APPLICATION")) {
                    return "{\"instance_id\":\"123\"}";
                }
                return (String)env.get(name);
            }

            @Mock
            public Map getenv() {
                HashMap<String, String> finalMap = new HashMap<String, String>();
                finalMap.putAll(env);
                finalMap.put("VCAP_SERVICES", serviceJson);
                return finalMap;
            }
        };
    }

    public void mockVcapServicesFromResource(Resource vcapServicesResource) {
        try {
            Scanner s = new Scanner(vcapServicesResource.getInputStream()).useDelimiter("\\A");
            String serviceJson = s.hasNext() ? s.next() : "";
            CfEnvTestUtils.mockVcapServicesFromString(serviceJson);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

