/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.core;

import io.pivotal.cfenv.core.CfApplication;
import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfEnv;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.core.CfVolume;
import io.pivotal.cfenv.core.UriInfo;
import io.pivotal.cfenv.core.test.CfEnvMock;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Test;

public class CfEnvTests {
    @Test
    public void testCfApplicationValues() {
        this.mockVcapEnvVars();
        CfEnv cfEnv = new CfEnv();
        CfApplication cfApplication = cfEnv.getApp();
        Assertions.assertThat((String)cfApplication.getApplicationId()).isEqualTo("fa05c1a9-0fc1-4fbd-bae1-139850dec7a3");
        Assertions.assertThat((String)cfApplication.getInstanceId()).isEqualTo("fe98dc76ba549876543210abcd1234");
        Assertions.assertThat((int)cfApplication.getInstanceIndex()).isEqualTo(0);
        Assertions.assertThat((String)cfApplication.getHost()).isEqualTo("0.0.0.0");
        Assertions.assertThat((int)cfApplication.getPort()).isEqualTo(61857);
        Assertions.assertThat((String)cfApplication.getApplicationVersion()).isEqualTo("ab12cd34-5678-abcd-0123-abcdef987654");
        Assertions.assertThat((String)cfApplication.getApplicationName()).isEqualTo("styx-james");
        Assertions.assertThat((List)cfApplication.getApplicationUris()).contains((Object[])new String[]{"my-app.example.com"});
        Assertions.assertThat((String)cfApplication.getVersion()).isEqualTo("ab12cd34-5678-abcd-0123-abcdef987654");
        Assertions.assertThat((String)cfApplication.getName()).isEqualTo("my-app");
        Assertions.assertThat((List)cfApplication.getUris()).contains((Object[])new String[]{"my-app.example.com"});
        Assertions.assertThat((String)cfApplication.getCfApi()).isEqualTo("https://api.example.com");
        Assertions.assertThat((String)cfApplication.getSpaceId()).isEqualTo("06450c72-4669-4dc6-8096-45f9777db68a");
        Assertions.assertThat((String)cfApplication.getSpaceName()).isEqualTo("my-space");
    }

    @Test
    public void testCfService() {
        this.mockVcapEnvVars();
        CfEnv cfEnv = new CfEnv();
        List cfServices = cfEnv.findAllServices();
        Assertions.assertThat((int)cfServices.size()).isEqualTo(3);
        CfService cfService = cfEnv.findServiceByTag(new String[]{"mysql"});
        Assertions.assertThat((String)cfService.getString(new String[]{"blah"})).isNull();
        Assertions.assertThat((List)cfService.getTags()).containsExactly((Object[])new String[]{"mysql", "relational"});
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)cfService.getMap()).containsEntry((Object)"syslog_drain_url", null)).containsEntry((Object)"volume_mounts", new ArrayList())).containsEntry((Object)"label", (Object)"p-mysql")).containsEntry((Object)"provider", null)).containsEntry((Object)"plan", (Object)"100mb")).containsEntry((Object)"name", (Object)"mysql")).containsKey((Object)"credentials");
        CfCredentials cfCredentials = cfService.getCredentials();
        this.assertMySqlCredentials(cfCredentials);
        Assertions.assertThat((boolean)cfService.existsByTagIgnoreCase(new String[0])).isFalse();
        Assertions.assertThat((boolean)cfService.existsByTagIgnoreCase((String[])null)).isFalse();
        Assertions.assertThat((boolean)cfService.existsByTagIgnoreCase(new String[]{"relational"})).isTrue();
        Assertions.assertThat((boolean)cfService.existsByTagIgnoreCase(new String[]{"ReLaTiOnAl"})).isTrue();
        Assertions.assertThat((boolean)cfService.existsByTagIgnoreCase(new String[]{"blah"})).isFalse();
        Assertions.assertThat((boolean)cfService.existsByTagIgnoreCase(new String[]{"blah", "relational"})).isTrue();
        Assertions.assertThat((boolean)cfService.existsByUriSchemeStartsWith(new String[0])).isFalse();
        Assertions.assertThat((boolean)cfService.existsByUriSchemeStartsWith((String[])null)).isFalse();
        Assertions.assertThat((boolean)cfService.existsByUriSchemeStartsWith(new String[]{"mysql"})).isTrue();
        Assertions.assertThat((boolean)cfService.existsByUriSchemeStartsWith(new String[]{"MYSQL"})).isFalse();
        Assertions.assertThat((boolean)cfService.existsByUriSchemeStartsWith(new String[]{"blah"})).isFalse();
        Assertions.assertThat((boolean)cfService.existsByUriSchemeStartsWith(new String[]{"blah", "mysql"})).isTrue();
        Assertions.assertThat((boolean)cfService.existsByCredentialsContainsUriField(new String[0])).isFalse();
        Assertions.assertThat((boolean)cfService.existsByCredentialsContainsUriField((String[])null)).isFalse();
        Assertions.assertThat((boolean)cfService.existsByCredentialsContainsUriField(new String[]{"mysql"})).isFalse();
        cfService = cfEnv.findServiceByTag(new String[]{"redis"});
        Assertions.assertThat((List)cfService.getTags()).containsExactly((Object[])new String[]{"pivotal", "redis"});
        cfCredentials = cfService.getCredentials();
        Map credentialMap = cfCredentials.getMap();
        credentialMap = cfCredentials.getMap();
        Assertions.assertThat((Map)credentialMap).containsEntry((Object)"host", (Object)"10.0.4.30");
        Assertions.assertThat((String)cfCredentials.getHost()).isEqualTo("10.0.4.30");
        Assertions.assertThat((String)cfService.getName()).isEqualTo("redis-binding");
        cfService = cfEnv.findServiceByName(new String[]{"nfs1"});
        Assertions.assertThat((List)cfService.getTags()).containsExactly((Object[])new String[]{"nfs"});
        List cfVolumes = cfService.getVolumes();
        this.assertNfsVolumes(cfVolumes);
    }

    private void assertMySqlCredentials(CfCredentials cfCredentials) {
        Map credentialMap = cfCredentials.getMap();
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)credentialMap).containsEntry((Object)"hostname", (Object)"10.0.4.35")).containsEntry((Object)"port", (Object)3306)).containsEntry((Object)"name", (Object)"mysql_name")).containsEntry((Object)"username", (Object)"mysql_username")).containsEntry((Object)"password", (Object)"mysql_password")).containsEntry((Object)"uri", (Object)"mysql://mysql_username:mysql_password@10.0.4.35:3306/cf_2e23d10a_8738_8c3c_66cf_13e44422698c?reconnect=true")).containsEntry((Object)"jdbcUrl", (Object)"jdbc:mysql://10.0.4.35:3306/cf_2e23d10a_8738_8c3c_66cf_13e44422698c?user=mysql_username&password=mysql_password");
        Assertions.assertThat((String)cfCredentials.getUsername()).isEqualTo("mysql_username");
        Assertions.assertThat((String)cfCredentials.getPassword()).isEqualTo("mysql_password");
        Assertions.assertThat((String)cfCredentials.getHost()).isEqualTo("10.0.4.35");
        Assertions.assertThat((String)cfCredentials.getPort()).isEqualTo("3306");
        Assertions.assertThat((String)cfCredentials.getUri(new String[0])).isEqualTo("mysql://mysql_username:mysql_password@10.0.4.35:3306/cf_2e23d10a_8738_8c3c_66cf_13e44422698c?reconnect=true");
        UriInfo uriInfo = cfCredentials.getUriInfo("mysql");
        this.assertUriInfo(uriInfo);
        uriInfo = cfCredentials.getUriInfo();
        this.assertUriInfo(uriInfo);
    }

    private void assertUriInfo(UriInfo uriInfo) {
        Assertions.assertThat((String)uriInfo.getUsername()).isEqualTo("mysql_username");
        Assertions.assertThat((String)uriInfo.getPassword()).isEqualTo("mysql_password");
        Assertions.assertThat((String)uriInfo.getHost()).isEqualTo("10.0.4.35");
        Assertions.assertThat((int)uriInfo.getPort()).isEqualTo(3306);
    }

    @Test
    public void testFindServiceByName() {
        this.mockVcapEnvVars();
        CfEnv cfEnv = new CfEnv();
        CfService cfService = cfEnv.findServiceByTag(new String[]{"redis"});
        Assertions.assertThat((String)cfService.getLabel()).isEqualTo("p-redis");
        Assertions.assertThat((String)cfService.getPlan()).isEqualTo("shared-vm");
        Assertions.assertThat((String)cfService.getName()).isEqualTo("redis-binding");
        cfService = cfEnv.findServiceByTag(new String[]{"blah", "redis"});
        Assertions.assertThat((String)cfService.getLabel()).isEqualTo("p-redis");
        cfService = cfEnv.findServiceByName(new String[]{".*sql"});
        Assertions.assertThat((String)cfService.getName()).isEqualTo("mysql");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cfEnv.findServiceByName(new String[]{"blah"})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No service with name [blah]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cfEnv.findServiceByName(new String[]{""})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No service with name []");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cfEnv.findServiceByName((String[])null)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No service with name [null]");
    }

    @Test
    public void testFindServiceByLabel() {
        this.mockVcapEnvVars();
        CfEnv cfEnv = new CfEnv();
        CfService cfService = cfEnv.findServiceByLabel(new String[]{"p-redis"});
        Assertions.assertThat((String)cfService.getLabel()).isEqualTo("p-redis");
        Assertions.assertThat((String)cfService.getPlan()).isEqualTo("shared-vm");
        Assertions.assertThat((String)cfService.getName()).isEqualTo("redis-binding");
        cfService = cfEnv.findServiceByLabel(new String[]{"blah", "p-redis"});
        Assertions.assertThat((String)cfService.getLabel()).isEqualTo("p-redis");
        Assertions.assertThat((String)cfService.getName()).isEqualTo("redis-binding");
        cfService = cfEnv.findServiceByLabel(new String[]{".*redis"});
        Assertions.assertThat((String)cfService.getLabel()).isEqualTo("p-redis");
        Assertions.assertThat((String)cfService.getName()).isEqualTo("redis-binding");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cfEnv.findServiceByLabel(new String[]{"blah"})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No service with label [blah]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cfEnv.findServiceByLabel(new String[]{""})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No service with label []");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cfEnv.findServiceByLabel((String[])null)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No service with label [null]");
    }

    @Test
    public void testFindServiceByTag() {
        this.mockVcapEnvVars();
        CfEnv cfEnv = new CfEnv();
        CfService cfService = cfEnv.findServiceByTag(new String[]{"redis"});
        Assertions.assertThat((String)cfService.getLabel()).isEqualTo("p-redis");
        Assertions.assertThat((String)cfService.getPlan()).isEqualTo("shared-vm");
        Assertions.assertThat((String)cfService.getName()).isEqualTo("redis-binding");
        cfService = cfEnv.findServiceByTag(new String[]{"blah", "redis"});
        Assertions.assertThat((String)cfService.getLabel()).isEqualTo("p-redis");
        cfService = cfEnv.findServiceByTag(new String[]{".*sql"});
        Assertions.assertThat((String)cfService.getName()).isEqualTo("mysql");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cfEnv.findServiceByTag(new String[]{"blah"})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No service with tag [blah]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cfEnv.findServiceByTag(new String[]{""})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No service with tag []");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cfEnv.findServiceByTag((String[])null)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No service with tag [null]");
    }

    @Test
    public void testFindCredentialsByName() {
        this.mockVcapEnvVars();
        CfEnv cfEnv = new CfEnv();
        CfCredentials cfCredentials = cfEnv.findCredentialsByName(new String[]{"mysql"});
        this.assertMySqlCredentials(cfCredentials);
        cfCredentials = cfEnv.findCredentialsByName(new String[]{"blah", "mysql"});
        this.assertMySqlCredentials(cfCredentials);
        cfCredentials = cfEnv.findCredentialsByName(new String[]{".*sql"});
        this.assertMySqlCredentials(cfCredentials);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cfEnv.findCredentialsByName(new String[]{"blah"})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No service with name [blah]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cfEnv.findCredentialsByName(new String[]{""})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No service with name []");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cfEnv.findCredentialsByName((String[])null)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No service with name [null]");
    }

    @Test
    public void testFindCredentialsByLabel() {
        this.mockVcapEnvVars();
        CfEnv cfEnv = new CfEnv();
        CfCredentials cfCredentials = cfEnv.findCredentialsByLabel(new String[]{"p-mysql"});
        this.assertMySqlCredentials(cfCredentials);
        cfCredentials = cfEnv.findCredentialsByLabel(new String[]{"blah", "p-mysql"});
        this.assertMySqlCredentials(cfCredentials);
        cfCredentials = cfEnv.findCredentialsByLabel(new String[]{".*mysql"});
        this.assertMySqlCredentials(cfCredentials);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cfEnv.findCredentialsByLabel(new String[]{"blah"})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No service with label [blah]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cfEnv.findCredentialsByLabel(new String[]{""})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No service with label []");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cfEnv.findCredentialsByLabel((String[])null)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No service with label [null]");
    }

    @Test
    public void testFindCredentialsByTag() {
        CfEnv cfEnv = new CfEnv();
        CfCredentials cfCredentials = cfEnv.findCredentialsByTag(new String[]{"mysql"});
        this.assertMySqlCredentials(cfCredentials);
        cfCredentials = cfEnv.findCredentialsByTag(new String[]{"blah", "mysql"});
        this.assertMySqlCredentials(cfCredentials);
        cfCredentials = cfEnv.findCredentialsByTag(new String[]{".*sql"});
        this.assertMySqlCredentials(cfCredentials);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cfEnv.findCredentialsByTag(new String[]{"blah"})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No service with tag [blah]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cfEnv.findCredentialsByTag(new String[]{""})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No service with tag []");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cfEnv.findCredentialsByTag((String[])null)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No service with tag [null]");
    }

    @Test
    public void testNullCredentials() {
        CfEnvMock.configure().vcapServicesResource("vcap-null-credentials.json").mock();
        CfEnv cfEnv = new CfEnv();
        CfService cfService = cfEnv.findServiceByTag(new String[]{"efs"});
        cfService.existsByCredentialsContainsUriField(new String[]{"foo"});
    }

    private void assertNfsVolumes(List<CfVolume> cfVolumes) {
        Assertions.assertThat((int)cfVolumes.size()).isEqualTo(1);
        String expectedVolumePath = "/var/vcap/data/78525ee7-196c-4ed4-8ac6-857d15334631";
        Map cfVolumeMap = cfVolumes.get(0).getMap();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)cfVolumeMap).containsEntry((Object)"container_dir", (Object)expectedVolumePath)).containsEntry((Object)"device_type", (Object)"shared")).containsEntry((Object)"mode", (Object)"rw");
        CfVolume cfVolume = cfVolumes.get(0);
        String normalizedVolumePath = expectedVolumePath.replace('/', File.separatorChar);
        Assertions.assertThat((String)cfVolume.getPath().toString()).isEqualTo(normalizedVolumePath);
        Assertions.assertThat((Comparable)cfVolume.getMode()).isEqualTo((Object)CfVolume.Mode.READ_WRITE);
    }

    @Test
    public void testMultipleMatchingServices() {
        CfEnvMock.configure().vcapServicesResource("vcap-services-multiple-mysql.json").mock();
        CfEnv cfEnv = new CfEnv();
        List services = cfEnv.findAllServices();
        Assertions.assertThat((int)services.size()).isEqualTo(3);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            CfService service = cfEnv.findServiceByName(new String[]{"mysql.*"});
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No unique service matching by name [mysql.*] was found.  Matching service names are [mysql, mysql2]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            CfService service = cfEnv.findServiceByLabel(new String[]{"p-mysql"});
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No unique service matching by label [p-mysql] was found.  Matching service names are [mysql, mysql2]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            CfService service = cfEnv.findServiceByTag(new String[]{"mysql"});
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No unique service matching by tag [mysql] was found.  Matching service names are [mysql, mysql2]");
        List servicesByName = cfEnv.findServicesByName(new String[]{"mysql.*"});
        Assertions.assertThat((int)servicesByName.size()).isEqualTo(2);
        List servicesByLabel = cfEnv.findServicesByLabel(new String[]{"p-mysql"});
        Assertions.assertThat((int)servicesByLabel.size()).isEqualTo(2);
        List servicesByTag = cfEnv.findServicesByTag(new String[]{"relational"});
        Assertions.assertThat((int)servicesByTag.size()).isEqualTo(2);
    }

    private void mockVcapEnvVars() {
        CfEnvMock.configure().vcapServicesResource("vcap-services.json").mock();
    }
}

