/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.core;

import io.pivotal.cfenv.core.UriInfo;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class UriInfoTests {
    @Test
    public void createUri() {
        String uri = "mysql://joe:joes_password@localhost:1527/big_db";
        UriInfo uriInfo = new UriInfo(uri);
        this.assertUriInfoEquals(uriInfo, "localhost", 1527, "joe", "joes_password", "big_db", null);
        Assertions.assertThat((String)uri).isEqualTo(uriInfo.getUriString());
    }

    @Test
    public void createUriWithQuery() {
        String uri = "mysql://joe:joes_password@localhost:1527/big_db?p1=v1&p2=v2";
        UriInfo uriInfo = new UriInfo(uri);
        this.assertUriInfoEquals(uriInfo, "localhost", 1527, "joe", "joes_password", "big_db", "p1=v1&p2=v2");
        Assertions.assertThat((String)uri).isEqualTo(uriInfo.getUriString());
    }

    @Test
    public void createNoUsernamePassword() {
        String uri = "mysql://localhost:1527/big_db";
        UriInfo uriInfo = new UriInfo(uri);
        this.assertUriInfoEquals(uriInfo, "localhost", 1527, null, null, "big_db", null);
        Assertions.assertThat((String)uri).isEqualTo(uriInfo.getUriString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void createWithUsernameNoPassword() {
        String uri = "mysql://joe@localhost:1527/big_db";
        new UriInfo(uri);
    }

    @Test
    public void createWithExplicitParameters() {
        String uri = "mysql://joe:joes_password@localhost:1527/big_db";
        UriInfo uriInfo = new UriInfo("mysql", "localhost", 1527, "joe", "joes_password", "big_db");
        this.assertUriInfoEquals(uriInfo, "localhost", 1527, "joe", "joes_password", "big_db", null);
        Assertions.assertThat((String)uri).isEqualTo(uriInfo.getUriString());
    }

    private void assertUriInfoEquals(UriInfo uriInfo, String host, int port, String username, String password, String path, String query) {
        Assertions.assertThat((String)host).isEqualTo(uriInfo.getHost());
        Assertions.assertThat((int)port).isEqualTo(uriInfo.getPort());
        Assertions.assertThat((String)username).isEqualTo(uriInfo.getUsername());
        Assertions.assertThat((String)password).isEqualTo(uriInfo.getPassword());
        Assertions.assertThat((String)path).isEqualTo(uriInfo.getPath());
        Assertions.assertThat((String)query).isEqualTo(uriInfo.getQuery());
        Assertions.assertThat((String)"mysql").isEqualTo(uriInfo.getScheme());
    }
}

