/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.core.test;

import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import mockit.Mock;
import mockit.MockUp;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class CfEnvMock {
    private static final String VCAP_APPLICATION = "VCAP_APPLICATION";
    private static final String VCAP_SERVICES = "VCAP_SERVICES";
    private MockUp<?> mockUp;

    private CfEnvMock(final String vcapServicesJson, final String vcapApplicationJson) {
        final Map<String, String> env = System.getenv();
        this.mockUp = new MockUp<System>(){

            @Mock
            public String getenv(String name) {
                if (name.equalsIgnoreCase(CfEnvMock.VCAP_SERVICES)) {
                    return vcapServicesJson;
                }
                if (name.equalsIgnoreCase(CfEnvMock.VCAP_APPLICATION)) {
                    return vcapApplicationJson;
                }
                return (String)env.get(name);
            }

            @Mock
            public Map getenv() {
                HashMap<String, String> finalMap = new HashMap<String, String>();
                finalMap.putAll(env);
                finalMap.put(CfEnvMock.VCAP_SERVICES, vcapServicesJson);
                return finalMap;
            }
        };
    }

    public MockUp<?> getMockUp() {
        return this.mockUp;
    }

    public static Configurer configure() {
        return new Configurer();
    }

    public static class Configurer {
        private String vcapServices;
        private String vcapApplication;
        private static String DEFAULT_VCAP_APPLICATION_PATH = "test/vcap-application.json";

        private Configurer() {
            this.vcapApplicationResource(DEFAULT_VCAP_APPLICATION_PATH);
        }

        public Configurer vcapServices(String vcapServicesJson) {
            this.vcapServices = vcapServicesJson;
            return this;
        }

        public Configurer vcapServicesResource(String resourcePath) {
            Assert.hasText((String)resourcePath, (String)"'resourcePath' cannot be empty or null");
            this.vcapServices = this.resourceToString((Resource)new ClassPathResource(resourcePath));
            return this;
        }

        public Configurer vcapApplication(String vcapApplicationJson) {
            this.vcapApplication = vcapApplicationJson;
            return this;
        }

        public Configurer vcapApplicationResource(String resourcePath) {
            Assert.hasText((String)resourcePath, (String)"'resourcePath' cannot be empty or null");
            this.vcapApplication = this.resourceToString((Resource)new ClassPathResource(resourcePath));
            return this;
        }

        private String resourceToString(Resource resource) {
            String contents;
            try {
                Scanner s = new Scanner(resource.getInputStream()).useDelimiter("\\A");
                contents = s.hasNext() ? s.next() : "";
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return contents;
        }

        public CfEnvMock mock() {
            return new CfEnvMock(this.vcapServices, this.vcapApplication);
        }
    }
}

