/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.pivotal.cfenv.core.CfApplication;
import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CfEnv {
    private static final String VCAP_APPLICATION = "VCAP_APPLICATION";
    private static final String VCAP_SERVICES = "VCAP_SERVICES";
    private final List<CfService> cfServices = new ArrayList<CfService>();
    private CfApplication cfApplication;

    public CfEnv() {
        ObjectMapper objectMapper = new ObjectMapper();
        this.parseVcapServices(objectMapper);
        this.parseVcapApplication(objectMapper);
    }

    private void parseVcapApplication(ObjectMapper objectMapper) {
        try {
            String vcapApplicationJson = System.getenv(VCAP_APPLICATION);
            if (vcapApplicationJson != null && vcapApplicationJson.length() > 0) {
                Map applicationData = (Map)objectMapper.readValue(vcapApplicationJson, Map.class);
                this.cfApplication = new CfApplication(applicationData);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not access/parse VCAP_APPLICATIONenvironment variable.", e);
        }
    }

    private void parseVcapServices(ObjectMapper objectMapper) {
        try {
            String vcapServicesJson = System.getenv(VCAP_SERVICES);
            if (vcapServicesJson != null && vcapServicesJson.length() > 0) {
                Map rawServicesMap = (Map)objectMapper.readValue(vcapServicesJson, Map.class);
                rawServicesMap.values().stream().flatMap(Collection::stream).forEach(serviceData -> this.cfServices.add(new CfService((Map<String, Object>)serviceData)));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not access/parse VCAP_SERVICES environment variable.", e);
        }
    }

    public CfApplication getApp() {
        return this.cfApplication;
    }

    public List<CfService> findAllServices() {
        return this.cfServices;
    }

    public List<CfService> findServicesByName(String ... spec) {
        if (spec == null || spec.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(spec).flatMap(regex -> this.cfServices.stream().filter(cfService -> {
            String name = cfService.getName();
            return name != null && name.length() > 0 && name.matches((String)regex);
        })).distinct().collect(Collectors.toList());
    }

    public CfService findServiceByName(String ... spec) {
        List<CfService> cfServices = this.findServicesByName(spec);
        if (cfServices.size() == 1) {
            return (CfService)cfServices.stream().findFirst().get();
        }
        String specMessage = spec == null ? "null" : String.join((CharSequence)", ", spec);
        this.throwExceptionIfMultipleMatches(cfServices, specMessage, "name");
        throw new IllegalArgumentException("No service with name [" + specMessage + "] was found.");
    }

    private void throwExceptionIfMultipleMatches(List<CfService> cfServices, String specMessage, String operation) {
        if (cfServices.size() > 1) {
            CharSequence[] names = (String[])cfServices.stream().map(CfService::getName).toArray(String[]::new);
            throw new IllegalArgumentException("No unique service matching by " + operation + " [" + specMessage + "] was found.  Matching service names are [" + String.join((CharSequence)", ", names) + "]");
        }
    }

    public List<CfService> findServicesByLabel(String ... spec) {
        if (spec == null || spec.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(spec).flatMap(regex -> this.cfServices.stream().filter(cfService -> {
            String label = cfService.getLabel();
            return label != null && label.length() > 0 && label.matches((String)regex);
        })).distinct().collect(Collectors.toList());
    }

    public CfService findServiceByLabel(String ... spec) {
        List<CfService> cfServices = this.findServicesByLabel(spec);
        if (cfServices.size() == 1) {
            return (CfService)cfServices.stream().findFirst().get();
        }
        String message = spec == null ? "null" : String.join((CharSequence)", ", spec);
        this.throwExceptionIfMultipleMatches(cfServices, message, "label");
        throw new IllegalArgumentException("No service with label [" + message + "] was found.");
    }

    public CfService findServiceByTag(String ... spec) {
        List<CfService> cfServices = this.findServicesByTag(spec);
        if (cfServices.size() == 1) {
            return (CfService)cfServices.stream().findFirst().get();
        }
        String message = spec == null ? "null" : String.join((CharSequence)", ", spec);
        this.throwExceptionIfMultipleMatches(cfServices, message, "tag");
        throw new IllegalArgumentException("No service with tag [" + message + "] was found.");
    }

    public List<CfService> findServicesByTag(String ... spec) {
        if (spec == null || spec.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(spec).flatMap(regex -> this.cfServices.stream().filter(cfService -> cfService.getTags().stream().anyMatch(tag -> tag != null && tag.matches((String)regex)))).distinct().collect(Collectors.toList());
    }

    public CfCredentials findCredentialsByName(String ... spec) {
        CfService cfService = this.findServiceByName(spec);
        return cfService.getCredentials();
    }

    public CfCredentials findCredentialsByLabel(String ... spec) {
        CfService cfService = this.findServiceByLabel(spec);
        return cfService.getCredentials();
    }

    public CfCredentials findCredentialsByTag(String ... spec) {
        CfService cfService = this.findServiceByTag(spec);
        return cfService.getCredentials();
    }

    public boolean isInCf() {
        return System.getenv(VCAP_APPLICATION) != null;
    }
}

