/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.core;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfVolume;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CfService {
    private static final String TAGS = "tags";
    private static final String CREDENTIALS = "credentials";
    private static final String VOLUME_MOUNTS = "volume_mounts";
    private final Map<String, Object> serviceData;
    private final CfCredentials cfCredentials;
    private final List<CfVolume> cfVolumes;

    public CfService(Map<String, Object> serviceData) {
        this.serviceData = serviceData;
        this.cfCredentials = this.createCredentials();
        this.cfVolumes = this.createVolumes();
    }

    public CfCredentials createCredentials() {
        Map<String, Object> credentials = new HashMap<String, Object>();
        if (this.serviceData.containsKey(CREDENTIALS)) {
            credentials = (Map)this.serviceData.get(CREDENTIALS);
        }
        if (credentials == null) {
            credentials = new HashMap();
        }
        return new CfCredentials(credentials);
    }

    public List<CfVolume> createVolumes() {
        ArrayList<CfVolume> volumes = new ArrayList<CfVolume>();
        if (this.serviceData.containsKey(VOLUME_MOUNTS)) {
            List volumeDatas = (List)this.serviceData.get(VOLUME_MOUNTS);
            for (Map volumeData : volumeDatas) {
                volumes.add(new CfVolume(volumeData));
            }
        }
        return volumes;
    }

    public Map<String, Object> getMap() {
        return this.serviceData;
    }

    public CfCredentials getCredentials() {
        return this.cfCredentials;
    }

    List<CfVolume> getVolumes() {
        return this.cfVolumes;
    }

    public List<String> getTags() {
        List<String> tags = new ArrayList<String>();
        if (this.serviceData.containsKey(TAGS)) {
            tags = (List)this.serviceData.get(TAGS);
        }
        return tags;
    }

    public String getLabel() {
        return this.getString("label");
    }

    public String getPlan() {
        return this.getString("plan");
    }

    public String getName() {
        String name = this.getString("name");
        if (name == null) {
            name = this.getString("binding_name");
        }
        if (name == null) {
            name = this.getString("instance_name");
        }
        return name;
    }

    public String getString(String ... keys) {
        if (this.serviceData != null) {
            for (String key : keys) {
                if (!this.serviceData.containsKey(key)) continue;
                return this.serviceData.get(key).toString();
            }
        }
        return null;
    }

    public boolean existsByTagIgnoreCase(String ... tags) {
        if (tags != null) {
            for (String serviceTag : this.getTags()) {
                for (String tagToMatch : tags) {
                    if (tagToMatch == null || tagToMatch.length() <= 0 || !tagToMatch.equalsIgnoreCase(serviceTag)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean existsByUriSchemeStartsWith(String ... uriSchemes) {
        CfCredentials credentials;
        String uri;
        if (uriSchemes != null && (uri = (credentials = this.getCredentials()).getUri(new String[0])) != null) {
            for (String uriScheme : uriSchemes) {
                if (!uri.startsWith(uriScheme + "://")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean existsByCredentialsContainsUriField(String ... uriSchemes) {
        if (uriSchemes != null) {
            CfCredentials cfCredentials = this.getCredentials();
            for (String uriScheme : uriSchemes) {
                if (!cfCredentials.getMap().containsKey(uriScheme + "Uri") && !cfCredentials.getMap().containsKey(uriScheme + "uri") && !cfCredentials.getMap().containsKey(uriScheme + "Url") && !cfCredentials.getMap().containsKey(uriScheme + "url")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean existsByLabelStartsWith(String label) {
        String cfLabel = this.getLabel();
        if (cfLabel != null && cfLabel.length() > 0) {
            return cfLabel.startsWith(label);
        }
        return false;
    }

    public boolean existsByLabelContains(String label) {
        String cfLabel = this.getLabel();
        if (cfLabel != null && cfLabel.length() > 0) {
            return cfLabel.contains(label);
        }
        return false;
    }

    public boolean existsByLabelStartsWith(String ... labels) {
        String cfLabel = this.getLabel();
        if (labels != null && cfLabel != null && !cfLabel.isEmpty()) {
            for (String labelToMatch : labels) {
                if (!labelToMatch.startsWith(cfLabel)) continue;
                return true;
            }
        }
        return false;
    }
}

