/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.reactor.scheduler;

import io.pivotal.reactor.scheduler._ReactorSchedulerClient;
import io.pivotal.scheduler.v1.calls.Calls;
import io.pivotal.scheduler.v1.jobs.Jobs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.immutables.value.Generated;
import reactor.core.publisher.Mono;

@Generated(from="_ReactorSchedulerClient", generator="Immutables")
public final class ReactorSchedulerClient
extends _ReactorSchedulerClient {
    private final transient Calls calls;
    private final transient Jobs jobs;
    private final ConnectionContext connectionContext;
    private final Map<String, String> requestTags;
    private final Mono<String> root;
    private final TokenProvider tokenProvider;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ReactorSchedulerClient(Builder builder) {
        this.connectionContext = builder.connectionContext;
        this.tokenProvider = builder.tokenProvider;
        if (builder.requestTagsIsSet()) {
            this.initShim.requestTags(ReactorSchedulerClient.createUnmodifiableMap(false, false, builder.requestTags));
        }
        if (builder.root != null) {
            this.initShim.root((Mono<String>)builder.root);
        }
        this.calls = this.initShim.calls();
        this.jobs = this.initShim.jobs();
        this.requestTags = this.initShim.getRequestTags();
        this.root = this.initShim.getRoot();
        this.initShim = null;
    }

    @Override
    public Calls calls() {
        InitShim shim = this.initShim;
        return shim != null ? shim.calls() : this.calls;
    }

    @Override
    public Jobs jobs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobs() : this.jobs;
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    @Override
    public Map<String, String> getRequestTags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRequestTags() : this.requestTags;
    }

    @Override
    public Mono<String> getRoot() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRoot() : this.root;
    }

    @Override
    public TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ReactorSchedulerClient && this.equalTo((ReactorSchedulerClient)another);
    }

    private boolean equalTo(ReactorSchedulerClient another) {
        return this.calls.equals(another.calls) && this.jobs.equals(another.jobs) && this.connectionContext.equals(another.connectionContext) && this.requestTags.equals(another.requestTags) && this.root.equals(another.root) && this.tokenProvider.equals(another.tokenProvider);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.calls.hashCode();
        h += (h << 5) + this.jobs.hashCode();
        h += (h << 5) + this.connectionContext.hashCode();
        h += (h << 5) + this.requestTags.hashCode();
        h += (h << 5) + this.root.hashCode();
        h += (h << 5) + this.tokenProvider.hashCode();
        return h;
    }

    public String toString() {
        return "ReactorSchedulerClient{calls=" + this.calls + ", jobs=" + this.jobs + ", connectionContext=" + this.connectionContext + ", requestTags=" + this.requestTags + ", root=" + this.root + ", tokenProvider=" + this.tokenProvider + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_ReactorSchedulerClient", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CONNECTION_CONTEXT = 1L;
        private static final long INIT_BIT_TOKEN_PROVIDER = 2L;
        private static final long OPT_BIT_REQUEST_TAGS = 1L;
        private long initBits = 3L;
        private long optBits;
        private ConnectionContext connectionContext;
        private Map<String, String> requestTags = new LinkedHashMap<String, String>();
        private Mono<String> root;
        private TokenProvider tokenProvider;

        private Builder() {
        }

        public final Builder from(ReactorSchedulerClient instance) {
            return this.from((_ReactorSchedulerClient)instance);
        }

        final Builder from(_ReactorSchedulerClient instance) {
            Objects.requireNonNull(instance, "instance");
            this.connectionContext(instance.getConnectionContext());
            this.putAllRequestTags(instance.getRequestTags());
            this.root(instance.getRoot());
            this.tokenProvider(instance.getTokenProvider());
            return this;
        }

        public final Builder connectionContext(ConnectionContext connectionContext) {
            this.connectionContext = Objects.requireNonNull(connectionContext, "connectionContext");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder requestTag(String key, String value) {
            this.requestTags.put(Objects.requireNonNull(key, "requestTags key"), Objects.requireNonNull(value, "requestTags value"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder requestTag(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.requestTags.put(Objects.requireNonNull(k, "requestTags key"), Objects.requireNonNull(v, "requestTags value"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder requestTags(Map<String, ? extends String> entries) {
            this.requestTags.clear();
            this.optBits |= 1L;
            return this.putAllRequestTags(entries);
        }

        public final Builder putAllRequestTags(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.requestTags.put(Objects.requireNonNull(k, "requestTags key"), Objects.requireNonNull(v, "requestTags value"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder root(Mono<String> root) {
            this.root = Objects.requireNonNull(root, "root");
            return this;
        }

        public final Builder tokenProvider(TokenProvider tokenProvider) {
            this.tokenProvider = Objects.requireNonNull(tokenProvider, "tokenProvider");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ReactorSchedulerClient build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ReactorSchedulerClient(this);
        }

        private boolean requestTagsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("connectionContext");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tokenProvider");
            }
            return "Cannot build ReactorSchedulerClient, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="_ReactorSchedulerClient", generator="Immutables")
    private final class InitShim {
        private byte callsBuildStage = 0;
        private Calls calls;
        private byte jobsBuildStage = 0;
        private Jobs jobs;
        private byte requestTagsBuildStage = 0;
        private Map<String, String> requestTags;
        private byte rootBuildStage = 0;
        private Mono<String> root;

        private InitShim() {
        }

        Calls calls() {
            if (this.callsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.callsBuildStage == 0) {
                this.callsBuildStage = (byte)-1;
                this.calls = Objects.requireNonNull(ReactorSchedulerClient.super.calls(), "calls");
                this.callsBuildStage = 1;
            }
            return this.calls;
        }

        Jobs jobs() {
            if (this.jobsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobsBuildStage == 0) {
                this.jobsBuildStage = (byte)-1;
                this.jobs = Objects.requireNonNull(ReactorSchedulerClient.super.jobs(), "jobs");
                this.jobsBuildStage = 1;
            }
            return this.jobs;
        }

        Map<String, String> getRequestTags() {
            if (this.requestTagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requestTagsBuildStage == 0) {
                this.requestTagsBuildStage = (byte)-1;
                this.requestTags = ReactorSchedulerClient.createUnmodifiableMap(true, false, ReactorSchedulerClient.super.getRequestTags());
                this.requestTagsBuildStage = 1;
            }
            return this.requestTags;
        }

        void requestTags(Map<String, String> requestTags) {
            this.requestTags = requestTags;
            this.requestTagsBuildStage = 1;
        }

        Mono<String> getRoot() {
            if (this.rootBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rootBuildStage == 0) {
                this.rootBuildStage = (byte)-1;
                this.root = Objects.requireNonNull(ReactorSchedulerClient.super.getRoot(), "root");
                this.rootBuildStage = 1;
            }
            return this.root;
        }

        void root(Mono<String> root) {
            this.root = root;
            this.rootBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.callsBuildStage == -1) {
                attributes.add("calls");
            }
            if (this.jobsBuildStage == -1) {
                attributes.add("jobs");
            }
            if (this.requestTagsBuildStage == -1) {
                attributes.add("requestTags");
            }
            if (this.rootBuildStage == -1) {
                attributes.add("root");
            }
            return "Cannot build ReactorSchedulerClient, attribute initializers form cycle " + attributes;
        }
    }
}

