/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.reactor.scheduler.v1;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.QueryBuilder;
import org.cloudfoundry.reactor.util.AbstractReactorOperations;
import org.cloudfoundry.reactor.util.UriQueryParameters;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class AbstractSchedulerV1Operations
extends AbstractReactorOperations {
    protected AbstractSchedulerV1Operations(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    protected final <T> Mono<T> delete(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.delete().uri(this.queryTransformer(requestPayload).andThen(uriTransformer)).send(requestPayload).response().parseBody(responseType));
    }

    protected final <T> Mono<T> get(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.get().uri(this.queryTransformer(requestPayload).andThen(uriTransformer)).response().parseBody(responseType));
    }

    protected final <T> Mono<T> post(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.post().uri(this.queryTransformer(requestPayload).andThen(uriTransformer)).send(requestPayload).response().parseBody(responseType));
    }

    private Function<UriComponentsBuilder, UriComponentsBuilder> queryTransformer(Object requestPayload) {
        return builder -> {
            Stream parameters = new QueryBuilder().build(requestPayload);
            UriQueryParameters.set((UriComponentsBuilder)builder, (Stream)parameters);
            return builder;
        };
    }
}

