/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.reactor.scheduler.v1.calls;

import io.pivotal.reactor.scheduler.v1.AbstractSchedulerV1Operations;
import io.pivotal.scheduler.v1.calls.Calls;
import io.pivotal.scheduler.v1.calls.CreateCallRequest;
import io.pivotal.scheduler.v1.calls.CreateCallResponse;
import io.pivotal.scheduler.v1.calls.DeleteCallRequest;
import io.pivotal.scheduler.v1.calls.DeleteCallScheduleRequest;
import io.pivotal.scheduler.v1.calls.ExecuteCallRequest;
import io.pivotal.scheduler.v1.calls.ExecuteCallResponse;
import io.pivotal.scheduler.v1.calls.GetCallRequest;
import io.pivotal.scheduler.v1.calls.GetCallResponse;
import io.pivotal.scheduler.v1.calls.ListCallHistoriesRequest;
import io.pivotal.scheduler.v1.calls.ListCallHistoriesResponse;
import io.pivotal.scheduler.v1.calls.ListCallScheduleHistoriesRequest;
import io.pivotal.scheduler.v1.calls.ListCallScheduleHistoriesResponse;
import io.pivotal.scheduler.v1.calls.ListCallSchedulesRequest;
import io.pivotal.scheduler.v1.calls.ListCallSchedulesResponse;
import io.pivotal.scheduler.v1.calls.ListCallsRequest;
import io.pivotal.scheduler.v1.calls.ListCallsResponse;
import io.pivotal.scheduler.v1.calls.ScheduleCallRequest;
import io.pivotal.scheduler.v1.calls.ScheduleCallResponse;
import java.util.Map;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import reactor.core.publisher.Mono;

public class ReactorCalls
extends AbstractSchedulerV1Operations
implements Calls {
    public ReactorCalls(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    public Mono<CreateCallResponse> create(CreateCallRequest request) {
        return this.post(request, CreateCallResponse.class, builder -> builder.pathSegment(new String[]{"calls"})).checkpoint();
    }

    public Mono<Void> delete(DeleteCallRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"calls", request.getCallId()})).checkpoint();
    }

    public Mono<Void> deleteSchedule(DeleteCallScheduleRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"calls", request.getCallId(), "schedules", request.getScheduleId()})).checkpoint();
    }

    public Mono<ExecuteCallResponse> execute(ExecuteCallRequest request) {
        return this.post(request, ExecuteCallResponse.class, builder -> builder.pathSegment(new String[]{"calls", request.getCallId(), "execute"})).checkpoint();
    }

    public Mono<GetCallResponse> get(GetCallRequest request) {
        return this.get(request, GetCallResponse.class, builder -> builder.pathSegment(new String[]{"calls", request.getCallId()})).checkpoint();
    }

    public Mono<ListCallsResponse> list(ListCallsRequest request) {
        return this.get(request, ListCallsResponse.class, builder -> builder.pathSegment(new String[]{"calls"})).checkpoint();
    }

    public Mono<ListCallHistoriesResponse> listHistories(ListCallHistoriesRequest request) {
        return this.get(request, ListCallHistoriesResponse.class, builder -> builder.pathSegment(new String[]{"calls", request.getCallId(), "history"})).checkpoint();
    }

    public Mono<ListCallScheduleHistoriesResponse> listScheduleHistories(ListCallScheduleHistoriesRequest request) {
        return this.get(request, ListCallScheduleHistoriesResponse.class, builder -> builder.pathSegment(new String[]{"calls", request.getCallId(), "schedules", request.getScheduleId(), "history"})).checkpoint();
    }

    public Mono<ListCallSchedulesResponse> listSchedules(ListCallSchedulesRequest request) {
        return this.get(request, ListCallSchedulesResponse.class, builder -> builder.pathSegment(new String[]{"calls", request.getCallId(), "schedules"})).checkpoint();
    }

    public Mono<ScheduleCallResponse> schedule(ScheduleCallRequest request) {
        return this.post(request, ScheduleCallResponse.class, builder -> builder.pathSegment(new String[]{"calls", request.getCallId(), "schedules"})).checkpoint();
    }
}

