/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.reactor.scheduler.v1.jobs;

import io.pivotal.reactor.scheduler.v1.AbstractSchedulerV1Operations;
import io.pivotal.scheduler.v1.jobs.CreateJobRequest;
import io.pivotal.scheduler.v1.jobs.CreateJobResponse;
import io.pivotal.scheduler.v1.jobs.DeleteJobRequest;
import io.pivotal.scheduler.v1.jobs.DeleteJobScheduleRequest;
import io.pivotal.scheduler.v1.jobs.ExecuteJobRequest;
import io.pivotal.scheduler.v1.jobs.ExecuteJobResponse;
import io.pivotal.scheduler.v1.jobs.GetJobRequest;
import io.pivotal.scheduler.v1.jobs.GetJobResponse;
import io.pivotal.scheduler.v1.jobs.Jobs;
import io.pivotal.scheduler.v1.jobs.ListJobHistoriesRequest;
import io.pivotal.scheduler.v1.jobs.ListJobHistoriesResponse;
import io.pivotal.scheduler.v1.jobs.ListJobScheduleHistoriesRequest;
import io.pivotal.scheduler.v1.jobs.ListJobScheduleHistoriesResponse;
import io.pivotal.scheduler.v1.jobs.ListJobSchedulesRequest;
import io.pivotal.scheduler.v1.jobs.ListJobSchedulesResponse;
import io.pivotal.scheduler.v1.jobs.ListJobsRequest;
import io.pivotal.scheduler.v1.jobs.ListJobsResponse;
import io.pivotal.scheduler.v1.jobs.ScheduleJobRequest;
import io.pivotal.scheduler.v1.jobs.ScheduleJobResponse;
import java.util.Map;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import reactor.core.publisher.Mono;

public class ReactorJobs
extends AbstractSchedulerV1Operations
implements Jobs {
    public ReactorJobs(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    public Mono<CreateJobResponse> create(CreateJobRequest request) {
        return this.post(request, CreateJobResponse.class, builder -> builder.pathSegment(new String[]{"jobs"})).checkpoint();
    }

    public Mono<Void> delete(DeleteJobRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"jobs", request.getJobId()})).checkpoint();
    }

    public Mono<Void> deleteSchedule(DeleteJobScheduleRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"jobs", request.getJobId(), "schedules", request.getScheduleId()})).checkpoint();
    }

    public Mono<ExecuteJobResponse> execute(ExecuteJobRequest request) {
        return this.post(request, ExecuteJobResponse.class, builder -> builder.pathSegment(new String[]{"jobs", request.getJobId(), "execute"})).checkpoint();
    }

    public Mono<GetJobResponse> get(GetJobRequest request) {
        return this.get(request, GetJobResponse.class, builder -> builder.pathSegment(new String[]{"jobs", request.getJobId()})).checkpoint();
    }

    public Mono<ListJobsResponse> list(ListJobsRequest request) {
        return this.get(request, ListJobsResponse.class, builder -> builder.pathSegment(new String[]{"jobs"})).checkpoint();
    }

    public Mono<ListJobHistoriesResponse> listHistories(ListJobHistoriesRequest request) {
        return this.get(request, ListJobHistoriesResponse.class, builder -> builder.pathSegment(new String[]{"jobs", request.getJobId(), "history"})).checkpoint();
    }

    public Mono<ListJobScheduleHistoriesResponse> listScheduleHistories(ListJobScheduleHistoriesRequest request) {
        return this.get(request, ListJobScheduleHistoriesResponse.class, builder -> builder.pathSegment(new String[]{"jobs", request.getJobId(), "schedules", request.getScheduleId(), "history"})).checkpoint();
    }

    public Mono<ListJobSchedulesResponse> listSchedules(ListJobSchedulesRequest request) {
        return this.get(request, ListJobSchedulesResponse.class, builder -> builder.pathSegment(new String[]{"jobs", request.getJobId(), "schedules"})).checkpoint();
    }

    public Mono<ScheduleJobResponse> schedule(ScheduleJobRequest request) {
        return this.post(request, ScheduleJobResponse.class, builder -> builder.pathSegment(new String[]{"jobs", request.getJobId(), "schedules"})).checkpoint();
    }
}

